/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.util;

import com.ohaotian.plugin.file.FileClient;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.sdk.unionpay.SdkConfig;
import com.tydic.payment.pay.util.CertUtils;
import java.util.Map;

public class UnionPayAcpSdkConfigUtils {
    public static final String ENCODING = "UTF-8";
    private static Boolean isLoadGlobalProperties = false;

    public static void setMerInfoByMap(PayPropertiesVo payPropertiesVo, FileClient fileClient, Map<String, String> paramMap) {
        String encryptCert = paramMap.get("encryptCert");
        String rootCert = paramMap.get("rootCert");
        String middleCert = paramMap.get("middleCert");
        String signCert = paramMap.get("signCert");
        String signCertPwd = paramMap.get("signCertPwd");
        UnionPayAcpSdkConfigUtils.setMerInfo(payPropertiesVo, fileClient, encryptCert, rootCert, middleCert, signCert, signCertPwd);
    }

    public static void setMerInfo(PayPropertiesVo payPropertiesVo, FileClient fileClient, String encryptCert, String rootCert, String middleCert, String signCert, String signCertPwd) {
        if (!isLoadGlobalProperties.booleanValue()) {
            UnionPayAcpSdkConfigUtils.loadGlobalProperties(payPropertiesVo);
            isLoadGlobalProperties = true;
        }
        SdkConfig sdkConfig = SdkConfig.getConfig();
        sdkConfig.setRootCertPath(CertUtils.getCertFilePathByCertId(rootCert, fileClient));
        sdkConfig.setMiddleCertPath(CertUtils.getCertFilePathByCertId(middleCert, fileClient));
        sdkConfig.setEncryptCertPath(CertUtils.getCertFilePathByCertId(encryptCert, fileClient));
        sdkConfig.setSignCertPath(CertUtils.getCertFilePathByCertId(signCert, fileClient));
        sdkConfig.setSignCertPwd(signCertPwd);
    }

    private static void loadGlobalProperties(PayPropertiesVo payPropertiesVo) {
        SdkConfig sdkConfig = SdkConfig.getConfig();
        sdkConfig.setVersion("5.1.0");
        sdkConfig.setSignMethod("01");
        sdkConfig.setIfValidateCNName(payPropertiesVo.getAcpSdkIfValidateCnName().booleanValue());
        sdkConfig.setIfValidateRemoteCert(payPropertiesVo.getAcpSdkIfValidateRemoteCert().booleanValue());
        sdkConfig.setBackUrl(payPropertiesVo.getUnionPayAcpNotifyUrl());
        sdkConfig.setFrontUrl(payPropertiesVo.getUnionPayAcpFrontUrl());
        sdkConfig.setSignCertType("PKCS12");
        sdkConfig.setFrontRequestUrl(payPropertiesVo.getAcpSdkFrontTransUrl());
        sdkConfig.setBackRequestUrl(payPropertiesVo.getAcpSdkBackTransUrl());
        sdkConfig.setSingleQueryUrl(payPropertiesVo.getAcpSdkSingleQueryUrl());
        sdkConfig.setBatchTransUrl(payPropertiesVo.getAcpSdkBatchTransUrl());
        sdkConfig.setFileTransUrl(payPropertiesVo.getAcpSdkFileTransUrl());
        sdkConfig.setAppRequestUrl(payPropertiesVo.getAcpSdkAppTransUrl());
        sdkConfig.setCardRequestUrl(payPropertiesVo.getAcpSdkCardTransUrl());
    }
}

