/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.CharsetUtil;
import com.tydic.payment.bill.constant.BillConstant;
import com.tydic.payment.bill.exception.BillDownAndTransException;
import com.tydic.payment.bill.util.HttpUtils;
import com.tydic.payment.pay.ability.ChinaPayBillUploadAbilityService;
import com.tydic.payment.pay.ability.bo.ChinaPayBillUploadReqBO;
import com.tydic.payment.pay.ability.bo.ChinaPayBillUploadRspBO;
import com.tydic.payment.pay.dao.PPaybillFileMapper;
import com.tydic.payment.pay.dao.po.PPaybillFilePO;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.payable.api.bo.PayBillAbleDownloadReqBo;
import com.tydic.payment.pay.payable.api.bo.PayBillAbleDownloadRspBo;
import com.tydic.payment.pay.payable.api.bo.PayBillAbleDownloadRspDataBo;
import com.tydic.payment.pay.util.ChinaPayFtpUtil;
import com.tydic.payment.pay.util.PayProRspUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"PAYMENT_GROUP_DEV/2.0.0/com.tydic.payment.pay.ability.ChinaPayBillUploadAbilityService"})
public class ChinaPayBillUploadAbilityServiceImpl
implements ChinaPayBillUploadAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ChinaPayBillUploadAbilityServiceImpl.class);
    @Value(value="${bill.unipay.host:39.107.158.51}")
    private String chinapayHost;
    @Value(value="${bill.unipay.port:22}")
    private int chinapayPort;
    @Value(value="${bill.unipay.user:admin}")
    private String chinapayUser;
    @Value(value="${bill.unipay.password:!#$qaxsw2}")
    private String chinapayPwd;
    @Value(value="${bill.unipay.targetPrefix:/home/admin/bill}")
    private String targetPrefix;
    @Value(value="${bill.unipay.accessUrl:https://ego.chinacoal.com/ftptest}")
    private String accessUrl;
    private static final String TRAN_TYPE_REFUND = "0401";
    private final PPaybillFileMapper pPaybillFileMapper;

    public ChinaPayBillUploadAbilityServiceImpl(PPaybillFileMapper pPaybillFileMapper) {
        this.pPaybillFileMapper = pPaybillFileMapper;
    }

    @PostMapping(value={"uploadBillFile"})
    public ChinaPayBillUploadRspBO uploadBillFile(@RequestBody ChinaPayBillUploadReqBO reqBO) {
        ChinaPayBillUploadRspBO rspBO = new ChinaPayBillUploadRspBO();
        rspBO.setCode("0000");
        rspBO.setRspMessage("\u201cChinapayOK");
        if (StringUtils.isEmpty((Object)reqBO.getDownload())) {
            rspBO.setRspMessage("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[download:\u4e0b\u8f7d\u6587\u4ef6\u5730\u5740]\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        PPaybillFilePO pPaybillFileReqPo = new PPaybillFilePO();
        pPaybillFileReqPo.setDownload(reqBO.getDownload());
        pPaybillFileReqPo.setCreateTime(this.pPaybillFileMapper.getDdDate());
        String[] fileNameArray = reqBO.getDownload().split("/");
        String fileName = fileNameArray[fileNameArray.length - 1];
        String[] fileNameAnalysisArray = fileName.split("_");
        pPaybillFileReqPo.setExtendedField1(fileNameAnalysisArray[0]);
        pPaybillFileReqPo.setExtendedField2(fileNameAnalysisArray[1]);
        int quantity = this.pPaybillFileMapper.insert(pPaybillFileReqPo);
        if (quantity < 1) {
            throw new BusinessException("8888", "\u5bf9\u8d26\u6587\u4ef6\u5730\u5740\u4fdd\u5b58\u5931\u8d25");
        }
        InputStream inputStream = HttpUtils.httpDownload(reqBO.getDownload());
        Map<String, Object> uploadMap = ChinaPayFtpUtil.uploadFile(this.chinapayHost, this.chinapayPort, this.chinapayUser, this.chinapayPwd, this.targetPrefix + "/" + fileNameAnalysisArray[0], fileName, inputStream, this.accessUrl);
        log.info("ftp\u4e0a\u4f20\u7ed3\u679c\uff1a{}", uploadMap);
        if (uploadMap.containsKey("filepath")) {
            pPaybillFileReqPo.setFilePath(String.valueOf(uploadMap.get("filepath")));
            quantity = this.pPaybillFileMapper.updateById(pPaybillFileReqPo);
            if (quantity < 1) {
                throw new BusinessException("8888", "\u5bf9\u8d26\u6587\u4ef6\u5730\u5740\u66f4\u65b0\u5931\u8d25");
            }
        }
        return rspBO;
    }

    @PostMapping(value={"downLoadBillFile"})
    public PayBillAbleDownloadRspBo downLoadBillFile(@RequestBody PayBillAbleDownloadReqBo reqBo) {
        PayBillAbleDownloadRspBo rspBo = PayProRspUtil.generateSucRspBo(PayBillAbleDownloadRspBo.class);
        if (StringUtils.isEmpty((Object)reqBo.getBillDate())) {
            throw new BusinessException("8888", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[billDate:\u5bf9\u8d26\u65e5\u671f]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Map)reqBo.getParaMap())) {
            throw new BusinessException("8888", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[paraMap:\u5546\u6237\u53c2\u6570]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!reqBo.getParaMap().containsKey("MerId")) {
            throw new BusinessException("8888", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[paraMap:\u5546\u6237\u53c2\u6570]\u4e2d\uff0c[MerId:\u5546\u6237Id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String merId = (String)reqBo.getParaMap().get("MerId");
        Long billDate = reqBo.getBillDate();
        PPaybillFilePO pPaybillFileReqPo = new PPaybillFilePO();
        pPaybillFileReqPo.setExtendedField1(merId);
        pPaybillFileReqPo.setExtendedField2(String.valueOf(reqBo.getBillDate()));
        List<PPaybillFilePO> pPaybillFilePoList = this.pPaybillFileMapper.getList(pPaybillFileReqPo);
        if (CollectionUtils.isEmpty(pPaybillFilePoList)) {
            return rspBo;
        }
        PPaybillFilePO billFileInfoPo = pPaybillFilePoList.get(0);
        String localPath = billFileInfoPo.getFilePath();
        localPath = localPath.replace(this.accessUrl, "");
        List dataList = rspBo.getRspDataBos();
        try {
            FileOutputStream outputStream = new FileOutputStream(localPath);
        }
        catch (FileNotFoundException e) {
            throw new BillDownAndTransException("\u94f6\u8054\u5bf9\u8d26\uff0c\u521b\u5efa\u672c\u5730\u6587\u4ef6\u5f02\u5e38:" + e.getMessage());
        }
        InputStream inputStream = HttpUtils.httpDownload(billFileInfoPo.getDownload());
        File file = new File(localPath);
        ChinaPayFtpUtil.copyInputStreamToFile(inputStream, file);
        log.info("========\u5bf9\u8d26\u6587\u4ef6\u4e0b\u8f7d\u5b8c\u6210\uff0c\u6587\u4ef6\u4fdd\u5b58\u5728\u76ee\u5f55\uff1a{}", (Object)localPath);
        ArrayList fileDataList = new ArrayList();
        try {
            ZipEntry entry;
            ZipFile zf = new ZipFile(localPath, CharsetUtil.CHARSET_UTF_8);
            ZipInputStream zin = new ZipInputStream((InputStream)new FileInputStream(localPath), CharsetUtil.CHARSET_UTF_8);
            while ((entry = zin.getNextEntry()) != null && !entry.isDirectory()) {
                if (!entry.getName().endsWith(".txt")) continue;
                IoUtil.readLines((InputStream)zf.getInputStream(entry), (Charset)CharsetUtil.CHARSET_UTF_8, fileDataList);
            }
            zin.closeEntry();
            zin.close();
            zf.close();
        }
        catch (Exception e) {
            throw new BillDownAndTransException("\u94f6\u8054\u5904\u7406\u538b\u7f29\u6587\u4ef6\u5f02\u5e38:" + e.getMessage());
        }
        if (CollectionUtils.isEmpty(fileDataList)) {
            log.info("=======\u5546\u6237[{}]\u5728\u65e5\u671f[{}]\u7684\u5bf9\u8d26\u6587\u4ef6\u8bb0\u5f55\u6d41\u6c34\u4e3a\u7a7a", (Object)merId, (Object)billDate);
            rspBo.setRespDesc("\u5546\u6237" + merId + "\u5728\u65e5\u671f" + billDate + "\u7684\u5bf9\u8d26\u6587\u4ef6\u8bb0\u5f55\u6d41\u6c34\u4e3a\u7a7a");
            return rspBo;
        }
        for (int i = 0; i < fileDataList.size(); ++i) {
            if (i < 1) continue;
            if (i == fileDataList.size() - 1) break;
            String data = (String)fileDataList.get(i);
            String[] split = data.split(Pattern.quote("|"), -1);
            if (split.length != 23) {
                throw new BillDownAndTransException("\u94f6\u8054\u5bf9\u8d26\u6587\u4ef6\u6570\u636e\u6709\u8bef\uff0c\u7b2c" + i + "\u884c\u7684\u6570\u636e\u957f\u5ea6\u4e3a:" + split.length);
            }
            PayBillAbleDownloadRspDataBo dataBo = new PayBillAbleDownloadRspDataBo();
            dataList.add(dataBo);
            ChinaPayBillUploadAbilityServiceImpl.fillDataBo(data, dataBo);
            System.out.println(data);
        }
        log.info("========\u6587\u4ef6\u89e3\u6790\u5b8c\u6210========");
        return rspBo;
    }

    private static void fillDataBo(String data, PayBillAbleDownloadRspDataBo dataBo) {
        String[] split = data.split(Pattern.quote("|"), -1);
        dataBo.setPaymentInsId(BillConstant.PaymentIns.CHINA_UNION_PAY.getPaymentInsId());
        String tranType = split[8];
        String orderType = "01";
        if (TRAN_TYPE_REFUND.equals(tranType)) {
            orderType = "02";
        }
        dataBo.setOrderType(orderType);
        String oriOrderNo = split[5];
        dataBo.setTypeOrderId(oriOrderNo);
        Long liqDate = Long.parseLong(split[4]);
        dataBo.setBillDate(Long.valueOf(liqDate - 1L));
        String acqSeqId = split[20];
        dataBo.setTypeTransId(acqSeqId);
        Long orderAmt = Long.parseLong(split[12]);
        dataBo.setRealFee(orderAmt);
        dataBo.setBillFlag("0");
        String merId = split[2];
        dataBo.setPaymentMchId(merId);
        dataBo.setPaymentInsObj((Object)data);
        String completeDateTime = split[10] + split[11];
        dataBo.setTradeTime(completeDateTime);
    }
}

