/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ali.service.impl;

import com.alipay.api.AlipayRequest;
import com.alipay.api.AlipayResponse;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipayTradePayRequest;
import com.alipay.api.response.AlipayTradePayResponse;
import com.alipay.api.response.AlipayTradeQueryResponse;
import com.tydic.payment.pay.ali.common.Configs;
import com.tydic.payment.pay.ali.common.TradeStatus;
import com.tydic.payment.pay.ali.model.AlipayF2FPayResult;
import com.tydic.payment.pay.ali.model.AlipayTradePayRequestBuilder;
import com.tydic.payment.pay.ali.model.AlipayTradeQueryRequestBuilder;
import com.tydic.payment.pay.ali.service.impl.AbsAlipayTradeService;
import org.apache.commons.lang.StringUtils;

public class AlipayTradeServiceImpl
extends AbsAlipayTradeService {
    public AlipayTradeServiceImpl(ClientBuilder builder, String flag) {
        if (StringUtils.isEmpty((String)builder.getGatewayUrl())) {
            throw new NullPointerException("gatewayUrl should not be NULL!");
        }
        if (!StringUtils.isEmpty((String)flag)) {
            builder.setGatewayUrl(Configs.getOpenApiDomain());
        }
        if (StringUtils.isEmpty((String)builder.getAppid())) {
            throw new NullPointerException("appid should not be NULL!");
        }
        if (StringUtils.isEmpty((String)builder.getPrivateKey())) {
            throw new NullPointerException("privateKey should not be NULL!");
        }
        if (StringUtils.isEmpty((String)builder.getFormat())) {
            throw new NullPointerException("format should not be NULL!");
        }
        if (StringUtils.isEmpty((String)builder.getCharset())) {
            throw new NullPointerException("charset should not be NULL!");
        }
        if (StringUtils.isEmpty((String)builder.getAlipayPublicKey())) {
            throw new NullPointerException("alipayPublicKey should not be NULL!");
        }
        if (StringUtils.isEmpty((String)builder.getSignType())) {
            throw new NullPointerException("signType should not be NULL!");
        }
        this.client = new DefaultAlipayClient(builder.getGatewayUrl(), builder.getAppid(), builder.getPrivateKey(), builder.getFormat(), builder.getCharset(), builder.getAlipayPublicKey(), builder.getSignType());
    }

    @Override
    public AlipayF2FPayResult tradePay(AlipayTradePayRequestBuilder builder) {
        this.validateBuilder(builder);
        String outTradeNo = builder.getOutTradeNo();
        AlipayTradePayRequest request = new AlipayTradePayRequest();
        request.setNotifyUrl(builder.getNotifyUrl());
        String appAuthToken = builder.getAppAuthToken();
        request.putOtherTextParam("app_auth_token", builder.getAppAuthToken());
        request.setBizContent(builder.toJsonString());
        this.log.info((Object)("trade.pay bizContent:" + request.getBizContent()));
        AlipayTradePayResponse response = (AlipayTradePayResponse)this.getResponse(this.client, (AlipayRequest)request);
        AlipayF2FPayResult result = new AlipayF2FPayResult(response);
        if (response != null && "10000".equals(response.getCode())) {
            result.setTradeStatus(TradeStatus.SUCCESS);
        } else {
            if (response != null && "10003".equals(response.getCode())) {
                AlipayTradeQueryRequestBuilder queryBuiler = new AlipayTradeQueryRequestBuilder().setAppAuthToken(appAuthToken).setOutTradeNo(outTradeNo);
                AlipayTradeQueryResponse loopQueryResponse = this.loopQueryResult(queryBuiler);
                return this.checkQueryAndCancel(outTradeNo, appAuthToken, result, loopQueryResponse);
            }
            if (this.tradeError((AlipayResponse)response)) {
                AlipayTradeQueryRequestBuilder queryBuiler = new AlipayTradeQueryRequestBuilder().setAppAuthToken(appAuthToken).setOutTradeNo(outTradeNo);
                AlipayTradeQueryResponse queryResponse = this.tradeQuery(queryBuiler);
                return this.checkQueryAndCancel(outTradeNo, appAuthToken, result, queryResponse);
            }
            result.setTradeStatus(TradeStatus.FAILED);
        }
        return result;
    }

    public static class ClientBuilder {
        private String gatewayUrl;
        private String appid;
        private String privateKey;
        private String format;
        private String charset;
        private String alipayPublicKey;
        private String signType;

        public AlipayTradeServiceImpl build() {
            if (StringUtils.isEmpty((String)this.gatewayUrl)) {
                this.gatewayUrl = Configs.getOpenApiDomain();
            }
            if (StringUtils.isEmpty((String)this.appid)) {
                this.appid = Configs.getAppid();
            }
            if (StringUtils.isEmpty((String)this.privateKey)) {
                this.privateKey = Configs.getPrivateKey();
            }
            if (StringUtils.isEmpty((String)this.format)) {
                this.format = "json";
            }
            if (StringUtils.isEmpty((String)this.charset)) {
                this.charset = "utf-8";
            }
            if (StringUtils.isEmpty((String)this.alipayPublicKey)) {
                this.alipayPublicKey = Configs.getAlipayPublicKey();
            }
            if (StringUtils.isEmpty((String)this.signType)) {
                this.signType = Configs.getSignType();
            }
            return new AlipayTradeServiceImpl(this, "");
        }

        public AlipayTradeServiceImpl build(String appid, String privateKey, String alipayPublicKey, String flag) {
            if (StringUtils.isEmpty((String)this.gatewayUrl)) {
                this.gatewayUrl = Configs.getOpenApiDomain();
            }
            this.appid = appid;
            this.privateKey = privateKey;
            this.alipayPublicKey = alipayPublicKey;
            if (StringUtils.isEmpty((String)this.format)) {
                this.format = "json";
            }
            if (StringUtils.isEmpty((String)this.charset)) {
                this.charset = "utf-8";
            }
            if (StringUtils.isEmpty((String)this.signType)) {
                this.signType = Configs.getSignType();
            }
            return new AlipayTradeServiceImpl(this, flag);
        }

        public ClientBuilder setAlipayPublicKey(String alipayPublicKey) {
            this.alipayPublicKey = alipayPublicKey;
            return this;
        }

        public ClientBuilder setAppid(String appid) {
            this.appid = appid;
            return this;
        }

        public ClientBuilder setCharset(String charset) {
            this.charset = charset;
            return this;
        }

        public ClientBuilder setFormat(String format) {
            this.format = format;
            return this;
        }

        public ClientBuilder setGatewayUrl(String gatewayUrl) {
            this.gatewayUrl = gatewayUrl;
            return this;
        }

        public ClientBuilder setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public ClientBuilder setSignType(String signType) {
            this.signType = signType;
            return this;
        }

        public String getAlipayPublicKey() {
            return this.alipayPublicKey;
        }

        public String getSignType() {
            return this.signType;
        }

        public String getAppid() {
            return this.appid;
        }

        public String getCharset() {
            return this.charset;
        }

        public String getFormat() {
            return this.format;
        }

        public String getGatewayUrl() {
            return this.gatewayUrl;
        }

        public String getPrivateKey() {
            return this.privateKey;
        }
    }
}

