/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.bill.executor;

import com.tydic.payment.bill.able.BillDownAndTransAble;
import com.tydic.payment.bill.able.BillPaymentInsAble;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class BillPaymentInsRegister {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<Long, BillDownAndTransAble> supportPayment = new HashMap<Long, BillDownAndTransAble>(8);

    public void register(BillPaymentInsAble billPaymentInsAble, BillDownAndTransAble billDownAndTransAble) {
        Assert.notNull((Object)billPaymentInsAble, (String)"billPaymentInsAble must not be null");
        Assert.notNull((Object)billDownAndTransAble, (String)"billDownAndTransAble must not be null");
        this.logger.info("register info paymentInsId [" + billPaymentInsAble.getPaymentInsId() + "] class [{}]", (Object)billDownAndTransAble.getClass().getName());
        if (this.supportPayment.containsKey(billPaymentInsAble.getPaymentInsId())) {
            throw new IllegalArgumentException("PaymentInsId already exist");
        }
        this.supportPayment.put(billPaymentInsAble.getPaymentInsId(), billDownAndTransAble);
    }

    public BillDownAndTransAble getBillDownAndTransAbleByPaymentInsId(Long paymentInsId) {
        Assert.notNull((Object)paymentInsId, (String)"paymentInsId must not be null");
        if (this.supportPayment.containsKey(paymentInsId)) {
            return this.supportPayment.get(paymentInsId);
        }
        throw new IllegalArgumentException("PaymentInsId is not exist");
    }
}

