/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.comb.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.PorderRefundTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomRspBo;
import com.tydic.payment.pay.atom.bo.PorderRefundTransAtomReqBo;
import com.tydic.payment.pay.atom.bo.PorderRefundTransAtomRspBo;
import com.tydic.payment.pay.busi.PayProUpdatePayOrderInfoAfterRefundBusiService;
import com.tydic.payment.pay.busi.PayProUpdateRefundOrderInfoAfterRefundBusiService;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackRspBo;
import com.tydic.payment.pay.busi.bo.PayProUpdatePayOrderInfoAfterRefundBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProUpdatePayOrderInfoAfterRefundBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProUpdateRefundOrderInfoAfterRefundBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProUpdateRefundOrderInfoAfterRefundBusiRspBo;
import com.tydic.payment.pay.comb.PayProProcessRefundNotifyCombService;
import com.tydic.payment.pay.comb.bo.PayProProcessRefundNotifyCombReqBo;
import com.tydic.payment.pay.comb.bo.PayProProcessRefundNotifyCombRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.PayProAsyncNotice;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.util.PayAbleManager;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@EnableAsync
@RestController
@RequestMapping(value={"PAYMENT_GROUP_DEV/2.0.0/com.tydic.payment.pay.comb.PayProProcessRefundNotifyCombService"})
public class PayProProcessRefundNotifyCombServiceImpl
implements PayProProcessRefundNotifyCombService {
    private static final Logger log = LoggerFactory.getLogger(PayProProcessRefundNotifyCombServiceImpl.class);
    @Autowired
    private PayAbleManager payAbleManager;
    @Autowired
    private PayProAsyncNotice payProAsyncNotice;
    @Autowired
    private PorderRefundTransAtomService porderRefundTransAtomService;
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private PayProUpdateRefundOrderInfoAfterRefundBusiService payProUpdateRefundOrderInfoAfterRefundBusiService;
    @Autowired
    private PayProUpdatePayOrderInfoAfterRefundBusiService payProUpdatePayOrderInfoAfterRefundBusiService;
    private static final String ORDER_REFUND_ID_SPLIT = ",";

    @PostMapping(value={"processNotice"})
    public PayProProcessRefundNotifyCombRspBo processNotice(@RequestBody PayProProcessRefundNotifyCombReqBo reqBo) {
        PayProProcessRefundNotifyCombRspBo retBo = new PayProProcessRefundNotifyCombRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            retBo.setRespCode("213014");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        PayAble payAble = 170L == reqBo.getPayMethod() || 171L == reqBo.getPayMethod() ? this.payAbleManager.getPayAbleByPayMethod(170L) : this.payAbleManager.getPayAbleByPayMethod(reqBo.getPayMethod());
        PayAbleCallBackReqBo callBackReqBo = new PayAbleCallBackReqBo();
        callBackReqBo.setReqData(reqBo.getContent());
        callBackReqBo.setRefund(true);
        PayAbleCallBackRspBo callBackRspBo = payAble.dealCallBack(callBackReqBo);
        log.info("\u8c03\u7528\u652f\u4ed8\u65b9\u5f0f{}\u7684able\u5904\u7406\u56de\u8c03\u7684\u7ed3\u679c\u4e3a\uff1a{}", (Object)reqBo.getPayMethod(), JSON.toJSON((Object)callBackRspBo));
        if (!"0000".equals(callBackRspBo.getRespCode())) {
            log.error("able\u5904\u7406\u9000\u6b3e\u56de\u8c03\u5931\u8d25\uff1a{}", (Object)callBackRspBo.getRespDesc());
            retBo.setRespCode("213014");
            retBo.setRespDesc(callBackRspBo.getRespDesc());
            return retBo;
        }
        String validateAbleRspArgStr = this.validateAbleRspArg(callBackRspBo);
        if (!StringUtils.isEmpty((Object)validateAbleRspArgStr)) {
            log.error("able\u8fd4\u56de\u51fa\u53c2\u6821\u9a8c\u5931\u8d25\uff1a{}", (Object)validateAbleRspArgStr);
            retBo.setRespCode("213014");
            retBo.setRespDesc("able\u8fd4\u56de\u51fa\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateAbleRspArgStr);
            return retBo;
        }
        String refundOrderId = callBackRspBo.getRefundOrderId();
        String refundTransId = callBackRspBo.getRefundNotifyTransId();
        PorderRefundTransAtomReqBo refundTransAtomReqBo = new PorderRefundTransAtomReqBo();
        refundTransAtomReqBo.setRefundOrderId(refundOrderId);
        refundTransAtomReqBo.setPayMethod(reqBo.getPayMethod());
        List<PorderRefundTransAtomRspBo> refundTransAtoms = this.porderRefundTransAtomService.queryOrderRefundTransByCondition(refundTransAtomReqBo);
        if (CollectionUtils.isEmpty(refundTransAtoms)) {
            log.error("\u652f\u4ed8\u6210\u529f\u5f02\u6b65\u56de\u8c03\u6839\u636e\u3010refundOrderId={}\u3011\u67e5\u8be2\u652f\u4ed8\u8bf7\u6c42\u8868\u65e0\u6570\u636e", (Object)refundOrderId);
            retBo.setRespCode("213014");
            retBo.setRespDesc("\u652f\u4ed8\u6210\u529f\u5f02\u6b65\u56de\u8c03\u6839\u636e\u3010refundOrderId=" + refundOrderId + "\u3011\u67e5\u8be2\u652f\u4ed8\u8bf7\u6c42\u8868\u65e0\u6570\u636e");
            return retBo;
        }
        PorderRefundTransAtomRspBo refundTrans = refundTransAtoms.get(0);
        Long orderId = refundTrans.getOrderId();
        if ("B10".equals(refundTrans.getOrderStatus())) {
            retBo.setRespCode("0000");
            retBo.setRespDesc("\u9000\u6b3e\u6210\u529f");
            retBo.setResult(callBackRspBo.getDealResult());
            return retBo;
        }
        PorderPo orderInfo = this.payOrderAtomService.queryPorderInfo(orderId);
        if (orderInfo == null) {
            log.info("\u9000\u6b3e\u6210\u529f\u5f02\u6b65\u56de\u8c03\u6839\u636e\u3010orderId={}\u3011\u67e5\u8be2\u8ba2\u5355\u8868\u65e0\u6570\u636e", (Object)orderId);
            retBo.setRespCode("213014");
            retBo.setRespDesc("\u9000\u6b3e\u6210\u529f\u5f02\u6b65\u56de\u8c03\u6839\u636e\u3010orderId=" + orderId + "\u3011\u67e5\u8be2\u8ba2\u5355\u8868\u65e0\u6570\u636e");
            return retBo;
        }
        String result = this.updateOriOrderInfo(orderInfo, refundTrans);
        if (!StringUtils.isEmpty((Object)result)) {
            retBo.setRespCode("213014");
            retBo.setRespDesc(result);
            return retBo;
        }
        PayProUpdateRefundOrderInfoAfterRefundBusiReqBo updateRefundBo = new PayProUpdateRefundOrderInfoAfterRefundBusiReqBo();
        updateRefundBo.setOrderId(refundTrans.getOrderId());
        updateRefundBo.setRefundOrderId(refundOrderId);
        updateRefundBo.setRefundTransId(refundTransId);
        updateRefundBo.setRefundFee(refundTrans.getPayFee());
        updateRefundBo.setTradeTime(callBackRspBo.getTradeTime());
        PayProUpdateRefundOrderInfoAfterRefundBusiRspBo updateRefundRetBo = this.payProUpdateRefundOrderInfoAfterRefundBusiService.updateRefundInfo(updateRefundBo);
        if (!"0000".equals(updateRefundRetBo.getRespCode())) {
            log.error("\u8c03\u7528\u66f4\u65b0\u9000\u6b3e\u6570\u636e\u670d\u52a1\u5931\u8d25\uff1a{}", (Object)updateRefundRetBo.getRespDesc());
            retBo.setRespCode("213014");
            retBo.setRespDesc("\u8c03\u7528\u66f4\u65b0\u9000\u6b3e\u6570\u636e\u670d\u52a1\u5931\u8d25\uff1a" + updateRefundRetBo.getRespDesc());
            return retBo;
        }
        this.payProAsyncNotice.sendMessage(orderId, refundTransId);
        retBo.setRefundOrderId(refundOrderId);
        retBo.setResult(callBackRspBo.getDealResult());
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String updateOriOrderInfo(PorderPo refundOrderInfo, PorderRefundTransAtomRspBo refundTrans) {
        PorderPo oriOrderInfo = this.payOrderAtomService.queryPorderByOutOrderIdAndBusiId(refundOrderInfo.getOutRefundNo(), refundOrderInfo.getBusiId());
        if (null == oriOrderInfo) {
            log.error("\u6ca1\u6709\u67e5\u8be2\u5230\u539f\u652f\u4ed8\u5916\u90e8\u8ba2\u5355[{}]\u7684\u4fe1\u606f", (Object)refundOrderInfo.getOutRefundNo());
            return "\u6ca1\u6709\u67e5\u8be2\u5230\u539f\u652f\u4ed8\u5916\u90e8\u8ba2\u5355[" + refundOrderInfo.getOutRefundNo() + "]\u7684\u4fe1\u606f";
        }
        PorderPayTransAtomReqBo orderPayTransAtomReq = new PorderPayTransAtomReqBo();
        String payOrderId = refundTrans.getPayOrderId();
        orderPayTransAtomReq.setPayOrderId(payOrderId);
        orderPayTransAtomReq.setPayMethod(refundTrans.getPayMethod());
        List<PorderPayTransAtomRspBo> transAtomList = this.porderPayTransAtomService.queryOrderPayTransByCondition(orderPayTransAtomReq);
        if (transAtomList == null || transAtomList.isEmpty()) {
            log.error("\u6ca1\u6709\u67e5\u8be2\u5230\u539f\u652f\u4ed8\u6d41\u6c34\u8ba2\u5355[{}]\u7684\u4fe1\u606f", (Object)payOrderId);
            return "\u6ca1\u6709\u67e5\u8be2\u5230\u539f\u652f\u4ed8\u6d41\u6c34\u8ba2\u5355[" + payOrderId + "]\u7684\u4fe1\u606f";
        }
        PorderPayTransAtomRspBo payTrans = transAtomList.get(0);
        PayProUpdatePayOrderInfoAfterRefundBusiReqBo updatePayOrderInfoAfterBo = new PayProUpdatePayOrderInfoAfterRefundBusiReqBo();
        updatePayOrderInfoAfterBo.setOrderId(oriOrderInfo.getOrderId());
        updatePayOrderInfoAfterBo.setPayOrderId(payOrderId);
        updatePayOrderInfoAfterBo.setRefundedFee(Long.valueOf(MoneyUtils.haoToFen((Long)oriOrderInfo.getRefundFee()).longValue()));
        updatePayOrderInfoAfterBo.setRefundFee(Long.valueOf(MoneyUtils.haoToFen((Long)refundTrans.getPayFee()).longValue()));
        String oldRefundOrderStr = oriOrderInfo.getOrderRefundId();
        String refundOrderStr = null;
        refundOrderStr = StringUtils.isEmpty((Object)oldRefundOrderStr) ? refundTrans.getOrderId().toString() : oldRefundOrderStr + ORDER_REFUND_ID_SPLIT + refundOrderInfo.getOrderId();
        updatePayOrderInfoAfterBo.setOrderRefundIdStr(refundOrderStr);
        PayProUpdatePayOrderInfoAfterRefundBusiRspBo updateRetBo = this.payProUpdatePayOrderInfoAfterRefundBusiService.updatePayOrderInfo(updatePayOrderInfoAfterBo);
        if (!"0000".equals(updateRetBo.getRespCode())) {
            log.error("\u66f4\u65b0\u539f\u652f\u4ed8\u8ba2\u5355\u53ca\u539f\u652f\u4ed8\u6d41\u6c34\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)updateRetBo.getRespDesc());
            return "\u66f4\u65b0\u539f\u652f\u4ed8\u8ba2\u5355\u53ca\u539f\u652f\u4ed8\u6d41\u6c34\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff1a" + updateRetBo.getRespDesc();
        }
        return null;
    }

    private String validateAbleRspArg(PayAbleCallBackRspBo callBackRspBo) {
        if (StringUtils.isEmpty((Object)callBackRspBo.getTradeTime())) {
            return "able\u5904\u7406\u56de\u8c03\u8fd4\u56de\u7684\u7ed3\u679c\uff0c\u5c5e\u6027'tradeTime'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)callBackRspBo.getRefundOrderId())) {
            return "able\u5904\u7406\u56de\u8c03\u8fd4\u56de\u7684\u7ed3\u679c\uff0c\u5c5e\u6027'refundOrderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)callBackRspBo.getRefundNotifyTransId())) {
            return "able\u5904\u7406\u56de\u8c03\u8fd4\u56de\u7684\u7ed3\u679c\uff0c\u5c5e\u6027'refundNotifyTransId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    private String validateArgs(PayProProcessRefundNotifyCombReqBo reqBo) {
        if (null == reqBo) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBo.getPayMethod()) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payMethod'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getContent())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'content'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

