/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.config.vo;

import com.tydic.payment.pay.constant.PayProPropertyKeys;
import java.util.Properties;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class PayPropertiesVo {
    @Autowired
    private Environment environment;
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private Properties properties = new Properties();

    public Properties getProperties() {
        this.initVo();
        return this.properties;
    }

    public void setValue(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public String getValueByKey(String key) {
        if (StringUtils.isEmpty((Object)key)) {
            this.LOGGER.error("\u83b7\u53d6key\u5165\u53c2\u4e3a\u7a7a\u4e86(" + key + ")");
            return null;
        }
        String value = this.properties.getProperty(key);
        this.LOGGER.info("\u6839\u636ekey(" + key + ")\u83b7\u53d6value\u4e3a(" + value + ")");
        return value;
    }

    public boolean isUseMulitpleCallBack() {
        String callBackSwitch = this.getValueByKey("mulitple.callback.switch");
        return "1".equals(callBackSwitch);
    }

    public String getFkMqTopic() {
        return this.getValueByKey("PMCFK_NOTIFY_TOPIC");
    }

    public String getPayNotifyMqTopic() {
        return this.getValueByKey("PAY_NOTIFY_TOPIC");
    }

    public String getPayNotifyMqTag() {
        return this.getValueByKey("PAY_NOTIFY_TAG");
    }

    public String getFkMqTag() {
        return this.getValueByKey("PMCFK_NOTIFY_TAG");
    }

    public String getSequenceName() {
        return this.getValueByKey("sequence_name");
    }

    public String getSequenceChoose() {
        String sequenceChoose = this.getValueByKey("sequence_choose");
        if (StringUtils.isEmpty((Object)sequenceChoose)) {
            sequenceChoose = "0";
        }
        return sequenceChoose;
    }

    public String getAbilityPayNotifyUrl() {
        return this.getValueByKey("ability_pay_notify_url");
    }

    public String getProjectName() {
        return this.getValueByKey("project_name");
    }

    public String getAliReturnUrl() {
        return this.getValueByKey("aliReturnUrl");
    }

    public String getAliPcWebReturnUrl() {
        return this.getValueByKey("aliPcWebReturnUrl");
    }

    public String getAliNotifyUrl() {
        return this.getValueByKey("aliPayNotifyUrl");
    }

    public String getAbilityWxUnifiedOrderUrl() {
        return this.getValueByKey("ability_wx_unified_order_url");
    }

    public String getAbilityAppId() {
        return this.getValueByKey("ability_app_id");
    }

    public String getAbilityAppSecret() {
        return this.getValueByKey("ability_app_secret");
    }

    public String getWxPayResultNotifyUrl() {
        return this.getValueByKey("wx_pay_result_notify_url");
    }

    public String getAbilityWxOrderQueryUrl() {
        return this.getValueByKey("ability_wx_order_query_url");
    }

    public String getAbilityWxCloseOrderUrl() {
        return this.getValueByKey("ability_wx_close_order_url");
    }

    public String getAliOpenApiDomain() {
        return this.getValueByKey("aliOpenApiDomain");
    }

    public String getAliMcloudApiDomain() {
        return this.getValueByKey("aliMcloudApiDomain");
    }

    public String getAliSignature() {
        return this.getValueByKey("aliSignature");
    }

    public String getAliSignType() {
        return this.getValueByKey("aliSignType");
    }

    public String getAbilityWxRefundUrl() {
        return this.getValueByKey("ability_wx_refund_url");
    }

    public String getAbilityWxMicropayUrl() {
        return this.getValueByKey("ability_wx_micropay_url");
    }

    public String getAbilitySwitch() {
        return this.getValueByKey("ability_switch");
    }

    public String getAbilityWxReverseUrl() {
        return this.getValueByKey("ability_wx_reverse_url");
    }

    public String getAbilityPayResultNotifyUrl() {
        return this.getValueByKey("ability_pay_result_notify_url");
    }

    public String getAbilityDownLoadBillUrl() {
        return this.getValueByKey("ability_down_load_bill_url");
    }

    public String getPayAccessIp() {
        return this.getValueByKey("PAY_ACCESS_IP");
    }

    public String getPayAccessProjectName() {
        return this.getValueByKey("PAY_ACCESS_PROJECT_NAME");
    }

    public String getPayContactIp() {
        return this.getValueByKey("PAY_CONTACT_IP");
    }

    public String getPayContactProjectName() {
        return this.getValueByKey("PAY_CONTACT_PROJECT_NAME");
    }

    public Boolean getAcpSdkIfValidateCnName() {
        if (Boolean.FALSE.toString().equalsIgnoreCase(this.getValueByKey("ACP_SDK_IF_VALIDATE_CN_NAME"))) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Boolean getAcpSdkIfValidateRemoteCert() {
        if (Boolean.FALSE.toString().equalsIgnoreCase(this.getValueByKey("ACP_SDK_IF_VALIDATE_REMOTE_CERT"))) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public String getUnionPayAcpNotifyUrl() {
        return this.getValueByKey("UNION_PAY_ACP_NOTIFY_URL");
    }

    public String getUnionPayAcpFrontUrl() {
        return this.getValueByKey("UNION_PAY_ACP_FRONT_URL");
    }

    public String getAcpSdkFrontTransUrl() {
        return this.getValueByKey("ACP_SDK_FRONT_TRANS_URL");
    }

    public String getAcpSdkBackTransUrl() {
        return this.getValueByKey("ACP_SDK_BACK_TRANS_URL");
    }

    public String getAcpSdkSingleQueryUrl() {
        return this.getValueByKey("ACP_SDK_SINGLE_QUERY_URL");
    }

    public String getAcpSdkBatchTransUrl() {
        return this.getValueByKey("ACP_SDK_BATCH_TRANS_URL");
    }

    public String getAcpSdkFileTransUrl() {
        return this.getValueByKey("ACP_SDK_FILE_TRANS_URL");
    }

    public String getAcpSdkAppTransUrl() {
        return this.getValueByKey("ACP_SDK_APP_TRANS_URL");
    }

    public String getAcpSdkCardTransUrl() {
        return this.getValueByKey("ACP_SDK_CARD_TRANS_URL");
    }

    public String getUnicodeAliH5PayReturnUrl() {
        return this.getValueByKey("UNICODE_ALI_H5_PAY_RETURN_URL");
    }

    public String getGdBankPay4Url() {
        return this.getValueByKey("GD_BANK_PAY4_URL");
    }

    public String getGdBankPayNotifyUrl() {
        return this.getValueByKey("GD_BANK_PAY4__NOTIFY_URL");
    }

    public String getGdBankPay4QueryOrderUrl() {
        return this.getValueByKey("GD_BANK_PAY4_QUERY_ORDER_URL");
    }

    public String getGdBankAliMiniProgramPrepareOrderUrl() {
        return this.getValueByKey("GD_BANK_ALI_MINI_PROGRAM_PREPARE_ORDER_URL");
    }

    public String getGdBankAliMiniProgramPayUrl() {
        return this.getValueByKey("GD_BANK_ALI_MINI_PROGRAM_PAY_URL");
    }

    public String getWXUnifiedOrderUrl() {
        return this.getValueByKey("WX_UNIFIED_ORDER_URL");
    }

    public String getWXMicoPayUrl() {
        return this.getValueByKey("WX_MICO_PAY_URL");
    }

    public String getWXOrderQueryUrl() {
        return this.getValueByKey("WX_ORDER_QUERY_URL");
    }

    public String getWXReverse() {
        return this.getValueByKey("WX_REVERSE_URL");
    }

    public String getWXRefund() {
        return this.getValueByKey("WX_REFUND_URL");
    }

    public String getWXCloseOrder() {
        return this.getValueByKey("WX_CLOSE_ORDER_URL");
    }

    public String getWXDownloadBill() {
        return this.getValueByKey("WX_DOWNLOAD_BILL_URL");
    }

    public String getWXOutRefundFlag() {
        return this.getValueByKey("WX_OUT_REFUND_FLAG");
    }

    public String getWXOutRefundUrl() {
        return this.getValueByKey("WX_OUT_REFUND_URL");
    }

    public String getQueryPayBillRequestCode() {
        return this.getValueByKey("QUERY_PAY_BILL_REQUEST_CODE");
    }

    public String getChinaBankOrderQueryUrl() {
        return this.getValueByKey("china.bank.order.query.url");
    }

    @PostConstruct
    public void initVo() {
        Set keySet = PayProPropertyKeys.keySet();
        for (String key : keySet) {
            String keyValue = this.environment.getProperty(key);
            if (StringUtils.isEmpty((Object)keyValue)) continue;
            if (key.equals("project_name") && keyValue.length() > 6) {
                throw new IllegalArgumentException("\u5c5e\u6027\uff1aproject_name \u7684\u503c\u957f\u5ea6\u8d85\u8fc76\u4e86\uff0c\u7cfb\u7edf\u5173\u952e\u53c2\u6570\u914d\u7f6e\u9519\u8bef\uff0c\u542f\u52a8\u5931\u8d25");
            }
            this.properties.setProperty(key, keyValue);
        }
        System.err.println("PayPropertiesVo\u5b8c\u6210\u586b\u5145\u5c5e\u6027\uff0c\u4e00\u5171\u586b\u5145\u4e86\uff1a(" + this.properties.size() + ")\u4e2a");
    }
}

