/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.busi.PayProAddMerchantBusiService;
import com.tydic.payment.pay.busi.bo.PayProAddMerchantBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProAddMerchantBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProMerchantInfoBo;
import com.tydic.payment.pay.busi.bo.PayProPayParaAttrInfoBo;
import com.tydic.payment.pay.busi.bo.PayProPayParaInfoBo;
import com.tydic.payment.pay.busi.bo.PayProPaymentInsInfoBo;
import com.tydic.payment.pay.busi.bo.PayProRelSysMerchantBo;
import com.tydic.payment.pay.dao.BusiSystemMerchantRelMapper;
import com.tydic.payment.pay.dao.MerChantInfoMapper;
import com.tydic.payment.pay.dao.MerchantPayMethodRelMapper;
import com.tydic.payment.pay.dao.PayMethodMapper;
import com.tydic.payment.pay.dao.PayParaInfoAttrMapper;
import com.tydic.payment.pay.dao.PayParaInfoMapper;
import com.tydic.payment.pay.dao.po.BusiSystemMerchantRelPo;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.dao.po.MerchantPayMethodRelPo;
import com.tydic.payment.pay.dao.po.PayParaInfoAttrPo;
import com.tydic.payment.pay.dao.po.PayParaInfoPo;
import com.tydic.payment.pay.exception.BusinessException;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="payProAddMerchantBusiService")
public class PayProAddMerchantBusiServiceImpl
implements PayProAddMerchantBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PayMethodMapper payMethodMapper;
    @Autowired
    private MerChantInfoMapper merChantInfoMapper;
    @Autowired
    private BusiSystemMerchantRelMapper busiSystemMerchantRelMapper;
    @Autowired
    private PayParaInfoMapper payParaInfoMapper;
    @Autowired
    private MerchantPayMethodRelMapper merchantPayMethodRelMapper;
    @Autowired
    private PayParaInfoAttrMapper payParaInfoAttrMapper;

    public PayProAddMerchantBusiRspBo addMerchant(PayProAddMerchantBusiReqBo reqBo) {
        List paymentInsInfoBoList;
        List relSysMerchantBoList;
        this.LOGGER.debug("\u65b0\u589e\u5546\u6237busi\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        PayProAddMerchantBusiRspBo rspBo = new PayProAddMerchantBusiRspBo();
        Date dbDate = this.payMethodMapper.getDBDate().getDate();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            rspBo.setRespCode("212047");
            rspBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return rspBo;
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)rspBo);
        PayProMerchantInfoBo payProMerchantInfoBo = reqBo.getMerchantInfoBo();
        Long merchantId = payProMerchantInfoBo.getMerchantId();
        MerChantInfoPo createMerchantPo = new MerChantInfoPo();
        BeanUtils.copyProperties((Object)payProMerchantInfoBo, (Object)createMerchantPo);
        createMerchantPo.setCreateTime(dbDate);
        int addMerchantRetValue = this.merChantInfoMapper.createMerChantInfo(createMerchantPo);
        if (addMerchantRetValue < 1) {
            throw new BusinessException("216031", "\u65b0\u589e\u5546\u6237\u5f02\u5e38\uff0c\u8fd4\u56de\u503c\u4e0d\u4e3a1");
        }
        if (merchantId == null) {
            merchantId = createMerchantPo.getMerchantId();
        }
        if ((relSysMerchantBoList = reqBo.getRelSysMerchantBoList()) != null) {
            for (PayProRelSysMerchantBo tmpBusiBo : relSysMerchantBoList) {
                BusiSystemMerchantRelPo createBusiPo = new BusiSystemMerchantRelPo();
                BeanUtils.copyProperties((Object)tmpBusiBo, (Object)createBusiPo);
                createBusiPo.setMerchantId(merchantId);
                createBusiPo.setCreateTime(dbDate);
                this.busiSystemMerchantRelMapper.createBusiSystemMerchantRel(createBusiPo);
            }
        }
        if ((paymentInsInfoBoList = reqBo.getPaymentInsInfoBoList()) != null) {
            for (PayProPaymentInsInfoBo tmpInsBo : paymentInsInfoBoList) {
                List payParaAttrInfoBoList;
                PayProPayParaInfoBo payParaInfoBo;
                Long paymentInsId = tmpInsBo.getPaymentInsId();
                PayParaInfoPo createParaPo = new PayParaInfoPo();
                createParaPo.setParaName("\u5546\u6237(" + merchantId + ")\u7684\u652f\u4ed8\u53c2\u6570(" + paymentInsId + ")");
                createParaPo.setPaymentInsId(paymentInsId);
                createParaPo.setState("1");
                createParaPo.setCreateTime(dbDate);
                this.payParaInfoMapper.createPayParaInfo(createParaPo);
                Long payParaId = createParaPo.getPayParaId();
                this.LOGGER.debug("\u53c2\u6570id\u4e3a\uff1a" + payParaId);
                if (payParaId == null || payParaId < 1L) {
                    throw new BusinessException("216031", "\u65b0\u589e\u5546\u6237\u5f02\u5e38\uff0c\u672a\u8fd4\u56de\u652f\u4ed8\u53c2\u6570id");
                }
                List payMethodList = tmpInsBo.getPayMethodList();
                if (payMethodList != null) {
                    for (Long payMethod : payMethodList) {
                        MerchantPayMethodRelPo createPayMethodPo = new MerchantPayMethodRelPo();
                        createPayMethodPo.setPaymentInsId(paymentInsId);
                        createPayMethodPo.setMerchantId(merchantId);
                        createPayMethodPo.setPayMethod(payMethod);
                        createPayMethodPo.setPayParaId(payParaId);
                        createPayMethodPo.setCreateTime(dbDate);
                        this.merchantPayMethodRelMapper.createMerchantPayMethodRel(createPayMethodPo);
                    }
                }
                if ((payParaInfoBo = tmpInsBo.getPayParaInfoBo()) == null || (payParaAttrInfoBoList = payParaInfoBo.getPayParaAttrInfoBoList()) == null) continue;
                for (PayProPayParaAttrInfoBo attrBo : payParaAttrInfoBoList) {
                    if (attrBo == null) continue;
                    PayParaInfoAttrPo createAttrPo = new PayParaInfoAttrPo();
                    createAttrPo.setPayParaId(payParaId);
                    createAttrPo.setAttrCode(attrBo.getAttrCode());
                    createAttrPo.setAttrValue(attrBo.getAttrValue());
                    createAttrPo.setCreateTime(dbDate);
                    this.payParaInfoAttrMapper.createPayParaInfoAttr(createAttrPo);
                }
            }
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private String validateArg(PayProAddMerchantBusiReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        PayProMerchantInfoBo merchantInfoBo = reqBo.getMerchantInfoBo();
        if (merchantInfoBo == null) {
            return "\u5165\u53c2\u5c5e\u6027\uff1amerchantInfoBo\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

