/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.comb.impl;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.busi.PayOrderBusiService;
import com.tydic.payment.pay.busi.PayProCreateOrderBusiService;
import com.tydic.payment.pay.busi.PayProOrderQueryBusiService;
import com.tydic.payment.pay.busi.PayProQueryInfoBusiSystemByConditionService;
import com.tydic.payment.pay.busi.bo.PayOrderRspBo;
import com.tydic.payment.pay.busi.bo.PayProCreateOrderBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProCreateOrderBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProOrderQueryAddBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProOrderQueryBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProOrderQueryByOutOrderIdAndBusiIdBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProQueryInfoBusiSystemByConditionBusiInfoRspBo;
import com.tydic.payment.pay.busi.bo.PorderDetallPo;
import com.tydic.payment.pay.comb.PayProPreparedOrderCombService;
import com.tydic.payment.pay.comb.bo.PayProPreparedOrderCombReqBo;
import com.tydic.payment.pay.comb.bo.PayProPreparedOrderCombRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.PayProSequence;
import com.tydic.payment.pay.dao.POrderRelPayMethodMapper;
import com.tydic.payment.pay.dao.PorderMapper;
import com.tydic.payment.pay.dao.po.POrderRelPayMethodPo;
import com.tydic.payment.pay.dao.po.PorderPo;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"PAYMENT_GROUP_DEV/2.0.0/com.tydic.payment.pay.comb.PayProPreparedOrderCombService"})
public class PayProPreparedOrderCombServiceImpl
implements PayProPreparedOrderCombService {
    private static final Logger LOG = LoggerFactory.getLogger(PayProPreparedOrderCombServiceImpl.class);
    @Autowired
    private PayProCreateOrderBusiService payProCreateOrderBusiService;
    @Autowired
    private PayProQueryInfoBusiSystemByConditionService payProQueryInfoBusiSystemByConditionService;
    @Autowired
    private PayProOrderQueryBusiService payProOrderQueryBusiService;
    @Autowired
    private PayOrderBusiService payOrderBusiService;
    @Autowired
    private PorderMapper porderMapper;
    @Autowired
    private POrderRelPayMethodMapper pOrderRelPayMethodMapper;
    private static final String HTTP_PREFIX = "http://";
    private static final String HTTPS_PREFIX = "https://";
    private static final int OUT_ORDER_ID_MAX_SIZE = 64;

    @PostMapping(value={"createOrder"})
    public PayProPreparedOrderCombRspBo createOrder(@RequestBody PayProPreparedOrderCombReqBo reqBo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("\u4ea7\u54c1\u4e0b\u5355comb\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        }
        PayProPreparedOrderCombRspBo retBo = new PayProPreparedOrderCombRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("213001");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        String busiCode = reqBo.getBusiCode();
        Long busiId = null;
        if (reqBo.getBusiId() == null && !StringUtils.isEmpty((Object)busiCode)) {
            PayProQueryInfoBusiSystemByConditionBusiInfoRspBo qryBusiRspBo = this.payProQueryInfoBusiSystemByConditionService.queryBusiSysByBusiCode(busiCode);
            if (!"0000".equals(qryBusiRspBo.getRespCode())) {
                retBo.setRespCode("213001");
                retBo.setRespDesc(qryBusiRspBo.getRespDesc());
                return retBo;
            }
            busiId = qryBusiRspBo.getBusiId();
        } else {
            busiId = reqBo.getBusiId();
        }
        String outOrderId = reqBo.getOutOrderId();
        PayProOrderQueryBusiReqBo qryOrderQueryBo = new PayProOrderQueryBusiReqBo();
        qryOrderQueryBo.setBusiId(busiId);
        qryOrderQueryBo.setOutOrderId(outOrderId);
        PayProOrderQueryByOutOrderIdAndBusiIdBusiRspBo orderQueryBo = this.payProOrderQueryBusiService.queryOrderQueryByBusiIdAndOutOrderId(qryOrderQueryBo);
        if ("0000".equals(orderQueryBo.getRespCode())) {
            Long orderId = orderQueryBo.getOrderId();
            PayOrderRspBo payOrderRspBo = this.payOrderBusiService.selectOrderByOrderId(orderId);
            if ("A10".equals(payOrderRspBo.getOrderStatus())) {
                retBo.setRespCode("213001");
                retBo.setRespDesc("\u5916\u90e8\u8ba2\u5355\u53f7(" + outOrderId + ")\u5df2\u7ecf\u652f\u4ed8\u6210\u529f\uff0c\u8bf7\u52ff\u91cd\u590d\u4e0b\u5355");
                return retBo;
            }
            if ("A20".equals(payOrderRspBo.getOrderStatus())) {
                retBo.setRespCode("213001");
                retBo.setRespDesc("\u5916\u90e8\u8ba2\u5355\u53f7(" + outOrderId + ")\u652f\u4ed8\u5931\u8d25\u4e86\uff0c\u8bf7\u52ff\u91cd\u590d\u4e0b\u5355");
                return retBo;
            }
            String checkResult = this.checkValue(payOrderRspBo, reqBo, busiId);
            if (!StringUtils.isEmpty((Object)checkResult)) {
                retBo.setRespCode("213001");
                retBo.setRespDesc("\u4e0b\u5355(\u91cd\u590d)\u5931\u8d25\uff1a" + checkResult);
                return retBo;
            }
            PayOrderRspBo rspBo = this.payOrderBusiService.dealDelay(payOrderRspBo.getOrderId());
            if (!"0000".equals(rspBo.getRspCode())) {
                retBo.setRespCode("8888");
                retBo.setRespDesc("\u4e0b\u5355(\u91cd\u590d)\u5931\u8d25\uff1a\u5ef6\u957f\u8ba2\u5355\u65f6\u95f4\u5931\u8d25");
                return retBo;
            }
            this.updateOrderRelPayMethod(reqBo, payOrderRspBo);
            BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
            retBo.setOrderId(orderId + "");
            retBo.setBusiId(busiId);
            retBo.setRespCode("0000");
            retBo.setRespDesc("\u4e0b\u5355\u6210\u529f(re)");
            return retBo;
        }
        PayProCreateOrderBusiReqBo createOrderBo = new PayProCreateOrderBusiReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)createOrderBo);
        createOrderBo.setBusiId(busiId);
        this.setTypeNotEqualsValue(reqBo, createOrderBo);
        createOrderBo.setOrderPayMethods(reqBo.getOrderPayMethods());
        PayProCreateOrderBusiRspBo orderRspBo = this.payProCreateOrderBusiService.createOrder(createOrderBo);
        if (!"0000".equals(orderRspBo.getRespCode())) {
            retBo.setRespCode("213001");
            retBo.setRespDesc(orderRspBo.getRespDesc());
            return retBo;
        }
        Long insertedOrderId = Long.parseLong(orderRspBo.getOrderId());
        PayProOrderQueryBusiReqBo addQueryBo = new PayProOrderQueryBusiReqBo();
        addQueryBo.setOutOrderId(reqBo.getOutOrderId());
        addQueryBo.setBusiId(busiId);
        addQueryBo.setOrderId(insertedOrderId);
        PayProOrderQueryAddBusiRspBo payProOrderQueryAddBusiRspBo = this.payProOrderQueryBusiService.addOrderQuery(addQueryBo);
        if (!"0000".equals(payProOrderQueryAddBusiRspBo.getRespCode())) {
            retBo.setRespCode("213001");
            int deleteCount = this.porderMapper.deletePorderByOrderId(insertedOrderId);
            if (deleteCount < 1) {
                LOG.error("\u5199p_order\u8868\u6210\u529f\uff0c\u4f46\u63d2\u5165p_order_query\u8868\u5931\u8d25\uff0c\u4e14\u5220\u9664\u5df2\u63d2\u5165p_order\u8868\u6570\u636e\u4e5f\u5931\u8d25\uff0corderId=" + insertedOrderId);
                retBo.setRespDesc("\u5199p_order\u8868\u6210\u529f\uff0c\u4f46\u63d2\u5165p_order_query\u8868\u5931\u8d25\uff0c\u4e14\u5220\u9664\u5df2\u63d2\u5165p_order\u8868\u6570\u636e\u4e5f\u5931\u8d25\uff0corderId=" + insertedOrderId);
            } else {
                LOG.error("\u5199p_order\u8868\u6210\u529f\uff0c\u4f46\u63d2\u5165p_order_query\u8868\u5931\u8d25\uff0c\u4f46\u5220\u9664\u5df2\u63d2\u5165p_order\u8868\u6570\u636e\u6210\u529f");
                retBo.setRespDesc("\u5199p_order\u8868\u6210\u529f\uff0c\u4f46\u63d2\u5165p_order_query\u8868\u5931\u8d25\uff0c\u4f46\u5220\u9664\u5df2\u63d2\u5165p_order\u8868\u6570\u636e\u6210\u529f");
            }
            return retBo;
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        retBo.setBusiId(busiId);
        retBo.setOrderId(orderRspBo.getOrderId());
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u4e0b\u5355\u6210\u529f");
        return retBo;
    }

    private void updateOrderRelPayMethod(PayProPreparedOrderCombReqBo reqBo, PayOrderRspBo payOrderRspBo) {
        List orderPayMethods = reqBo.getOrderPayMethods();
        POrderRelPayMethodPo qryPo = new POrderRelPayMethodPo();
        qryPo.setOrderId(payOrderRspBo.getOrderId());
        List<POrderRelPayMethodPo> pOrderRelPayMethodPos = this.pOrderRelPayMethodMapper.selectByCondition(qryPo);
        if (!CollUtil.isEmpty(pOrderRelPayMethodPos)) {
            this.pOrderRelPayMethodMapper.deleteByOrderId(payOrderRspBo.getOrderId());
        }
        if (!CollUtil.isEmpty((Collection)orderPayMethods)) {
            for (Long orderPayMethod : orderPayMethods) {
                POrderRelPayMethodPo insertPo = new POrderRelPayMethodPo();
                insertPo.setRelId(PayProSequence.nextId());
                insertPo.setOrderId(payOrderRspBo.getOrderId());
                insertPo.setPayMethod(orderPayMethod);
                insertPo.setOutOrderId(reqBo.getOutOrderId());
                this.pOrderRelPayMethodMapper.insert(insertPo);
            }
        }
        if (!StringUtils.isEmpty((Object)reqBo.getRedirectUrl())) {
            PorderPo porderPo = new PorderPo();
            porderPo.setOrderId(payOrderRspBo.getOrderId());
            porderPo.setRedirectUrl(reqBo.getRedirectUrl());
            this.porderMapper.update(porderPo);
        }
    }

    private void setTypeNotEqualsValue(PayProPreparedOrderCombReqBo reqBo, PayProCreateOrderBusiReqBo createOrderBo) {
        createOrderBo.setMerchantId(Long.valueOf(Long.parseLong(reqBo.getMerchantId())));
        createOrderBo.setTotalFee(Long.valueOf(Long.parseLong(reqBo.getTotalFee())));
        if (!StringUtils.isEmpty((Object)reqBo.getBalanceFee())) {
            createOrderBo.setBalanceFee(Long.valueOf(Long.parseLong(reqBo.getBalanceFee())));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOnlineFee())) {
            createOrderBo.setOnlineFee(Long.valueOf(Long.parseLong(reqBo.getOnlineFee())));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getDiscountFee())) {
            createOrderBo.setDiscountFee(Long.valueOf(Long.parseLong(reqBo.getDiscountFee())));
        }
        if (StringUtils.isEmpty((Object)reqBo.getOrderType())) {
            createOrderBo.setOrderType("01");
        } else {
            createOrderBo.setOrderType(reqBo.getOrderType());
        }
        createOrderBo.setOutRefundNo(reqBo.getOutRefundNo());
    }

    private String checkValue(PayOrderRspBo payOrderRspBo, PayProPreparedOrderCombReqBo reqBo, Long busiId) {
        if (!busiId.equals(payOrderRspBo.getBusiId())) {
            return "busiCode\u4e0d\u4e00\u81f4";
        }
        if (!StringUtils.isEmpty((Object)payOrderRspBo.getChannelId()) && !payOrderRspBo.getChannelId().equals(reqBo.getChannelId())) {
            return "channelId\u4e0d\u4e00\u81f4";
        }
        if (!StringUtils.isEmpty((Object)payOrderRspBo.getCityId()) && !payOrderRspBo.getCityId().equals(reqBo.getCityId())) {
            return "cityId\u4e0d\u4e00\u81f4";
        }
        if (!StringUtils.isEmpty((Object)payOrderRspBo.getCreateOperId()) && !payOrderRspBo.getCreateOperId().equals(reqBo.getCreateOperId())) {
            return "createOperId\u4e0d\u4e00\u81f4";
        }
        if (!StringUtils.isEmpty((Object)payOrderRspBo.getDetailName()) && !payOrderRspBo.getDetailName().equals(reqBo.getDetailName())) {
            return "detailName\u4e0d\u4e00\u81f4";
        }
        if (!StringUtils.isEmpty((Object)payOrderRspBo.getDistrictId()) && !payOrderRspBo.getDistrictId().equals(reqBo.getDistrictId())) {
            return "districtId\u4e0d\u4e00\u81f4";
        }
        if (!StringUtils.isEmpty((Object)payOrderRspBo.getProvinceId()) && !payOrderRspBo.getProvinceId().equals(reqBo.getProvinceId())) {
            return "provinceId\u4e0d\u4e00\u81f4";
        }
        if (!StringUtils.isEmpty((Object)payOrderRspBo.getNotifyUrl()) && !payOrderRspBo.getNotifyUrl().equals(reqBo.getNotifyUrl())) {
            return "notifyUrl\u4e0d\u4e00\u81f4";
        }
        if (!StringUtils.isEmpty((Object)payOrderRspBo.getReqWay()) && !payOrderRspBo.getReqWay().equals(reqBo.getReqWay())) {
            return "reqWay\u4e0d\u4e00\u81f4";
        }
        if (!StringUtils.isEmpty((Object)payOrderRspBo.getTotalFee()) && payOrderRspBo.getTotalFee().longValue() != MoneyUtils.fenToHao((String)reqBo.getTotalFee()).longValue()) {
            return "totalFee\u4e0d\u4e00\u81f4";
        }
        return null;
    }

    private String validateArg(PayProPreparedOrderCombReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            return "merchantId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOutOrderId())) {
            return "outOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBo.getOutOrderId().trim().length() > 64) {
            return "outOrderId\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc764";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiCode()) && StringUtils.isEmpty((Object)reqBo.getBusiId())) {
            return "busiCode,busiId\u4e0d\u80fd\u4e3a\u540c\u65f6\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getTotalFee())) {
            return "totalFee\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getDetailName())) {
            return "detailName\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!(StringUtils.isEmpty((Object)reqBo.getRedirectUrl()) || reqBo.getRedirectUrl().trim().startsWith(HTTP_PREFIX) || reqBo.getRedirectUrl().trim().startsWith(HTTPS_PREFIX))) {
            return "redirectUrl\u5fc5\u987b\u4ee5'http://'\u6216\u8005'https://'\u5f00\u5934";
        }
        if (!(StringUtils.isEmpty((Object)reqBo.getNotifyUrl()) || reqBo.getNotifyUrl().trim().startsWith(HTTP_PREFIX) || reqBo.getNotifyUrl().trim().startsWith(HTTPS_PREFIX))) {
            return "notifyUrl\u5fc5\u987b\u4ee5'http://'\u6216\u8005'https://'\u5f00\u5934";
        }
        List goodDetails = reqBo.getGoodDetails();
        if (goodDetails != null && !goodDetails.isEmpty()) {
            for (PorderDetallPo good : goodDetails) {
                if (good == null) {
                    return "\u5546\u54c1\u5355\u4e2a\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
                }
                if (StringUtils.isEmpty((Object)good.getGoodsId())) {
                    return "goodsId\u4e0d\u80fd\u4e3a\u7a7a";
                }
                if (StringUtils.isEmpty((Object)good.getGoodsName())) {
                    return "goodsName\u4e0d\u80fd\u4e3a\u7a7a";
                }
                if (StringUtils.isEmpty((Object)good.getGoodsFee())) {
                    return "goodsFee\u4e0d\u80fd\u4e3a\u7a7a";
                }
                if (StringUtils.isEmpty((Object)good.getGoodsNum())) {
                    return "goodsNum\u4e0d\u80fd\u4e3a\u7a7a";
                }
                if (!StringUtils.isEmpty((Object)good.getGoodsPrice())) continue;
                return "goodsPrice\u4e0d\u80fd\u4e3a\u7a7a";
            }
        }
        return null;
    }
}

