/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipayTradeQueryRequest;
import com.alipay.api.request.AlipayTradeRefundRequest;
import com.alipay.api.response.AlipayTradeQueryResponse;
import com.alipay.api.response.AlipayTradeRefundResponse;
import com.tydic.payment.pay.ali.common.Configs;
import com.tydic.payment.pay.busi.PayProGetParamsBusiService;
import com.tydic.payment.pay.busi.bo.PayAbleAliPayNotifyDataBean;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryPayStatusReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryPayStatusRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleRefundReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleRefundRspBo;
import com.tydic.payment.pay.busi.bo.PayProGetParamsBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProGetParamsBusiRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.payable.api.PayAble;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public abstract class AbstractAliPayAble
implements PayAble {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAliPayAble.class);
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PayProGetParamsBusiService payProGetParamsBusiService;
    private static final String NORMAL_REFUND_DESC = "\u6b63\u5e38\u9000\u6b3e";

    public PayAbleRefundRspBo dealRefund(PayAbleRefundReqBo reqBo) {
        PayAbleRefundRspBo retBo = new PayAbleRefundRspBo();
        String validateArgStr = this.validateRefundArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("212010");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        String aliOpenApiDomain = this.payPropertiesVo.getAliOpenApiDomain();
        if (StringUtils.isEmpty((Object)aliOpenApiDomain)) {
            LOG.error("\u652f\u4ed8\u5b9d\u8bf7\u6c42\u5730\u5740(aliOpenApiDomain)\u672a\u914d\u7f6e");
            throw new BusinessException("216011", "\u652f\u4ed8\u5b9d\u8bf7\u6c42\u5730\u5740(aliOpenApiDomain)\u672a\u914d\u7f6e");
        }
        Map paraMap = reqBo.getParaMap();
        String appId = (String)paraMap.get("appid");
        String privateKey = (String)paraMap.get("privateKey");
        String publicKey = (String)paraMap.get("publicKey");
        DefaultAlipayClient alipayClient = new DefaultAlipayClient(aliOpenApiDomain, appId, privateKey, "json", "UTF-8", publicKey, "RSA2");
        AlipayTradeRefundRequest request = new AlipayTradeRefundRequest();
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        dataMap.put("out_trade_no", reqBo.getPayOrderId());
        dataMap.put("refund_amount", MoneyUtils.fenToYuan((Long)reqBo.getRefundFee()).toString());
        dataMap.put("refund_reason", StringUtils.isEmpty((Object)reqBo.getRefundReason()) ? NORMAL_REFUND_DESC : reqBo.getRefundReason());
        dataMap.put("out_request_no", reqBo.getRefundOrderId());
        request.setBizContent(JSON.toJSONString(dataMap));
        try {
            AlipayTradeRefundResponse response = (AlipayTradeRefundResponse)alipayClient.execute((AlipayRequest)request);
            if (response.isSuccess()) {
                BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
                if (StringUtils.isEmpty((Object)retBo.getRefundReason())) {
                    retBo.setRefundReason(NORMAL_REFUND_DESC);
                }
            } else {
                LOG.error("\u8c03\u7528\u652f\u4ed8\u5b9d\u9000\u6b3e\u63a5\u53e3\u5931\u8d25\uff1a" + response.getSubMsg());
                retBo.setRespCode("212010");
                retBo.setRespDesc("\u8c03\u7528\u652f\u4ed8\u5b9d\u9000\u6b3e\u63a5\u53e3\u5931\u8d25\uff1a" + response.getSubMsg());
                return retBo;
            }
            retBo.setRefundTransId(response.getTradeNo());
            String tradeTime = new DateTime((Object)response.getGmtRefundPay()).toString("yyyyMMddHHmmss");
            retBo.setTradeTime(tradeTime);
            retBo.setRespCode("0000");
            retBo.setRespDesc("\u652f\u4ed8\u5b9d\u9000\u6b3e\u6210\u529f");
        }
        catch (AlipayApiException e) {
            LOG.error("\u8c03\u7528\u652f\u4ed8\u5b9d\u9000\u6b3e\u5f02\u5e38\uff1a" + (Object)((Object)e));
            throw new BusinessException("216011", "\u8c03\u7528\u652f\u4ed8\u5b9d\u9000\u6b3e\u5f02\u5e38\uff1a" + (Object)((Object)e), (Throwable)e);
        }
        return retBo;
    }

    public PayAbleQryPayStatusRspBo qryPayStatus(PayAbleQryPayStatusReqBo reqBo) {
        PayAbleQryPayStatusRspBo retBo = new PayAbleQryPayStatusRspBo();
        String validateArgStr = this.validateQryArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("212008");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        String aliOpenApiDomain = this.payPropertiesVo.getAliOpenApiDomain();
        LOG.info("\u8c03\u7528\u652f\u4ed8\u5b9d\u63a5\u53e3\u7684\u5730\u5740\uff08\u67e5\u72b6\u6001\uff09\uff1a" + aliOpenApiDomain);
        if (StringUtils.isEmpty((Object)aliOpenApiDomain)) {
            LOG.error("\u652f\u4ed8\u5b9d\u8bf7\u6c42\u5730\u5740(aliOpenApiDomain)\u672a\u914d\u7f6e");
            throw new BusinessException("216010", "\u652f\u4ed8\u5b9d\u8bf7\u6c42\u5730\u5740(aliOpenApiDomain)\u672a\u914d\u7f6e");
        }
        Map paraMap = reqBo.getParaMap();
        String appId = (String)paraMap.get("appid");
        String privateKey = (String)paraMap.get("privateKey");
        String publicKey = (String)paraMap.get("publicKey");
        DefaultAlipayClient alipayClient = new DefaultAlipayClient(aliOpenApiDomain, appId, privateKey, "json", "UTF-8", publicKey, "RSA2");
        AlipayTradeQueryRequest request = new AlipayTradeQueryRequest();
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        dataMap.put("out_trade_no", reqBo.getPayOrderId());
        request.setBizContent(JSON.toJSONString(dataMap));
        try {
            AlipayTradeQueryResponse response = (AlipayTradeQueryResponse)alipayClient.execute((AlipayRequest)request);
            LOG.info("\u652f\u4ed8\u5b9d\u67e5\u8be2\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)response));
            if (!response.isSuccess()) {
                retBo.setRespCode("212008");
                retBo.setRespDesc("\u8c03\u7528\u652f\u4ed8\u5b9d\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\u5931\u8d25\uff1a" + response.getSubMsg());
                return retBo;
            }
            this.sortQryStatusRetBo(reqBo, retBo, response);
        }
        catch (AlipayApiException e) {
            LOG.error("\u8c03\u7528\u652f\u4ed8\u5b9d\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38\uff1a" + (Object)((Object)e));
            throw new BusinessException("216007", "\u8c03\u7528\u652f\u4ed8\u5b9d\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38\uff1a" + (Object)((Object)e), (Throwable)e);
        }
        return retBo;
    }

    public PayAbleCallBackRspBo dealCallBack(PayAbleCallBackReqBo reqBo) {
        boolean isSuccess;
        LOG.info("\u8fdb\u5165\u652f\u4ed8\u5b9d\u652f\u4ed8\u7ed3\u679c\u56de\u8c03\u5904\u7406\u65b9\u6cd5\uff1a" + reqBo);
        PayAbleCallBackRspBo retBo = new PayAbleCallBackRspBo();
        if (StringUtils.isEmpty((Object)reqBo.getReqData())) {
            LOG.error("\u652f\u4ed8\u5b9d\u56de\u8c03\u5904\u7406\u65b9\u6cd5\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a\u53c2\u6570'reqData'\u4e0d\u80fd\u4e3a\u7a7a");
            retBo.setRespCode("212053");
            retBo.setRespDesc("\u652f\u4ed8\u5b9d\u56de\u8c03\u5904\u7406\u65b9\u6cd5\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a\u53c2\u6570'reqData'\u4e0d\u80fd\u4e3a\u7a7a");
            return retBo;
        }
        JSONObject reqDataJson = JSONObject.parseObject((String)reqBo.getReqData());
        PayAbleAliPayNotifyDataBean notifyDataBean = (PayAbleAliPayNotifyDataBean)JSONObject.toJavaObject((JSON)reqDataJson, PayAbleAliPayNotifyDataBean.class);
        LOG.info("\u5c06\u62a5\u6587\u5b57\u7b26\u4e32\u8f6c\u4e3a\u5bf9\u8c61\uff1a" + notifyDataBean);
        if (StringUtils.isEmpty((Object)notifyDataBean.getOut_trade_no())) {
            LOG.error("\u5c06\u62a5\u6587\u8f6c\u6362\u4e3a\u5bf9\u8c61\u5931\u8d25");
            retBo.setRespCode("212053");
            retBo.setRespDesc("\u5c06\u62a5\u6587\u8f6c\u6362\u4e3a\u5bf9\u8c61\u5931\u8d25");
            return retBo;
        }
        String payOrderId = notifyDataBean.getOut_trade_no();
        try {
            isSuccess = this.signatureValidation(reqBo, payOrderId, null);
        }
        catch (Exception e) {
            LOG.error("\u6821\u9a8c\u7b7e\u540d\u5f02\u5e38\uff1a" + e.getMessage());
            retBo.setRespCode("212053");
            retBo.setRespDesc("\u6821\u9a8c\u7b7e\u540d\u5f02\u5e38\uff1a" + e.getMessage());
            return retBo;
        }
        if (!isSuccess) {
            LOG.error("\u6821\u9a8c\u7b7e\u540d\u5931\u8d25");
            retBo.setRespCode("212053");
            retBo.setRespDesc("\u6821\u9a8c\u7b7e\u540d\u5931\u8d25");
            return retBo;
        }
        String tradeTime = notifyDataBean.getGmt_payment();
        try {
            tradeTime = new DateTime((Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(tradeTime)).toString("yyyyMMddHHmmss");
        }
        catch (ParseException e) {
            LOG.error("\u8f6c\u6362\u65f6\u95f4\u683c\u5f0f\u5f02\u5e38\uff1a" + e);
            retBo.setRespCode("212053");
            retBo.setRespDesc("\u652f\u4ed8\u5b9d\u5904\u7406\u56de\u8c03\u5f02\u5e38\uff1a" + e.getMessage());
            return retBo;
        }
        retBo.setTradeTime(tradeTime);
        retBo.setPayOrderId(payOrderId);
        retBo.setPayNotifyTransId(notifyDataBean.getTrade_no());
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    public Boolean signatureValidation(PayAbleCallBackReqBo reqBo, String payCenterId, String contractId) throws Exception {
        LOG.info("\u5f00\u59cb\u6821\u9a8c\u7b7e\u540d");
        PayProGetParamsBusiReqBo getParamsBusiReqBo = new PayProGetParamsBusiReqBo();
        getParamsBusiReqBo.setPayOrderId(payCenterId);
        getParamsBusiReqBo.setContractId(contractId);
        PayProGetParamsBusiRspBo getParamsBusiRspBo = this.payProGetParamsBusiService.getParamMap(getParamsBusiReqBo);
        if (!"0000".equals(getParamsBusiRspBo.getRespCode())) {
            LOG.error("\u83b7\u53d6\u652f\u4ed8\u673a\u6784\u53c2\u6570map\u5931\u8d25\uff1a" + getParamsBusiRspBo.getRespDesc());
            return false;
        }
        JSONObject reqDataJson = JSONObject.parseObject((String)reqBo.getReqData());
        String charset = reqDataJson.getString("charset");
        String sign = reqDataJson.getString("sign");
        reqDataJson.remove((Object)"sign");
        reqDataJson.remove((Object)"sign_type");
        StringBuilder content = new StringBuilder();
        ArrayList keys = new ArrayList(reqDataJson.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            String value = reqDataJson.getString(key);
            content.append(content.length() == 0 ? "" : "&").append(key).append("=").append(value);
        }
        LOG.info("\u6392\u5e8f\u540e\u7684\u53c2\u6570\u4e3a\uff1a" + content.toString());
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        byte[] encodeKey = Base64.decodeBase64((String)((String)getParamsBusiRspBo.getParamMap().get("publicKey")));
        PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodeKey));
        Signature signature = Signature.getInstance(Configs.getDecodSingTypeInstance());
        signature.initVerify(publicKey);
        signature.update(content.toString().getBytes(charset));
        return signature.verify(Base64.decodeBase64((String)sign));
    }

    public void sortQryStatusRetBo(PayAbleQryPayStatusReqBo reqBo, PayAbleQryPayStatusRspBo retBo, AlipayTradeQueryResponse response) {
        retBo.setOrderId(reqBo.getOrderId());
        retBo.setPayOrderId(reqBo.getPayOrderId());
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u67e5\u8be2\u6210\u529f");
        String tradeStatus = response.getTradeStatus();
        PayProConstants.AliPayTradeStatus aliPayTradeStatus = PayProConstants.AliPayTradeStatus.valueOf(tradeStatus);
        switch (aliPayTradeStatus) {
            case TRADE_SUCCESS: {
                retBo.setTradeTime(new DateTime((Object)response.getSendPayDate()).toString("yyyyMMddHHmmss"));
                retBo.setPayNotifyTransId(response.getTradeNo());
                retBo.setRealFee(Long.valueOf(MoneyUtils.yuanToFen((String)response.getTotalAmount()).longValue()));
                retBo.setPayStatus("SUCCESS");
                retBo.setPayStatusMsg("\u652f\u4ed8\u6210\u529f(alipay)");
                break;
            }
            case TRADE_CLOSED: {
                retBo.setPayStatus("FAIL");
                retBo.setPayStatusMsg("\u8ba2\u5355\u5df2\u5173\u95ed(alipay)");
                break;
            }
            case WAIT_BUYER_PAY: {
                retBo.setPayStatus("PAYING");
                retBo.setPayStatusMsg("\u7528\u6237\u652f\u4ed8\u4e2d(alipay)");
                break;
            }
            case TRADE_FINISHED: {
                if (!StringUtils.isEmpty((Object)response.getSendPayDate())) {
                    retBo.setTradeTime(new DateTime((Object)response.getSendPayDate()).toString("yyyyMMddHHmmss"));
                }
                if (!StringUtils.isEmpty((Object)response.getTotalAmount())) {
                    retBo.setRealFee(Long.valueOf(MoneyUtils.yuanToFen((String)response.getTotalAmount()).longValue()));
                }
                retBo.setPayNotifyTransId(response.getTradeNo());
                retBo.setPayStatus("SUCCESS");
                retBo.setPayStatusMsg("\u652f\u4ed8\u5df2\u5b8c\u6210(alipay)");
                break;
            }
            default: {
                retBo.setRespCode("212008");
                retBo.setRespDesc("\u652f\u4ed8\u5b9d\u8fd4\u56de\u672a\u77e5\u72b6\u6001\u503c");
                retBo.setPayStatus("FAIL");
            }
        }
    }

    public String validateQryArg(PayAbleQryPayStatusReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaMap())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String validateMap = this.validateMap(reqBo.getParaMap());
        if (!StringUtils.isEmpty((Object)validateMap)) {
            return validateMap;
        }
        return null;
    }

    public String validateRefundArg(PayAbleRefundReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaMap()) || reqBo.getParaMap().isEmpty()) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getRefundFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027refundFee\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getRefundOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027refundOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getRefundReason())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027refundReason\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String validateMap = this.validateMap(reqBo.getParaMap());
        if (!StringUtils.isEmpty((Object)validateMap)) {
            return validateMap;
        }
        return null;
    }

    private String validateMap(Map<String, String> paraMap) {
        String appId = paraMap.get("appid");
        String privateKey = paraMap.get("privateKey");
        String publicKey = paraMap.get("publicKey");
        if (StringUtils.isEmpty((Object)appId)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e2dkey(appId)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)privateKey)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e2dkey(privateKey)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)publicKey)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e2dkey(publicKey)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

