/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.atom.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.payment.pay.atom.PayMethodAtomService;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.dao.PayMethodMapper;
import com.tydic.payment.pay.dao.po.PayMethodPageReqPo;
import com.tydic.payment.pay.dao.po.PayMethodPo;
import com.tydic.payment.pay.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="payMethodAtomService")
public class PayMethodAtomServiceImpl
implements PayMethodAtomService {
    @Autowired
    private PayMethodMapper payMethodMapper;

    @Override
    public List<PayMethodPo> queryPayMethod(PayMethodPo po) {
        List<PayMethodPo> queryPayMethod;
        if (po == null) {
            po = new PayMethodPo();
        }
        if ((queryPayMethod = this.payMethodMapper.queryPayMethod(po)) == null || queryPayMethod.isEmpty()) {
            return new ArrayList<PayMethodPo>();
        }
        return queryPayMethod;
    }

    @Override
    public Long createPayMethod(PayMethodPo po) {
        this.validateArg(po);
        int createPayMethod = this.payMethodMapper.createPayMethod(po);
        if (createPayMethod < 1) {
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u63d2\u5165p_code_pay_method\u65f6mapper insert\u65b9\u6cd5\u8fd4\u56de\u503c\u5c0f\u4e8e1\uff0c\u63d2\u5165\u5931\u8d25\uff01");
        }
        if (po.getPayMethod() == null) {
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u63d2\u5165p_code_pay_method\u540e\u672a\u8fd4\u56de\u63d2\u5165\u7684id");
        }
        return po.getPayMethod();
    }

    @Override
    public Long createPayMethodWithId(PayMethodPo po) {
        if (po == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165p_code_pay_method\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getPayMethodName() == null || po.getPayMethodName().trim().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165p_code_pay_method\u5165\u53c2\u5c5e\u6027PayMethodName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getPaymentInsId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165p_code_pay_method\u5165\u53c2\u5c5e\u6027PaymentInsId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int createPayMethod = this.payMethodMapper.createPayMethodWithId(po);
        if (createPayMethod < 1) {
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u63d2\u5165p_code_pay_method\u65f6mapper insert\u65b9\u6cd5\u8fd4\u56de\u503c\u5c0f\u4e8e1\uff0c\u63d2\u5165\u5931\u8d25\uff01");
        }
        if (po.getPayMethod() == null) {
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u63d2\u5165p_code_pay_method\u540e\u672a\u8fd4\u56de\u63d2\u5165\u7684id");
        }
        return po.getPayMethod();
    }

    @Override
    public int updatePayMethod(PayMethodPo po) {
        this.validateArgUpdate(po);
        return this.payMethodMapper.updatePayMethod(po);
    }

    @Override
    public int updatePayMethodIcon(PayMethodPo po) {
        this.validateArgUpdate(po);
        return this.payMethodMapper.updatePayMethodIcon(po);
    }

    @Override
    public int deletePayMethodByMethod(PayMethodPo po) {
        this.validateArgDel(po);
        return this.payMethodMapper.deletePayMethodByMethod(po);
    }

    @Override
    public List<PayMethodPo> queryPayMethodByMethods(List<Long> list) {
        if (list == null || list.isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6839\u636e\u652f\u4ed8\u65b9\u5f0flist\u67e5\u8be2p_code_pay_method\u65f6\u5165\u53c2list\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<PayMethodPo> queryPayMethodByMethods = this.payMethodMapper.queryPayMethodByMethods(list);
        if (queryPayMethodByMethods == null || queryPayMethodByMethods.isEmpty()) {
            return new ArrayList<PayMethodPo>();
        }
        Map payMethodPoMap = queryPayMethodByMethods.stream().collect(Collectors.toMap(PayMethodPo::getPayMethod, Function.identity()));
        ArrayList<PayMethodPo> finPayMethodList = new ArrayList<PayMethodPo>();
        PayMethodPo chinaPayNoCard = new PayMethodPo();
        for (Long payMethod : list) {
            if (PayProConstants.PayMethod.CHINA_PAY_NO_CARD.getPayMethod().equals(payMethod)) {
                BeanUtils.copyProperties(payMethodPoMap.get(payMethod), (Object)chinaPayNoCard);
                continue;
            }
            finPayMethodList.add((PayMethodPo)payMethodPoMap.get(payMethod));
        }
        if (!StringUtils.isEmpty((Object)chinaPayNoCard)) {
            finPayMethodList.add(chinaPayNoCard);
        }
        return finPayMethodList;
    }

    private void validateArgDel(PayMethodPo po) {
        if (po == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5220\u9664p_code_pay_method\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getPayMethod() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5220\u9664p_code_pay_method\u5165\u53c2\u5c5e\u6027PayMethod\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateArgUpdate(PayMethodPo po) {
        if (po == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0p_code_pay_method\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getPayMethod() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0p_code_pay_method\u5165\u53c2\u5c5e\u6027PayMethod\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateArg(PayMethodPo po) {
        if (po == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165p_code_pay_method\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getPayMethod() != null) {
            po.setPayMethod(null);
        }
        if (po.getPayMethodName() == null || po.getPayMethodName().trim().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165p_code_pay_method\u5165\u53c2\u5c5e\u6027PayMethodName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getPaymentInsId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165p_code_pay_method\u5165\u53c2\u5c5e\u6027PaymentInsId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public List<PayMethodPo> queryPayMethodByConditionWithPage(Page<PayMethodPageReqPo> page, PayMethodPageReqPo po) {
        List<PayMethodPo> queryPayMethodByMethods;
        if (po == null) {
            po = new PayMethodPageReqPo();
        }
        if ((queryPayMethodByMethods = this.payMethodMapper.queryPayMethodByConditionWithPage(page, po)) == null || queryPayMethodByMethods.isEmpty()) {
            return new ArrayList<PayMethodPo>();
        }
        return queryPayMethodByMethods;
    }

    @Override
    public PayMethodPo queryPayMethodById(Long payMethod) {
        if (payMethod == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u7684\u652f\u4ed8\u65b9\u5f0fID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PayMethodPo resultPo = this.payMethodMapper.queryPayMethodById(payMethod);
        return resultPo;
    }
}

