/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.tydic.payment.pay.atom.CashierPayMethodRelAtomService;
import com.tydic.payment.pay.atom.CashierTemplateAtomService;
import com.tydic.payment.pay.atom.ChannelIdPayMethodRelAtomService;
import com.tydic.payment.pay.atom.MerchantInfoAtomService;
import com.tydic.payment.pay.atom.MerchantPayMethodRelAtomService;
import com.tydic.payment.pay.atom.PayMethodAtomService;
import com.tydic.payment.pay.busi.QueryCashierPayMethodService;
import com.tydic.payment.pay.busi.bo.PayMethodBo;
import com.tydic.payment.pay.busi.bo.QueryCashierPayMethodReqBo;
import com.tydic.payment.pay.busi.bo.QueryCashierPayMethodRspBo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.dao.po.CashierPayMethodRelPo;
import com.tydic.payment.pay.dao.po.CashierTemplatePo;
import com.tydic.payment.pay.dao.po.ChanneIdPayMethodRelPo;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.dao.po.MerchantPayMethodRelPo;
import com.tydic.payment.pay.dao.po.PayMethodPo;
import com.tydic.payment.pay.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="queryCashierPayMethodService")
public class QueryCashierPayMethodServiceImpl
implements QueryCashierPayMethodService {
    private static final Logger log = LoggerFactory.getLogger(QueryCashierPayMethodServiceImpl.class);
    @Autowired
    private MerchantInfoAtomService merchantInfoAtomService;
    @Autowired
    private MerchantPayMethodRelAtomService merchantPayMethodRelAtomService;
    @Autowired
    private CashierTemplateAtomService cashierTemplateAtomService;
    @Autowired
    private CashierPayMethodRelAtomService cashierPayMethodRelAtomService;
    @Autowired
    private PayMethodAtomService payMethodAtomService;
    @Autowired
    private ChannelIdPayMethodRelAtomService channelIdPayMethodRelAtomService;

    public QueryCashierPayMethodRspBo queryCashierPayMethod(QueryCashierPayMethodReqBo bo) {
        log.info("\u67e5\u8be2\u652f\u4ed8\u65b9\u5f0f\u5217\u8868\u5165\u53c2:" + bo);
        this.validateArg(bo);
        QueryCashierPayMethodRspBo validateHasId = this.validateHasId(bo);
        if (!"0000".equals(validateHasId.getRspCode())) {
            return validateHasId;
        }
        QueryCashierPayMethodRspBo retBo = new QueryCashierPayMethodRspBo();
        MerchantPayMethodRelPo merchantPayMethodRelPo = new MerchantPayMethodRelPo();
        merchantPayMethodRelPo.setMerchantId(Long.valueOf(bo.getMerchantId()));
        ArrayList<Long> listA = new ArrayList<Long>();
        List<MerchantPayMethodRelPo> queryMerchantPayMethodRelByCondition = this.merchantPayMethodRelAtomService.queryMerchantPayMethodRelByCondition(merchantPayMethodRelPo);
        for (MerchantPayMethodRelPo po : queryMerchantPayMethodRelByCondition) {
            if ("0".equals(po.getStatus())) continue;
            listA.add(po.getPayMethod());
        }
        CashierPayMethodRelPo cashierPayMethodRelPo = new CashierPayMethodRelPo();
        cashierPayMethodRelPo.setCashierTemplate(Long.valueOf(bo.getCashierTemplate()));
        ArrayList<Long> listB = new ArrayList<Long>();
        List<CashierPayMethodRelPo> queryCashierPayMethodRelByCondition = this.cashierPayMethodRelAtomService.queryCashierPayMethodRelByCondition(cashierPayMethodRelPo);
        for (CashierPayMethodRelPo po : queryCashierPayMethodRelByCondition) {
            listB.add(po.getPayMethod());
        }
        listA.retainAll(listB);
        if (listA.isEmpty()) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u672a\u67e5\u8be2\u5230\u7b26\u5408\u6761\u4ef6\u7684\u652f\u4ed8\u65b9\u5f0f");
        }
        if (!StringUtils.isEmpty((Object)bo.getChannelId())) {
            ChanneIdPayMethodRelPo channeIdPayMethodRelPo = new ChanneIdPayMethodRelPo();
            channeIdPayMethodRelPo.setChannelId(bo.getChannelId());
            List<ChanneIdPayMethodRelPo> queryChanneIdPayMethodRelByCondition = this.channelIdPayMethodRelAtomService.queryChannelIdPayMethodRelByCondition(channeIdPayMethodRelPo);
            if (!queryChanneIdPayMethodRelByCondition.isEmpty()) {
                ArrayList<Long> listc = new ArrayList<Long>();
                for (ChanneIdPayMethodRelPo po : queryChanneIdPayMethodRelByCondition) {
                    listc.add(po.getPayMethod());
                }
                listA.retainAll(listc);
            }
        }
        List<PayMethodPo> queryPayMethodByMethods = this.payMethodAtomService.queryPayMethodByMethods(listA);
        ArrayList<PayMethodBo> retList = new ArrayList<PayMethodBo>();
        PayMethodPo cashPay = null;
        for (PayMethodPo tPo : queryPayMethodByMethods) {
            if (tPo == null) continue;
            if (PayProConstants.PayMethod.CASH_PAY.getPayMethod().equals(tPo.getPayMethod())) {
                cashPay = tPo;
                continue;
            }
            PayMethodBo tBo = new PayMethodBo();
            BeanUtils.copyProperties((Object)tPo, (Object)tBo);
            tBo.setPayMethod(tPo.getPayMethod() + "");
            retList.add(tBo);
        }
        if (null != cashPay) {
            PayMethodBo tBo = new PayMethodBo();
            BeanUtils.copyProperties(cashPay, (Object)tBo);
            tBo.setPayMethod(cashPay.getPayMethod() + "");
            retList.add(tBo);
        }
        retBo.setRspCode("0000");
        retBo.setRspName("\u652f\u4ed8\u65b9\u5f0f\u5217\u8868\u67e5\u8be2\u6210\u529f");
        retBo.setCodePayMethodList(retList);
        return retBo;
    }

    private QueryCashierPayMethodRspBo validateHasId(QueryCashierPayMethodReqBo bo) {
        QueryCashierPayMethodRspBo retBo = new QueryCashierPayMethodRspBo();
        MerChantInfoPo po = new MerChantInfoPo();
        po.setMerchantId(Long.valueOf(bo.getMerchantId()));
        List<MerChantInfoPo> querycreateMerChantInfoByCondition = this.merchantInfoAtomService.queryMerChantInfoByCondition(po);
        if (querycreateMerChantInfoByCondition.size() < 1) {
            log.error("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u5546\u6237\u4fe1\u606f");
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u5546\u6237\u4fe1\u606f");
        }
        CashierTemplatePo po1 = new CashierTemplatePo();
        po1.setCashierTemplate(Long.valueOf(bo.getCashierTemplate()));
        List<CashierTemplatePo> queryCashierTemplateByCondition = this.cashierTemplateAtomService.queryCashierTemplateByCondition(po1);
        if (queryCashierTemplateByCondition.size() < 1) {
            log.error("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u6536\u94f6\u53f0\u6a21\u677f\u4fe1\u606f");
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u6536\u94f6\u53f0\u6a21\u677f\u4fe1\u606f");
        }
        retBo.setRspCode("0000");
        retBo.setRspName("\u67e5\u8be2\u652f\u4ed8\u65b9\u5f0f\u5217\u8868\u6210\u529f");
        return retBo;
    }

    private void validateArg(QueryCashierPayMethodReqBo bo) {
        if (bo == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u652f\u4ed8\u65b9\u5f0f\u5217\u8868\u5165\u53c2bo\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (bo.getMerchantId() == null || bo.getMerchantId().trim().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u652f\u4ed8\u65b9\u5f0f\u5217\u8868\u5165\u53c2bo\u5bf9\u8c61\u5c5e\u6027MerchantId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (bo.getCashierTemplate() == null || bo.getCashierTemplate().trim().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u652f\u4ed8\u65b9\u5f0f\u5217\u8868\u5165\u53c2bo\u5bf9\u8c61\u5c5e\u6027CashierTemplate\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

