/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.busi.CallBackNoticeService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.UnionAcpPayQueryBusiService;
import com.tydic.payment.pay.busi.UnionPayOrderQueryBusiService;
import com.tydic.payment.pay.busi.bo.CallBackNoticeReqBo;
import com.tydic.payment.pay.busi.bo.CallBackNoticeRspBo;
import com.tydic.payment.pay.busi.bo.UnionAcpPayQueryBusiReqBO;
import com.tydic.payment.pay.busi.bo.UnionAcpPayQueryBusiRspBO;
import com.tydic.payment.pay.busi.bo.UnionPayOrderQueryBusiReqBO;
import com.tydic.payment.pay.busi.bo.UnionPayOrderQueryBusiRspBO;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="unionPayOrderQueryBusiService")
public class UnionPayOrderQueryBusiServiceImpl
implements UnionPayOrderQueryBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnionPayOrderQueryBusiServiceImpl.class);
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private CallBackNoticeService callBackNoticeService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private UnionAcpPayQueryBusiService unionAcpPayQueryBusiService;

    public UnionPayOrderQueryBusiRspBO dealUnionPayOrderQuery(UnionPayOrderQueryBusiReqBO req) {
        LOGGER.debug("\u94f6\u8054\u652f\u4ed8\u8ba2\u5355\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + req);
        UnionAcpPayQueryBusiReqBO unionAcpPayQueryBusiReqBO = new UnionAcpPayQueryBusiReqBO();
        BeanUtils.copyProperties((Object)req, (Object)unionAcpPayQueryBusiReqBO);
        unionAcpPayQueryBusiReqBO.setOrderId(req.getPayOrderId());
        UnionAcpPayQueryBusiRspBO unionAcpPayQueryBusiRspBO = this.unionAcpPayQueryBusiService.query(unionAcpPayQueryBusiReqBO);
        return this.buildRspBO(req, unionAcpPayQueryBusiRspBO);
    }

    private UnionPayOrderQueryBusiRspBO buildRspBO(UnionPayOrderQueryBusiReqBO req, UnionAcpPayQueryBusiRspBO rspData) {
        UnionPayOrderQueryBusiRspBO rspBO = new UnionPayOrderQueryBusiRspBO();
        rspBO.setPayOrderId(req.getOrderId());
        rspBO.setRspCode("8888");
        rspBO.setRspName(rspData.getRspName());
        if ("00".equals(rspData.getRspCode())) {
            String origRespCode = rspData.getOrigRespCode();
            if ("00".equals(origRespCode)) {
                rspBO.setRspCode("0000");
                rspBO.setPayStatus("SUCCESS");
            } else if ("03".equals(origRespCode) || "04".equals(origRespCode) || "05".equals(origRespCode)) {
                rspBO.setRspCode("0000");
                rspBO.setPayStatus("PAYING");
            } else {
                rspBO.setPayStatus("FAIL");
            }
        } else {
            rspBO.setPayStatus("FAIL");
        }
        String totalFee = "";
        if (!StringUtils.isEmpty((Object)rspData.getTxnAmt())) {
            totalFee = String.valueOf(MoneyUtils.fenToYuan((String)rspData.getTxnAmt()).longValue());
        }
        rspBO.setTotalFee(totalFee);
        rspBO.setTransaction_id(rspData.getQueryId());
        rspBO.setTradeTime(rspData.getTxnTime());
        this.updateOrderAndTrans(req, rspBO);
        return rspBO;
    }

    private void updateOrderAndTrans(UnionPayOrderQueryBusiReqBO req, UnionPayOrderQueryBusiRspBO rspBO) {
        PorderPayTransAtomReqBo orderPayTransAtomReq = new PorderPayTransAtomReqBo();
        PorderPo updateOrderPo = new PorderPo();
        String tradeTime = rspBO.getTradeTime();
        Long fee = null;
        if (!StringUtils.isEmpty((Object)rspBO.getTotalFee())) {
            fee = MoneyUtils.yuanToHao((String)rspBO.getTotalFee()).longValue();
        }
        if (StringUtils.isEmpty((Object)tradeTime)) {
            Date dbDate = this.queryDBDateBusiService.getDBDate();
            tradeTime = new SimpleDateFormat("yyyyMMddHHmmss").format(dbDate);
        }
        orderPayTransAtomReq.setPayOrderId(req.getPayOrderId());
        updateOrderPo.setOrderId(Long.valueOf(req.getOrderId()));
        orderPayTransAtomReq.setOrderId(updateOrderPo.getOrderId());
        updateOrderPo.setRealFee(fee);
        updateOrderPo.setOnlineFee(fee);
        updateOrderPo.setTradeTime(tradeTime);
        orderPayTransAtomReq.setTradeTime(tradeTime);
        orderPayTransAtomReq.setPayNotifyTransId(rspBO.getTransaction_id());
        if ("SUCCESS".equals(rspBO.getPayStatus())) {
            orderPayTransAtomReq.setOrderStatus("A10");
            updateOrderPo.setOrderStatus("A10");
        } else if ("FAIL".equals(rspBO.getPayStatus())) {
            orderPayTransAtomReq.setOrderStatus("A20");
            updateOrderPo.setOrderStatus("A20");
        }
        if (!"PAYING".equals(rspBO.getPayStatus())) {
            this.payOrderAtomService.update(updateOrderPo);
            try {
                this.porderPayTransAtomService.updateOrderPayTransByPayOrderId(orderPayTransAtomReq);
            }
            catch (Exception e) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u66f4\u65b0\u652f\u4ed8\u6d41\u6c34\u5931\u8d25\uff1a", (Throwable)e);
            }
            CallBackNoticeReqBo callBackNoticeReqBo = new CallBackNoticeReqBo();
            callBackNoticeReqBo.setOrderId(orderPayTransAtomReq.getOrderId());
            CallBackNoticeRspBo callBackNoticeRspBo = this.callBackNoticeService.dealPayPutMq(callBackNoticeReqBo);
            if ("0000".equals(callBackNoticeRspBo.getRspCode())) {
                LOGGER.info(orderPayTransAtomReq.getOrderId() + "\u53d1\u9001\u6d88\u606f\u961f\u5217\u6210\u529f");
            }
        }
    }
}

