/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayRspBo;
import com.tydic.payment.pay.config.PayProSequence;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.dao.PayMethodMapper;
import com.tydic.payment.pay.icbc.DefaultIcbcClient;
import com.tydic.payment.pay.icbc.IcbcApiException;
import com.tydic.payment.pay.icbc.bo.MybankPayCpayCppayapplyRequestV2;
import com.tydic.payment.pay.icbc.bo.MybankPayCpayCppayapplyResponseV2;
import com.tydic.payment.pay.icbc.intf.BizContent;
import com.tydic.payment.pay.icbc.intf.IcbcRequest;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.payable.impl.AbstractIcbcPayAble;
import java.util.ArrayList;
import java.util.Map;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class IbcbEPayAble
extends AbstractIcbcPayAble
implements PayAble {
    private static final Logger log = LoggerFactory.getLogger(IbcbEPayAble.class);
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PayMethodMapper payMethodMapper;

    public Long getPayMethod() {
        return PayProConstants.PayMethod.ICBC_E_PAY.getPayMethod();
    }

    public PayAbleDealPayRspBo dealPay(PayAbleDealPayReqBo reqBo) {
        MybankPayCpayCppayapplyResponseV2 response;
        PayAbleDealPayRspBo retBo = new PayAbleDealPayRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a{}", (Object)validateStr);
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        String icbcNotifyUrl = this.payPropertiesVo.getValueByKey("icbc.epay.notify.url");
        if (StringUtils.isEmpty((Object)icbcNotifyUrl)) {
            log.error("*\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u652f\u4ed8\u56de\u8c03\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0{}", (Object)"icbc.epay.notify.url");
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u652f\u4ed8\u56de\u8c03\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0icbc.epay.notify.url");
            return retBo;
        }
        String icbcUrl = this.payPropertiesVo.getValueByKey("icbc.epay.url");
        if (StringUtils.isEmpty((Object)icbcUrl)) {
            log.error("*\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u8ba2\u5355\u7533\u8bf7\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0{}", (Object)"icbc.epay.url");
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u8ba2\u5355\u7533\u8bf7\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0icbc.epay.url");
            return retBo;
        }
        Map paraMap = reqBo.getParaMap();
        String accountNo = (String)paraMap.get("accountNo");
        String accountName = (String)paraMap.get("accountName");
        Map payTransMap = reqBo.getPayTransParam();
        String payerAccNo = payTransMap.get("payerAccNo").toString();
        String payerAccName = payTransMap.get("payerAccName").toString();
        ArrayList<MybankPayCpayCppayapplyRequestV2.BeanRecvMallInfo> recvMallInfoList = new ArrayList<MybankPayCpayCppayapplyRequestV2.BeanRecvMallInfo>();
        MybankPayCpayCppayapplyRequestV2.BeanRecvMallInfo recvMallInfo = new MybankPayCpayCppayapplyRequestV2.BeanRecvMallInfo();
        recvMallInfo.setMallCode(accountNo);
        recvMallInfo.setMallName(accountName);
        recvMallInfo.setPayeeCompanyName(accountName);
        recvMallInfo.setPayeeSysflag("1");
        recvMallInfo.setPayeeAccno(accountNo);
        recvMallInfo.setPayAmount(reqBo.getPayFee().toString());
        recvMallInfoList.add(recvMallInfo);
        ArrayList<MybankPayCpayCppayapplyRequestV2.BeanGoodsInfo> goodsInfoList = new ArrayList<MybankPayCpayCppayapplyRequestV2.BeanGoodsInfo>();
        MybankPayCpayCppayapplyRequestV2.BeanGoodsInfo goodsInfo = new MybankPayCpayCppayapplyRequestV2.BeanGoodsInfo();
        String subId = String.valueOf(PayProSequence.nextId());
        goodsInfo.setGoodsSubId(subId.substring(subId.length() - 5));
        goodsInfo.setGoodsName(reqBo.getDetailName());
        goodsInfo.setPayeeCompanyName(accountName);
        goodsInfo.setGoodsNumber("1");
        goodsInfo.setGoodsUnit("\u5355");
        goodsInfo.setGoodsAmt(reqBo.getPayFee().toString());
        goodsInfoList.add(goodsInfo);
        DefaultIcbcClient client = new DefaultIcbcClient(ICBC_APP_ID, "RSA2", ICBC_PRIVATE_KEY, ICBC_PUBLIC_KEY);
        MybankPayCpayCppayapplyRequestV2 request = new MybankPayCpayCppayapplyRequestV2();
        request.setServiceUrl(icbcUrl);
        MybankPayCpayCppayapplyRequestV2.MybankPayCpayCppayapplyRequestV2Biz bizContent = new MybankPayCpayCppayapplyRequestV2.MybankPayCpayCppayapplyRequestV2Biz();
        String payOrderId = reqBo.getPayOrderId();
        bizContent.setAgreeCode(ICBC_AGREEMENT_CODE);
        bizContent.setPartnerSeq(payOrderId);
        bizContent.setPayChannel("1");
        bizContent.setInternationalFlag("1");
        bizContent.setPayMode("1");
        bizContent.setPayEntitys("1");
        bizContent.setAsynFlag("0");
        bizContent.setPayMemno(payOrderId.substring(payOrderId.length() - 15));
        bizContent.setOrderCode(payOrderId);
        bizContent.setOrderAmount(reqBo.getPayFee().toString());
        bizContent.setOrderCurr("001");
        bizContent.setSumPayamt(reqBo.getPayFee().toString());
        bizContent.setOrderRemark(reqBo.getRemark());
        DateTime nowTime = new DateTime((Object)this.payMethodMapper.getDBDate().getDate());
        bizContent.setSubmitTime(nowTime.toString("yyyyMMddHHmmss"));
        if ("1".equals(this.icbcTest)) {
            bizContent.setSubmitTime(this.icbcTestTime + nowTime.toString("HHmmss"));
        }
        bizContent.setReturnUrl(reqBo.getRedirectUrl());
        bizContent.setCallbackUrl(icbcNotifyUrl);
        bizContent.setPayeeList(recvMallInfoList);
        bizContent.setGoodsList(goodsInfoList);
        bizContent.setPayerAccno(payerAccNo);
        bizContent.setPayerAccname(payerAccName);
        request.setBizContent((BizContent)bizContent);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u7684request\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)request));
        }
        String msgId = String.valueOf(PayProSequence.nextId());
        try {
            response = (MybankPayCpayCppayapplyResponseV2)client.execute((IcbcRequest)request, msgId);
        }
        catch (IcbcApiException e) {
            log.info("\u8c03\u7528\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u8ba2\u5355\u7533\u8bf7\u63a5\u53e3\u5f02\u5e38\uff1a{}", (Object)e.getErrMsg());
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u8c03\u7528\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u8ba2\u5355\u7533\u8bf7\u63a5\u53e3\u5f02\u5e38\uff1a" + e.getErrMsg());
            return retBo;
        }
        log.info("\u8c03\u7528\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u8ba2\u5355\u7533\u8bf7\u63a5\u53e3\u5f97\u5230\u7684\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)response));
        if (!response.isSuccess()) {
            log.info("\u8c03\u7528\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u8ba2\u5355\u7533\u8bf7\u63a5\u53e3\u4e0b\u5355\u5931\u8d25\uff1a{}", (Object)response.getReturnMsg());
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u8c03\u7528\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u8ba2\u5355\u7533\u8bf7\u63a5\u53e3\u4e0b\u5355\u5931\u8d25\uff1a" + response.getReturnMsg());
            return retBo;
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        retBo.setWebUrl(response.getRedirectParam());
        return retBo;
    }

    @Override
    public PayAbleCallBackRspBo dealCallBack(PayAbleCallBackReqBo reqBo) {
        PayAbleCallBackRspBo retBo = super.dealCallBack(reqBo);
        if (reqBo.isRefund()) {
            retBo.setRefundOrderId(retBo.getPayOrderId());
            retBo.setRefundNotifyTransId(retBo.getPayNotifyTransId());
        }
        return retBo;
    }

    private String validateArgs(PayAbleDealPayReqBo reqBo) {
        String validateConfig = super.init();
        if (!StringUtils.isEmpty((Object)validateConfig)) {
            return validateConfig;
        }
        if (null == reqBo) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayFee().toString())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payFee'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payOrderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiReqData())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'busiReqData'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayTransParam())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payTransParam'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        Map payTransParam = reqBo.getPayTransParam();
        if (StringUtils.isEmpty(payTransParam.get("payerAccName"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'busiReqData'\u4e2d[payerAccName]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty(payTransParam.get("payerAccNo"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'busiReqData'\u4e2d[payerAccNo]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return super.validateParaMap(reqBo.getParaMap());
    }
}

