/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.tydic.payment.pay.busi.bo.PayAbleDealPayReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayRspBo;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.payable.impl.AbstractWxPayAble;
import com.tydic.payment.pay.wx.req.bo.WXApiMicroPayReqBO;
import com.tydic.payment.pay.wx.rsp.bo.WXApiMicroPayRspBO;
import com.tydic.payment.pay.wx.util.HttpsRequest;
import com.tydic.payment.pay.wx.util.Signature;
import com.tydic.payment.pay.wx.util.Util;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class WxPayBarCodePayAbleImpl
extends AbstractWxPayAble
implements PayAble {
    private static final Logger LOG = LoggerFactory.getLogger(WxPayBarCodePayAbleImpl.class);
    private static final String SUCCESS = "SUCCESS";
    private static final String FAIL = "FAIL";
    @Autowired
    private PayPropertiesVo payPropertiesVo;

    public Long getPayMethod() {
        return PayProConstants.PayMethod.WX_BAR.getPayMethod();
    }

    public PayAbleDealPayRspBo dealPay(PayAbleDealPayReqBo reqBo) {
        PayAbleDealPayRspBo retBo = new PayAbleDealPayRspBo();
        String validataArgStr = this.validataArg(reqBo);
        if (!StringUtils.isEmpty((Object)validataArgStr)) {
            retBo.setRespCode("212017");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validataArgStr);
            return retBo;
        }
        String wxMicoPayUrl = this.payPropertiesVo.getWXMicoPayUrl();
        if (StringUtils.isEmpty((Object)wxMicoPayUrl)) {
            LOG.error("\u5fae\u4fe1\u6761\u7801\u652f\u4ed8\u5730\u5740(wxMicoPayUrl)\u672a\u914d\u7f6e");
            throw new BusinessException("216016", "\u5fae\u4fe1\u6761\u7801\u652f\u4ed8\u5730\u5740(wxMicoPayUrl)\u672a\u914d\u7f6e");
        }
        Map paraMap = reqBo.getParaMap();
        String appId = (String)paraMap.get("appid");
        String mchId = (String)paraMap.get("mchid");
        String signKey = (String)paraMap.get("signkey");
        WXApiMicroPayReqBO microPayReqData = new WXApiMicroPayReqBO().setAppid(appId).setMch_id(mchId).setBody(reqBo.getDetailName()).setOut_trade_no(reqBo.getPayOrderId()).setTotal_fee(Integer.parseInt(reqBo.getPayFee() + "")).setSpbill_create_ip(reqBo.getCreateIpAddress()).setAuth_code(reqBo.getAuthCode()).setNonce_str("").setKey(signKey);
        if (microPayReqData == null) {
            LOG.error("\u5fae\u4fe1\u6761\u7801\u652f\u4ed8\u63a5\u53e3\u5165\u53c2(WXApiMicroPayReqBO)\u4e3a\u7a7a");
            throw new BusinessException("216016", "\u5fae\u4fe1\u6761\u7801\u652f\u4ed8\u63a5\u53e3\u5165\u53c2(WXApiMicroPayReqBO)\u4e3a\u7a7a");
        }
        String resultStr = null;
        try {
            HttpsRequest httpsRequest = new HttpsRequest();
            resultStr = httpsRequest.sendPostPayPro(wxMicoPayUrl, (Object)microPayReqData);
        }
        catch (Exception e) {
            LOG.error("\u8c03\u7528\u5fae\u4fe1\u6761\u7801\u652f\u4ed8\u63a5\u53e3\u5f02\u5e38\uff1a" + e);
            throw new BusinessException("216016", "\u8c03\u7528\u5fae\u4fe1\u6761\u7801\u652f\u4ed8\u63a5\u53e3\u5f02\u5e38\uff1a" + e);
        }
        if (StringUtils.isEmpty((Object)resultStr)) {
            LOG.error("\u5fae\u4fe1\u6761\u7801\u63a5\u53e3\u8fd4\u56de\u5b57\u7b26\u4e32\u4e3a\u7a7a");
            throw new BusinessException("216016", "\u5fae\u4fe1\u6761\u7801\u63a5\u53e3\u8fd4\u56de\u5b57\u7b26\u4e32\u4e3a\u7a7a");
        }
        WXApiMicroPayRspBO rspData = (WXApiMicroPayRspBO)Util.getObjectFromXMLGeneric((String)resultStr, WXApiMicroPayRspBO.class);
        LOG.info(resultStr);
        if (rspData == null) {
            LOG.error("\u5fae\u4fe1\u6761\u7801\u652f\u4ed8\u63a5\u53e3\u8fd4\u56de\u5bf9\u8c61\u4e3a\u7a7a");
            throw new BusinessException("216016", "\u5fae\u4fe1\u6761\u7801\u652f\u4ed8\u63a5\u53e3\u8fd4\u56de\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (SUCCESS.equals(rspData.getReturn_code()) && SUCCESS.equals(rspData.getResult_code())) {
            try {
                if (!Signature.checkIsSignValidFromResponseString((String)resultStr, (String)microPayReqData.getKey())) {
                    LOG.error("\u5fae\u4fe1\u6761\u7801\u652f\u4ed8\u63a5\u53e3\u8fd4\u56de\u540e\u7b7e\u540d\u9519\u8bef");
                    throw new BusinessException("216016", "\u5fae\u4fe1\u6761\u7801\u652f\u4ed8\u63a5\u53e3\u8fd4\u56de\u7b7e\u540d\u9519\u8bef");
                }
            }
            catch (Exception e) {
                LOG.error("\u5fae\u4fe1\u6761\u7801\u652f\u4ed8\u63a5\u53e3\u8fd4\u56de\u540e\u7b7e\u540d\u5f02\u5e38\uff1a" + e);
                throw new BusinessException("216016", "\u5fae\u4fe1\u6761\u7801\u652f\u4ed8\u63a5\u53e3\u8fd4\u56de\u540e\u7b7e\u540d\u5f02\u5e38\uff1a" + e);
            }
        }
        retBo = this.sortMicroRetBo(reqBo, retBo, rspData);
        return retBo;
    }

    private PayAbleDealPayRspBo sortMicroRetBo(PayAbleDealPayReqBo reqBo, PayAbleDealPayRspBo retBo, WXApiMicroPayRspBO rspData) {
        if (!SUCCESS.equals(rspData.getReturn_code())) {
            retBo.setRespCode("0000");
            retBo.setRespDesc(rspData.getReturn_msg());
            retBo.setPayResultCode(FAIL);
        }
        if (SUCCESS.equals(rspData.getResult_code())) {
            retBo.setRespCode("0000");
            retBo.setRespDesc("\u6210\u529f");
            retBo.setPayResultCode(SUCCESS);
            retBo.setPayResultMsg(rspData.getReturn_msg());
            retBo.setTradeTime(rspData.getTime_end());
            retBo.setPayNotifyTransId(rspData.getTransaction_id());
        }
        if (FAIL.equals(rspData.getResult_code()) && "USERPAYING".equals(rspData.getErr_code())) {
            retBo.setRespCode("0000");
            retBo.setRespDesc("\u6210\u529f");
            retBo.setPayResultCode("PAYING");
            retBo.setPayResultMsg(rspData.getErr_code_des());
            retBo.setPayNotifyTransId(rspData.getTransaction_id());
        }
        if (FAIL.equals(rspData.getResult_code()) && "AUTH_CODE_INVALID".equals(rspData.getErr_code())) {
            retBo.setRespCode("0000");
            retBo.setRespDesc("\u6210\u529f");
            retBo.setPayResultCode(FAIL);
            retBo.setPayResultMsg(rspData.getErr_code_des());
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        return retBo;
    }

    private String validataArg(PayAbleDealPayReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payFee\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getDetailName())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027detailName\u4e0d\u80fd\u4e3a\u7a7a ";
        }
        if (StringUtils.isEmpty((Object)reqBo.getCreateIpAddress())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027createIpAddress\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getAuthCode())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027authCode\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaMap())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e0d\u80fd\u4e3a\u7a7a";
        }
        Map paraMap = reqBo.getParaMap();
        String validataMapStr = this.validataMap(paraMap);
        if (!StringUtils.isEmpty((Object)validataMapStr)) {
            return validataMapStr;
        }
        return null;
    }

    private String validataMap(Map<String, String> paraMap) {
        String appId = paraMap.get("appid");
        String mchId = paraMap.get("mchid");
        String signKey = paraMap.get("signkey");
        String certPath = paraMap.get("certname");
        String certPassword = paraMap.get("certpassword");
        if (StringUtils.isEmpty((Object)appId)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e2d(appid)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)mchId)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e2d(mchId)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)signKey)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e2d(signKey)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

