/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import cn.hutool.core.lang.TypeReference;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.busi.ChinaPayQrBusiService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.bo.ChinaPayQrBusiReqBO;
import com.tydic.payment.pay.busi.bo.ChinaPayQrBusiRspBO;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayRspBo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.util.PayAbleManager;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="chinaPayQrBusiService")
public class ChinaPayQrBusiServiceImpl
implements ChinaPayQrBusiService {
    private static final Logger log = LoggerFactory.getLogger(ChinaPayQrBusiServiceImpl.class);
    private final PayOrderAtomService payOrderAtomService;
    private final QueryDBDateBusiService queryDBDateBusiService;
    private final PorderPayTransAtomService porderPayTransAtomService;
    private final PayAbleManager payAbleManager;

    public ChinaPayQrBusiServiceImpl(PayOrderAtomService payOrderAtomService, QueryDBDateBusiService queryDBDateBusiService, PorderPayTransAtomService porderPayTransAtomService, PayAbleManager payAbleManager) {
        this.payOrderAtomService = payOrderAtomService;
        this.queryDBDateBusiService = queryDBDateBusiService;
        this.porderPayTransAtomService = porderPayTransAtomService;
        this.payAbleManager = payAbleManager;
    }

    public ChinaPayQrBusiRspBO dealChinaPayQr(ChinaPayQrBusiReqBO busiReqBO) {
        log.info("\u94f6\u8054\uff08\u65b0\u4e00\u4ee3\uff09\u4e8c\u7ef4\u7801\u652f\u4ed8\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)busiReqBO));
        ChinaPayQrBusiRspBO busiRspBO = new ChinaPayQrBusiRspBO();
        PorderPo orderInfo = this.payOrderAtomService.queryPorderInfo(Long.valueOf(busiReqBO.getOrderId()));
        Date createTime = this.queryDBDateBusiService.getDBDate();
        String payOrderId = this.createPayTrans(orderInfo, createTime);
        busiRspBO.setPayOrderId(payOrderId);
        PayAble payAble = this.payAbleManager.getPayAbleByPayMethod(171L);
        PayAbleDealPayReqBo payAbleDealPayReqBo = new PayAbleDealPayReqBo();
        payAbleDealPayReqBo.setPayOrderId(busiReqBO.getOrderId());
        payAbleDealPayReqBo.setMerchantId(busiReqBO.getMerchantId());
        payAbleDealPayReqBo.setPayFee(Long.valueOf(busiReqBO.getTotalFee().longValue()));
        Map paramMap = (Map)JSON.parseObject((String)JSON.toJSONString((Object)busiReqBO.getParamMap()), (Type)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        payAbleDealPayReqBo.setParaMap(paramMap);
        PayAbleDealPayRspBo payAbleDealPayRspBo = payAble.dealPay(payAbleDealPayReqBo);
        BeanUtils.copyProperties((Object)payAbleDealPayRspBo, (Object)busiRspBO);
        busiRspBO.setRspCode(payAbleDealPayRspBo.getRespCode());
        busiRspBO.setRspName(payAbleDealPayRspBo.getRespDesc());
        return busiRspBO;
    }

    private String createPayTrans(PorderPo orderInfo, Date createTime) {
        PorderPayTransAtomReqBo orderPayTransAtomReq = new PorderPayTransAtomReqBo();
        orderPayTransAtomReq.setOrderId(orderInfo.getOrderId());
        orderPayTransAtomReq.setBusiId(orderInfo.getBusiId());
        orderPayTransAtomReq.setMerchantId(orderInfo.getMerchantId());
        orderPayTransAtomReq.setPayMethod(Long.parseLong("112"));
        orderPayTransAtomReq.setOrderStatus("A00");
        orderPayTransAtomReq.setPayFee(orderInfo.getTotalFee());
        orderPayTransAtomReq.setCreateTime(createTime);
        try {
            return this.porderPayTransAtomService.createOrderPayTrans(orderPayTransAtomReq);
        }
        catch (Exception e) {
            throw new BusinessException("\u7cfb\u7edf\u5f02\u5e38", "\u521b\u5efa\u652f\u4ed8\u6d41\u6c34\u5931\u8d25\uff1a", (Throwable)e);
        }
    }
}

