/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.tydic.payment.pay.busi.PayInfoContractQueryBusiService;
import com.tydic.payment.pay.busi.bo.PayInfoContractQueryBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayInfoContractQueryBusiRspBo;
import com.tydic.payment.pay.dao.PayInfoContractMapper;
import com.tydic.payment.pay.dao.po.PayInfoContractPo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="payInfoContractQueryBusiService")
public class PayInfoContractQueryBusiServiceImpl
implements PayInfoContractQueryBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PayInfoContractMapper payInfoContractMapper;

    public PayInfoContractQueryBusiRspBo queryContractInfo(PayInfoContractQueryBusiReqBo reqBo) {
        this.LOGGER.info("\u534f\u8bae\u4fe1\u606f\u8868\u67e5\u8be2\u670d\u52a1\uff1a" + reqBo);
        PayInfoContractQueryBusiRspBo retBo = new PayInfoContractQueryBusiRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("212051");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        PayInfoContractPo reqPo = new PayInfoContractPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)reqPo);
        List<PayInfoContractPo> contractInfos = this.payInfoContractMapper.selectByCondition(reqPo);
        if (CollectionUtils.isEmpty(contractInfos)) {
            this.LOGGER.error("\u672a\u67e5\u8be2\u5230\u6709\u6548\u6570\u636e");
            retBo.setRespCode("212051");
            retBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u6709\u6548\u6570\u636e");
            return retBo;
        }
        for (PayInfoContractPo po : contractInfos) {
            BeanUtils.copyProperties((Object)po, (Object)retBo);
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        this.LOGGER.info("\u534f\u8bae\u4fe1\u606f\u8868\u67e5\u8be2\u670d\u52a1\u51fa\u53c2\uff1a" + retBo);
        return retBo;
    }

    private String validateArgs(PayInfoContractQueryBusiReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getContractId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'contractId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

