/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.tydic.payment.pay.ability.bo.PayProBusiSystemDataBo;
import com.tydic.payment.pay.ability.bo.PayProQryBusiSystemListReqBo;
import com.tydic.payment.pay.ability.bo.PayProQryBusiSystemListRspBo;
import com.tydic.payment.pay.ability.bo.PayProReqWayDataBo;
import com.tydic.payment.pay.atom.PayProQryCodeListMapAtomService;
import com.tydic.payment.pay.atom.bo.PayProQryCodeListMapAtomReqBo;
import com.tydic.payment.pay.busi.PayProQryBusiSystemListBusiService;
import com.tydic.payment.pay.dao.BusiSystemInfoMapper;
import com.tydic.payment.pay.dao.RelBusiCashierMapper;
import com.tydic.payment.pay.dao.po.BusiSystemInfoPO;
import com.tydic.payment.pay.dao.po.RelBusiCashierPo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="payProQryBusiSystemListBusiService")
public class PayProQryBusiSystemListBusiServiceImpl
implements PayProQryBusiSystemListBusiService {
    private static final Logger log = LoggerFactory.getLogger(PayProQryBusiSystemListBusiServiceImpl.class);
    private static Map<String, String> reqWayTransMap;
    @Autowired
    private RelBusiCashierMapper relBusiCashierMapper;
    @Autowired
    private PayProQryCodeListMapAtomService payProQryCodeListMapAtomService;
    @Autowired
    private BusiSystemInfoMapper busiSystemInfoMapper;

    public PayProQryBusiSystemListRspBo queryBusiSystems(PayProQryBusiSystemListReqBo reqBo) {
        PayProQryBusiSystemListRspBo retBo = new PayProQryBusiSystemListRspBo();
        ArrayList<PayProBusiSystemDataBo> busiSystems = new ArrayList<PayProBusiSystemDataBo>();
        retBo.setBusiSystems(busiSystems);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        List<BusiSystemInfoPO> busSystemInfoPos = this.busiSystemInfoMapper.listStateEffective();
        if (CollectionUtils.isEmpty(busSystemInfoPos)) {
            log.info("\u67e5\u8be2\u72b6\u6001\u6709\u6548\u7684\u4e1a\u52a1\u7cfb\u7edf\u5217\u8868\u4e3a\u7a7a");
            return retBo;
        }
        PayProQryCodeListMapAtomReqBo dicReqBo = new PayProQryCodeListMapAtomReqBo();
        dicReqBo.setTypeCode("BUSI_SYSTEM_REQ_WAY");
        reqWayTransMap = this.payProQryCodeListMapAtomService.getDicMap(dicReqBo).getDicMap();
        for (BusiSystemInfoPO po : busSystemInfoPos) {
            PayProBusiSystemDataBo busiDataBo = new PayProBusiSystemDataBo();
            BeanUtils.copyProperties((Object)po, (Object)busiDataBo);
            this.getReqWayForBusiSys(busiDataBo);
            busiSystems.add(busiDataBo);
        }
        return retBo;
    }

    private void getReqWayForBusiSys(PayProBusiSystemDataBo busiDataBo) {
        RelBusiCashierPo queryPo = new RelBusiCashierPo();
        queryPo.setBusiId(busiDataBo.getBusiId());
        List<RelBusiCashierPo> relCashierPos = this.relBusiCashierMapper.queryRelBusiCashier(queryPo);
        if (CollectionUtils.isEmpty(relCashierPos)) {
            if (log.isDebugEnabled()) {
                log.debug("\u4e1a\u52a1\u7cfb\u7edf\uff08busiId = {}\uff09\u6ca1\u6709\u914d\u7f6e\u63a5\u5165\u65b9\u5f0f", (Object)busiDataBo.getBusiId());
            }
            return;
        }
        ArrayList<PayProReqWayDataBo> reqWayList = new ArrayList<PayProReqWayDataBo>();
        busiDataBo.setReqWayList(reqWayList);
        for (RelBusiCashierPo relCashierPo : relCashierPos) {
            PayProReqWayDataBo dataBo = new PayProReqWayDataBo();
            BeanUtils.copyProperties((Object)relCashierPo, (Object)dataBo);
            dataBo.setReqWayName(reqWayTransMap.get(dataBo.getReqWay()));
            reqWayList.add(dataBo);
        }
    }
}

