/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.atom.MerchantInfoAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.PorderRefundTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.dao.po.PorderPayTransPo;
import com.tydic.payment.pay.dao.po.PorderRefundTransPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.web.bo.req.QueryYesterdayIncomeWebReqBo;
import com.tydic.payment.pay.web.bo.rsp.QueryYesterdayIncomeWebRspBo;
import com.tydic.payment.pay.web.service.QueryYesterdayIncomeWebService;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"PAYMENT_GROUP_DEV/2.0.0/com.tydic.payment.pay.web.service.QueryYesterdayIncomeWebService"})
public class QueryYesterdayIncomeWebServiceImpl
implements QueryYesterdayIncomeWebService {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryYesterdayIncomeWebServiceImpl.class);
    @Autowired
    private MerchantInfoAtomService merchantInfoAtomService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private PorderRefundTransAtomService porderRefundTransAtomService;

    @PostMapping(value={"qryMyYesterdayIncome"})
    public QueryYesterdayIncomeWebRspBo qryMyYesterdayIncome(@RequestBody QueryYesterdayIncomeWebReqBo reqBo) {
        LOGGER.info("\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        this.validateArg(reqBo);
        QueryYesterdayIncomeWebRspBo rspBo = new QueryYesterdayIncomeWebRspBo();
        rspBo.setRspCode("0000");
        rspBo.setRspName("\u6210\u529f");
        MerChantInfoPo qryMerPo = new MerChantInfoPo();
        qryMerPo.setCreateOperId(reqBo.getOperId());
        List<MerChantInfoPo> qryMerL = this.merchantInfoAtomService.queryMerChantIdAndNameByCondition(qryMerPo);
        if (CollectionUtils.isEmpty(qryMerL)) {
            rspBo.setIncomeNumber("0");
            rspBo.setNetIncomeFee("0");
            rspBo.setRefundNumber("0");
            rspBo.setTotalIncomeFee("0");
            rspBo.setTotalRefundFee("0");
            return rspBo;
        }
        HashSet<Long> merchantIdSet = new HashSet<Long>();
        for (MerChantInfoPo temp : qryMerL) {
            if (merchantIdSet.contains(temp.getMerchantId())) continue;
            merchantIdSet.add(temp.getMerchantId());
        }
        PorderPayTransPo qryPorderPayTranasPo = new PorderPayTransPo();
        PorderRefundTransPo qryRefundPBo = new PorderRefundTransPo();
        if (!StringUtils.isEmpty((Object)reqBo.getTodayDate())) {
            qryPorderPayTranasPo.setCreateTime(new DateTime((Object)reqBo.getTodayDate()).minusDays(1).withMillisOfDay(0).toDate());
            qryPorderPayTranasPo.setCreateTimeEnd(new DateTime((Object)reqBo.getTodayDate()).withMillisOfDay(0).toDate());
            qryRefundPBo.setCreateTime(new DateTime((Object)reqBo.getTodayDate()).minusDays(1).withMillisOfDay(0).toDate());
            qryRefundPBo.setCreateTimeEnd(new DateTime((Object)reqBo.getTodayDate()).withMillisOfDay(0).toDate());
        } else {
            Date yesDay = new DateTime().minusDays(1).withMillisOfDay(0).toDate();
            qryPorderPayTranasPo.setCreateTime(yesDay);
            qryPorderPayTranasPo.setCreateTimeEnd(new DateTime().withMillisOfDay(0).toDate());
            qryRefundPBo.setCreateTime(yesDay);
            qryRefundPBo.setCreateTimeEnd(yesDay);
        }
        List<Long> payTransAtomList = this.porderPayTransAtomService.queryOrderIdOfMerchantIdSetByCondition(qryPorderPayTranasPo, merchantIdSet);
        List<Long> porderRefundTransAtomList = this.porderRefundTransAtomService.queryOrderRefundTransOfMerchantIdSetByCondition(qryRefundPBo, merchantIdSet);
        if (CollectionUtils.isEmpty(payTransAtomList) && CollectionUtils.isEmpty(porderRefundTransAtomList)) {
            LOGGER.info("\u672a\u67e5\u8be2\u5230\u652f\u4ed8\u673a\u6784\u4e0b\u7684\u8ba2\u5355\uff1a\u5165\u53c2" + JSON.toJSONString((Object)qryPorderPayTranasPo));
            rspBo.setIncomeNumber("0");
            rspBo.setNetIncomeFee("0");
            rspBo.setRefundNumber("0");
            rspBo.setTotalIncomeFee("0");
            rspBo.setTotalRefundFee("0");
            return rspBo;
        }
        this.generateRspBo(payTransAtomList, porderRefundTransAtomList, rspBo);
        return rspBo;
    }

    private void generateRspBo(List<Long> payTransAtomList, List<Long> porderRefundTransAtomList, QueryYesterdayIncomeWebRspBo rspBo) {
        try {
            Long totalIncomeFeeLong = new Long(0L);
            int incomeNumberI = 0;
            if (!CollectionUtils.isEmpty(payTransAtomList)) {
                for (Long tmPayTrans : payTransAtomList) {
                    PorderPayTransAtomRspBo payTransRsp = this.porderPayTransAtomService.queryLastRecordByOrderId(tmPayTrans);
                    if (!payTransRsp.getOrderStatus().equals("A10") || payTransRsp.getPayFee() == null) continue;
                    Long tmpBD = payTransRsp.getPayFee();
                    totalIncomeFeeLong = totalIncomeFeeLong + tmpBD;
                    ++incomeNumberI;
                }
                BigDecimal totalIncomeBD = MoneyUtils.haoToFen((Long)totalIncomeFeeLong);
                rspBo.setTotalIncomeFee(totalIncomeBD.toPlainString());
                rspBo.setIncomeNumber(incomeNumberI + "");
            } else {
                rspBo.setTotalIncomeFee("0");
                rspBo.setIncomeNumber("0");
            }
            Long totalRefundFeeLong = new Long(0L);
            int refundNumberI = 0;
            if (!CollectionUtils.isEmpty(porderRefundTransAtomList)) {
                for (Long tmPayTrans : porderRefundTransAtomList) {
                    PorderRefundTransPo refundTransRsp = this.porderRefundTransAtomService.queryLastRecordByOrderId(tmPayTrans);
                    if (!refundTransRsp.getOrderStatus().equals("B10") || refundTransRsp.getPayFee() == null) continue;
                    Long tmpBD = new Long(refundTransRsp.getPayFee());
                    totalRefundFeeLong = totalRefundFeeLong + tmpBD;
                    ++refundNumberI;
                }
                BigDecimal totalRefundFeeBD = MoneyUtils.haoToFen((Long)totalRefundFeeLong);
                rspBo.setTotalRefundFee(totalRefundFeeBD.toPlainString());
                rspBo.setRefundNumber(refundNumberI + "");
            } else {
                rspBo.setTotalRefundFee("0");
                rspBo.setRefundNumber("0");
            }
            Long netIncomeFeeLong = totalIncomeFeeLong - totalRefundFeeLong;
            BigDecimal netIncomeFeeBD = MoneyUtils.haoToFen((Long)netIncomeFeeLong);
            rspBo.setNetIncomeFee(netIncomeFeeBD.toPlainString());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private void validateArg(QueryYesterdayIncomeWebReqBo reqBo) {
        if (reqBo == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBo.getOperId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u3010operId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

