/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.util;

import cn.hutool.core.io.IoUtil;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.tydic.payment.pay.util.PayFtpException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class PayFtpUtil {
    public static ChannelSftp openSftpChannel(String host, int port, String userName, String password) {
        try {
            JSch jsch = new JSch();
            Session session = jsch.getSession(userName, host, port);
            session.setPassword(password);
            session.setConfig("StrictHostKeyChecking", "no");
            session.connect();
            return (ChannelSftp)session.openChannel("ftp");
        }
        catch (JSchException e) {
            throw new PayFtpException("\u83b7\u53d6ftp\u8fde\u63a5\u5f02\u5e38", e);
        }
    }

    public static ChannelSftp openSftpWithRsa(String host, int port, String userName, String priRsaPath, String passphrase) {
        try {
            JSch jsch = new JSch();
            jsch.addIdentity(priRsaPath, passphrase);
            Session session = jsch.getSession(userName, host, port);
            session.setConfig("StrictHostKeyChecking", "no");
            session.connect();
            return (ChannelSftp)session.openChannel("sftp");
        }
        catch (JSchException e) {
            throw new PayFtpException("\u83b7\u53d6sftp\u8fde\u63a5\u5f02\u5e38", e);
        }
    }

    public static void downloadToStream(ChannelSftp ftpClient, String targetFile, OutputStream outputStream) {
        try {
            String tarPath = targetFile.substring(0, targetFile.lastIndexOf("/"));
            String tarFileName = targetFile.substring(targetFile.lastIndexOf("/") + 1);
            ftpClient.connect();
            ftpClient.cd(tarPath);
            ftpClient.get(tarFileName, outputStream);
        }
        catch (JSchException e) {
            throw new PayFtpException("\u8fde\u63a5sftp\u670d\u52a1\u5668\u5f02\u5e38", e);
        }
        catch (SftpException e) {
            throw new PayFtpException("sftp\u670d\u52a1\u5668\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38", e);
        }
        finally {
            ftpClient.disconnect();
            try {
                ftpClient.getSession().disconnect();
            }
            catch (JSchException e) {
                throw new PayFtpException("\u5173\u95edsftp(session)\u8fde\u63a5\u5f02\u5e38", e);
            }
        }
    }

    public static void chmod(ChannelSftp ftpClient, String path, String permissions) {
        try {
            ftpClient.connect();
            ftpClient.chmod(Integer.parseInt(permissions, 8), path);
        }
        catch (JSchException e) {
            throw new PayFtpException("\u8fde\u63a5sftp\u670d\u52a1\u5668\u5f02\u5e38", e);
        }
        catch (SftpException e) {
            throw new PayFtpException("\u4fee\u6539\u6743\u9650\u5f02\u5e38", e);
        }
        finally {
            ftpClient.disconnect();
            try {
                ftpClient.getSession().disconnect();
            }
            catch (JSchException e) {
                throw new PayFtpException("\u5173\u95edsftp(session)\u8fde\u63a5\u5f02\u5e38", e);
            }
        }
    }

    public static List<String> downloadAsStringList(ChannelSftp ftpClient, String targetFile) {
        try {
            LinkedList<String> list = new LinkedList<String>();
            String tarPath = targetFile.substring(0, targetFile.lastIndexOf("/"));
            String tarFileName = targetFile.substring(targetFile.lastIndexOf("/") + 1);
            ftpClient.connect();
            ftpClient.cd(tarPath);
            InputStream inputStream = ftpClient.get(tarFileName);
            IoUtil.readUtf8Lines((InputStream)inputStream, list);
            LinkedList<String> linkedList = list;
            return linkedList;
        }
        catch (JSchException e) {
            throw new PayFtpException("\u8fde\u63a5sftp\u670d\u52a1\u5668\u5f02\u5e38", e);
        }
        catch (SftpException e) {
            throw new PayFtpException("sftp\u670d\u52a1\u5668\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38", e);
        }
        finally {
            ftpClient.disconnect();
            try {
                ftpClient.getSession().disconnect();
            }
            catch (JSchException e) {
                throw new PayFtpException("\u5173\u95edsftp(session)\u8fde\u63a5\u5f02\u5e38", e);
            }
        }
    }

    public static List<String> lsDir(ChannelSftp ftpClient, String dir) {
        return PayFtpUtil.lsDir(ftpClient, dir, true);
    }

    public static List<String> lsDir(ChannelSftp ftpClient, String dir, boolean filterSelf) {
        LinkedList<String> list = new LinkedList<String>();
        try {
            ftpClient.connect();
            Vector ls = ftpClient.ls(dir);
            for (ChannelSftp.LsEntry entry : ls) {
                if (filterSelf && (".".endsWith(entry.getFilename()) || "..".equals(entry.getFilename()))) continue;
                list.add(entry.getFilename());
            }
        }
        catch (JSchException e) {
            throw new PayFtpException("\u8fde\u63a5sftp\u670d\u52a1\u5668\u5f02\u5e38", e);
        }
        catch (SftpException e) {
            throw new PayFtpException("sftp\u670d\u52a1\u5668\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38", e);
        }
        finally {
            ftpClient.disconnect();
            try {
                ftpClient.getSession().disconnect();
            }
            catch (JSchException e) {
                throw new PayFtpException("\u5173\u95edsftp(session)\u8fde\u63a5\u5f02\u5e38", e);
            }
        }
        return list;
    }
}

