/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.controller.notify;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.comb.PayProProcessNoticeCombService;
import com.tydic.payment.pay.comb.bo.PayProProcessNoticeCombReqBo;
import com.tydic.payment.pay.comb.bo.PayProProcessNoticeCombRspBo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/pay/rest"})
public class PayProNotifyController {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PayProProcessNoticeCombService payProProcessNoticeCombService;

    @RequestMapping(value={"/receiveWopayMobile"})
    @ResponseBody
    public String aliQrPayNotify(HttpServletRequest request, HttpServletResponse resp) {
        this.LOGGER.info("\u6c83\u652f\u4ed8\u79fb\u52a8\u652f\u4ed8\u540e\u53f0\u56de\u8c03\u4e86pro");
        Enumeration parameterNames = request.getParameterNames();
        this.LOGGER.info("----------\u6c83\u652f\u4ed8\u79fb\u52a8\u652f\u4ed8\u540e\u53f0\u56de\u8c03\u5f00\u59cb\u6253\u5370\u5165\u53c2-------------------");
        while (parameterNames.hasMoreElements()) {
            String key = (String)parameterNames.nextElement();
            System.out.println("\u63a5\u53d7\u5230\u503c\uff0c" + key + "=" + request.getParameter(key));
        }
        this.LOGGER.info("----------\u6c83\u652f\u4ed8\u79fb\u52a8\u652f\u4ed8\u540e\u53f0\u56de\u8c03\u7ed3\u675f\u6253\u5370\u5165\u53c2-------------------");
        String callbackData = request.getParameter("param");
        if (StringUtils.isEmpty((Object)callbackData)) {
            this.LOGGER.error("\u5904\u7406\u6c83\u652f\u4ed8\u56de\u8c03\u5931\u8d25\uff1a\u5165\u53c2param\u4e3a\u7a7a\u4e86");
            return "FAILED";
        }
        callbackData = callbackData.replaceAll("\\s", "+");
        PayProProcessNoticeCombReqBo noticeCombBo = new PayProProcessNoticeCombReqBo();
        noticeCombBo.setPayMethod(Long.valueOf(50L));
        noticeCombBo.setReqData(callbackData);
        PayProProcessNoticeCombRspBo payProProcessNoticeCombRspBo = this.payProProcessNoticeCombService.processNotice(noticeCombBo);
        if (!"0000".equals(payProProcessNoticeCombRspBo.getRespCode())) {
            this.LOGGER.error("\u5904\u7406\u6c83\u652f\u4ed8\u56de\u8c03\u5931\u8d25\uff1a" + payProProcessNoticeCombRspBo.getRespDesc());
            return "FAILED";
        }
        this.LOGGER.debug("\u6c83\u652f\u4ed8\u56de\u8c03\u5904\u7406\u6210\u529f\uff0c\u8ba2\u5355id\uff1a" + payProProcessNoticeCombRspBo.getPayOrderId());
        return "SUCCESS";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/dealBestPayNotify"}, method={RequestMethod.POST})
    @ResponseBody
    public void dealBestPayNotify(HttpServletRequest request, HttpServletResponse response) {
        this.LOGGER.info("-----------------------------------\u7ffc\u652f\u4ed8\u56de\u8c03-------------------------------");
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            ServletInputStream inputStream = request.getInputStream();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int length = 0;
            while ((length = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, length);
            }
            outputStream.close();
            inputStream.close();
            String notifyInfo = new String(outputStream.toByteArray(), StandardCharsets.UTF_8);
            notifyInfo = URLDecoder.decode(notifyInfo, "UTF-8");
            this.LOGGER.info("\u7ffc\u652f\u4ed8\u8fd4\u56de\u7684\u4fe1\u606f\uff1a" + notifyInfo);
            PayProProcessNoticeCombReqBo noticeCombBo = new PayProProcessNoticeCombReqBo();
            noticeCombBo.setPayMethod(Long.valueOf(150L));
            noticeCombBo.setReqData(notifyInfo);
            PayProProcessNoticeCombRspBo noticeRetBo = this.payProProcessNoticeCombService.processNotice(noticeCombBo);
            JSONObject resultJson = new JSONObject();
            resultJson.put("statusCode", (Object)"200");
            String isSuccess = "success";
            String errorCode = null;
            String errorMsg = null;
            if (!"0000".equals(noticeRetBo.getRespCode())) {
                this.LOGGER.error("\u7ffc\u652f\u4ed8\u56de\u8c03\u5904\u7406\u5931\u8d25\uff1a" + noticeRetBo.getRespDesc());
                isSuccess = "false";
                errorCode = noticeRetBo.getRespCode();
                errorMsg = noticeRetBo.getRespDesc();
                resultJson.put("statusCode", (Object)"500");
            }
            JSONObject retJson = new JSONObject();
            retJson.put("success", isSuccess);
            retJson.put("errorCode", errorCode);
            retJson.put("errorMsg", errorMsg);
            retJson.put("result", resultJson);
            String backStr = JSONObject.toJSONString((Object)retJson);
            this.LOGGER.info("\u8fd4\u56de\u7ed9\u7ffc\u652f\u4ed8\u7684\u62a5\u6587\u4e3a\uff1a" + backStr);
            out.write(backStr.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            this.LOGGER.error("\u7ffc\u652f\u4ed8\u56de\u8c03\u5904\u7406\u53d1\u751f\u5f02\u5e38\uff1a" + e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    this.LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/receiveAliPayNotify"})
    @ResponseBody
    public void aliPayNotify(HttpServletRequest request, HttpServletResponse response) {
        this.LOGGER.info("-----------------------------\u652f\u4ed8\u5b9d\u7684\u56de\u8c03\u6765\u4e86(>_<)-----------------------------------");
        OutputStream out = null;
        try {
            HashMap<String, String> paramMap = new HashMap<String, String>(16);
            if (null != request) {
                Set paramsKey = request.getParameterMap().keySet();
                for (String key : paramsKey) {
                    String value = request.getParameter(key);
                    paramMap.put(key, value);
                }
            }
            String notifyInfo = JSON.toJSONString(paramMap);
            this.LOGGER.info("\u652f\u4ed8\u5b9d\u56de\u8c03\u53c2\u6570\uff1a" + notifyInfo);
            PayProProcessNoticeCombReqBo noticeCombBo = new PayProProcessNoticeCombReqBo();
            noticeCombBo.setPayMethod(Long.valueOf(29L));
            noticeCombBo.setReqData(notifyInfo);
            PayProProcessNoticeCombRspBo noticeRetBo = this.payProProcessNoticeCombService.processNotice(noticeCombBo);
            out = response.getOutputStream();
            if (!"0000".equals(noticeRetBo.getRespCode())) {
                out.write("fail".getBytes());
            } else {
                out.write("success".getBytes());
            }
            out.flush();
        }
        catch (Exception e) {
            this.LOGGER.error("\u652f\u4ed8\u5b9d\u56de\u8c03\u901a\u77e5\u5904\u7406\u5f02\u5e38\uff01" + e.getMessage(), (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    this.LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @RequestMapping(value={"/receiveChinaPayNotify"})
    @ResponseBody
    public void chinaPayRefundNotify(HttpServletRequest request, HttpServletResponse response) {
        this.LOGGER.info("-----------------------------\u4e2d\u56fd\u94f6\u8054\uff08\u65b0\u4e00\u4ee3\uff09\u7684\u56de\u8c03\u6765\u4e86(>_<)-----------------------------------");
        try {
            HashMap<String, String> paramMap = new HashMap<String, String>(16);
            if (null != request) {
                Set paramsKey = request.getParameterMap().keySet();
                for (String key : paramsKey) {
                    String value = URLDecoder.decode(request.getParameter(key), "utf-8");
                    paramMap.put(key, value);
                }
            }
            String notifyInfo = JSON.toJSONString(paramMap);
            this.LOGGER.info("\u4e2d\u56fd\u94f6\u8054\uff08\u65b0\u4e00\u4ee3\uff09\u56de\u8c03\u53c2\u6570\uff1a" + notifyInfo);
            PayProProcessNoticeCombReqBo noticeCombBo = new PayProProcessNoticeCombReqBo();
            noticeCombBo.setPayMethod(Long.valueOf(170L));
            noticeCombBo.setReqData(notifyInfo);
            if (paramMap.containsKey("TranType") && "0009".equals(paramMap.get("TranType"))) {
                noticeCombBo.setPayMethod(Long.valueOf(171L));
            }
            PayProProcessNoticeCombRspBo noticeRetBo = this.payProProcessNoticeCombService.processNotice(noticeCombBo);
            this.LOGGER.info("\u652f\u4ed8\u4e2d\u5fc3\u5904\u7406\u56de\u8c03\u670d\u52a1\u8fd4\u56de\u7ed3\u679c\u4e3a\uff1a{}", (Object)noticeRetBo.getRespDesc());
            if ("0000".equals(noticeRetBo.getRespCode())) {
                response.setStatus(HttpStatus.OK.value());
            } else {
                response.setStatus(HttpStatus.METHOD_NOT_ALLOWED.value());
            }
        }
        catch (Exception e) {
            this.LOGGER.error("\u4e2d\u56fd\u94f6\u8054\uff08\u65b0\u4e00\u4ee3\uff09\u7684\u56de\u8c03\u5904\u7406\u5f02\u5e38\uff01{}, {}", (Object)e.getMessage(), (Object)e);
            response.setStatus(HttpStatus.METHOD_NOT_ALLOWED.value());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/receiveIcbcNotify"})
    @ResponseBody
    public void IcbcRefundNotify(HttpServletRequest request, HttpServletResponse response) {
        this.LOGGER.info("-----------------------------\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u7684\u56de\u8c03-----------------------------------");
        try (PrintWriter out = null;){
            HashMap<String, String> paramMap = new HashMap<String, String>(16);
            if (null != request) {
                Set paramsKey = request.getParameterMap().keySet();
                for (String key : paramsKey) {
                    paramMap.put(key, request.getParameter(key));
                }
            }
            String notifyInfo = JSON.toJSONString(paramMap);
            this.LOGGER.info("\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u56de\u8c03\u53c2\u6570\uff1a" + notifyInfo);
            PayProProcessNoticeCombReqBo noticeCombBo = new PayProProcessNoticeCombReqBo();
            noticeCombBo.setPayMethod(Long.valueOf(190L));
            noticeCombBo.setReqData(notifyInfo);
            PayProProcessNoticeCombRspBo noticeRetBo = this.payProProcessNoticeCombService.processNotice(noticeCombBo);
            this.LOGGER.info("\u652f\u4ed8\u4e2d\u5fc3\u5904\u7406\u56de\u8c03\u670d\u52a1\u8fd4\u56de\u7ed3\u679c\u4e3a\uff1a{}", (Object)noticeRetBo.getRespDesc());
            String result = null;
            result = "0000".equals(noticeRetBo.getRespCode()) ? noticeRetBo.getResult() : "fail";
            response.setContentType("application/json; charset=utf-8");
            out = response.getWriter();
            out.write(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/dealChinaBankPayNotify"})
    @ResponseBody
    public void chinaBankPayNotify(HttpServletRequest request, HttpServletResponse response) {
        this.LOGGER.info("-----------------------------\u4e2d\u56fd\u94f6\u884c-\u8ba2\u5355\u652f\u4ed8\uff08\u4fdd\u4ed8\u5546\u6237\uff09\u7684\u56de\u8c03---------------------------");
        try (PrintWriter out = null;){
            HashMap<String, String> paramMap = new HashMap<String, String>(16);
            if (null != request) {
                Set paramsKey = request.getParameterMap().keySet();
                for (String key : paramsKey) {
                    String value = URLDecoder.decode(request.getParameter(key), "utf-8");
                    paramMap.put(key, value);
                }
            }
            String notifyInfo = JSON.toJSONString(paramMap);
            this.LOGGER.info("\u4e2d\u884c\u8fd4\u56de\u7684\u4fe1\u606f\uff1a" + notifyInfo);
            PayProProcessNoticeCombReqBo noticeCombBo = new PayProProcessNoticeCombReqBo();
            noticeCombBo.setPayMethod(Long.valueOf(180L));
            noticeCombBo.setReqData(notifyInfo);
            PayProProcessNoticeCombRspBo noticeRetBo = this.payProProcessNoticeCombService.processNotice(noticeCombBo);
            JSONObject resultJson = new JSONObject();
            resultJson.put("statusCode", (Object)"200");
            String isSuccess = "success";
            String errorCode = null;
            String errorMsg = null;
            if (!"0000".equals(noticeRetBo.getRespCode())) {
                this.LOGGER.error("\u4e2d\u884c\u56de\u8c03\u5904\u7406\u5931\u8d25\uff1a" + noticeRetBo.getRespDesc());
                isSuccess = "false";
                errorCode = noticeRetBo.getRespCode();
                errorMsg = noticeRetBo.getRespDesc();
                resultJson.put("statusCode", (Object)"500");
            }
            JSONObject retJson = new JSONObject();
            retJson.put("success", isSuccess);
            retJson.put("errorCode", errorCode);
            retJson.put("errorMsg", errorMsg);
            retJson.put("result", resultJson);
            String backStr = JSONObject.toJSONString((Object)retJson);
            this.LOGGER.info("\u8fd4\u56de\u7ed9\u4e2d\u884c\u7684\u62a5\u6587\u4e3a\uff1a" + backStr);
            out = response.getWriter();
            out.write(backStr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/dealOfflinePayNotify"}, method={RequestMethod.POST})
    @ResponseBody
    public void dealOfflinePayNotify(HttpServletRequest request, HttpServletResponse response) {
        this.LOGGER.info("-----------------------------------\u7ebf\u4e0b\u652f\u4ed8\u56de\u8c03-------------------------------");
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            HashMap<String, String> paramMap = new HashMap<String, String>(16);
            if (null != request) {
                Set paramsKey = request.getParameterMap().keySet();
                for (String key : paramsKey) {
                    String value = request.getParameter(key);
                    paramMap.put(key, value);
                }
            }
            String notifyInfo = JSON.toJSONString(paramMap);
            this.LOGGER.info("\u7ebf\u4e0b\u652f\u4ed8\u8fd4\u56de\u7684\u4fe1\u606f\uff1a" + notifyInfo);
            PayProProcessNoticeCombReqBo noticeCombBo = new PayProProcessNoticeCombReqBo();
            noticeCombBo.setPayMethod(Long.valueOf(30L));
            noticeCombBo.setReqData(notifyInfo);
            PayProProcessNoticeCombRspBo noticeRetBo = this.payProProcessNoticeCombService.processNotice(noticeCombBo);
            JSONObject resultJson = new JSONObject();
            resultJson.put("statusCode", (Object)"200");
            String isSuccess = "SUCCESS";
            if (!"0000".equals(noticeRetBo.getRespCode())) {
                this.LOGGER.error("\u7ebf\u4e0b\u652f\u4ed8\u56de\u8c03\u5904\u7406\u5931\u8d25\uff1a" + noticeRetBo.getRespDesc());
                isSuccess = "FAIL";
            }
            JSONObject retJson = new JSONObject();
            retJson.put("resultCode", isSuccess);
            String backStr = JSONObject.toJSONString((Object)retJson);
            this.LOGGER.info("\u8fd4\u56de\u7ed9\u7ebf\u4e0b\u652f\u4ed8\u7684\u62a5\u6587\u4e3a\uff1a" + backStr);
            out.write(backStr.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            this.LOGGER.error("\u7ebf\u4e0b\u652f\u4ed8\u56de\u8c03\u5904\u7406\u53d1\u751f\u5f02\u5e38\uff1a" + e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    this.LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

