/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.base.extension.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.base.extension.api.DycSscExtractSupplierQueryExtAtomService;
import com.tydic.dyc.atom.base.extension.bo.DycSscExtractSupplierQueryExtAtomBO;
import com.tydic.dyc.atom.base.extension.bo.DycSscExtractSupplierQueryExtAtomReqBO;
import com.tydic.dyc.atom.base.extension.bo.DycSscExtractSupplierQueryExtAtomRspBO;
import com.tydic.dyc.atom.base.extension.utils.HttpUtil;
import com.tydic.dyc.ssc.service.scheme.SscQrySchemeMatListService;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeMatListPageReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeMatListPageRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeMatBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"dyc-service-group/1.0.0/com.tydic.dyc.atom.base.extension.api.DycSscExtractSupplierQueryExtAtomService"})
public class DycSscExtractSupplierQueryExtAtomServiceImpl
implements DycSscExtractSupplierQueryExtAtomService {
    private static final Logger log = LoggerFactory.getLogger(DycSscExtractSupplierQueryExtAtomServiceImpl.class);
    @Autowired
    private SscQrySchemeMatListService sscQrySchemeMatListService;
    @Value(value="${non_recruitment_extract_supplier_url:non_recruitment_extract_supplier_url}")
    private String nonRecruitmentExtractSupplierUrl;

    @Override
    @PostMapping(value={"extractSupplierQuery"})
    public DycSscExtractSupplierQueryExtAtomRspBO extractSupplierQuery(@RequestBody DycSscExtractSupplierQueryExtAtomReqBO reqBO) {
        DycSscExtractSupplierQueryExtAtomRspBO rspBO = new DycSscExtractSupplierQueryExtAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (reqBO.getSchemeId() == null) {
            throw new ZTBusinessException("\u65b9\u6848id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getToken())) {
            throw new ZTBusinessException("\u8ba4\u8bc1token\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getEnableDraft() == null) {
            throw new ZTBusinessException("\u662f\u5426\u67e5\u8be2\u8349\u7a3f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getFirmNum() == null) {
            throw new ZTBusinessException("\u62bd\u53d6\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getFirmNum() <= 0) {
            throw new ZTBusinessException("\u62bd\u53d6\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
        }
        if (reqBO.getDictFlag() == null) {
            throw new ZTBusinessException("\u62bd\u53d6\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SscQrySchemeMatListPageReqBO sscQrySchemeMatListPageReqBO = new SscQrySchemeMatListPageReqBO();
        sscQrySchemeMatListPageReqBO.setPageNo(Integer.valueOf(-1));
        sscQrySchemeMatListPageReqBO.setPageSize(Integer.valueOf(-1));
        sscQrySchemeMatListPageReqBO.setEnableDraft(reqBO.getEnableDraft());
        sscQrySchemeMatListPageReqBO.setSchemeId(reqBO.getSchemeId());
        sscQrySchemeMatListPageReqBO.setPackId(reqBO.getPackId());
        SscQrySchemeMatListPageRspBO sscQrySchemeMatListPageRspBO = this.sscQrySchemeMatListService.qrySchemeMatList(sscQrySchemeMatListPageReqBO);
        if ("0000".equals(sscQrySchemeMatListPageRspBO.getRespCode())) {
            Set catalogCodes;
            if (!CollectionUtils.isEmpty((Collection)sscQrySchemeMatListPageRspBO.getRows()) && !CollectionUtils.isEmpty(catalogCodes = sscQrySchemeMatListPageRspBO.getRows().stream().filter(e -> !StringUtils.isEmpty((Object)e.getCatalogCode())).map(SscSchemeMatBO::getCatalogCode).collect(Collectors.toSet()))) {
                StringBuffer url = new StringBuffer();
                url.append(this.nonRecruitmentExtractSupplierUrl);
                url.append("?firmNum=" + reqBO.getFirmNum());
                url.append("&dictFlag=" + reqBO.getDictFlag());
                url.append("&itemList=" + catalogCodes.stream().collect(Collectors.joining(",")));
                if (!CollectionUtils.isEmpty(reqBO.getExitCompanyIdList())) {
                    url.append("&exitCompanyIdList=" + reqBO.getExitCompanyIdList().stream().collect(Collectors.joining(",")));
                }
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("TOKEN", (Object)reqBO.getToken());
                try {
                    log.info("\u62bd\u53d6\u4f9b\u5e94\u5546\u67e5\u8be2\u6700\u540e\u62fc\u63a5\u7684\u67e5\u8be2url\uff1a" + url.toString());
                    String rspStr = HttpUtil.doGet(url.toString(), "", jsonObject.toJSONString());
                    log.info("\u62bd\u53d6\u4f9b\u5e94\u5546\u67e5\u8be2\u7684\u8fd4\u56de\u62a5\u6587\uff1a" + rspStr);
                    rspBO = this.resolveRsp(rspStr);
                }
                catch (Exception e2) {
                    log.error(e2.getMessage());
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u8c03\u7528\u67e5\u8be2\u62bd\u53d6\u4f9b\u5e94\u5546\u63a5\u53e3\u5f02\u5e38" + e2.getMessage());
                }
            }
        } else {
            throw new ZTBusinessException("\u67e5\u8be2\u91c7\u8d2d\u65b9\u6848\u5931\u8d25" + sscQrySchemeMatListPageRspBO.getRespDesc());
        }
        return rspBO;
    }

    private DycSscExtractSupplierQueryExtAtomRspBO resolveRsp(String rspStr) {
        JSONObject jsonObject;
        DycSscExtractSupplierQueryExtAtomRspBO rspBO = new DycSscExtractSupplierQueryExtAtomRspBO();
        try {
            jsonObject = JSONObject.parseObject((String)rspStr);
        }
        catch (Exception e) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528\u67e5\u8be2\u62bd\u53d6\u4f9b\u5e94\u5546\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a");
            return rspBO;
        }
        if (jsonObject.get((Object)"success") == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528\u67e5\u8be2\u62bd\u53d6\u4f9b\u5e94\u5546\u63a5\u53e3\u8fd4\u56de\u72b6\u6001\u62a5\u6587\u4e3a\u7a7a");
            return rspBO;
        }
        if ("true".equals(jsonObject.getString("success"))) {
            JSONArray data = jsonObject.getJSONArray("data");
            if (data != null && data.size() > 0) {
                ArrayList<DycSscExtractSupplierQueryExtAtomBO> rows = new ArrayList<DycSscExtractSupplierQueryExtAtomBO>();
                for (int i = 0; i < data.size(); ++i) {
                    JSONObject firmBaseTypeDict;
                    JSONObject firmTypeDict;
                    JSONObject infoObject = data.getJSONObject(i);
                    DycSscExtractSupplierQueryExtAtomBO bo = (DycSscExtractSupplierQueryExtAtomBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)infoObject), DycSscExtractSupplierQueryExtAtomBO.class);
                    JSONObject firmAdmittanceTypeDict = infoObject.getJSONObject("firmAdmittanceTypeDict");
                    if (firmAdmittanceTypeDict != null) {
                        bo.setFirmAdmittanceTypeStr(firmAdmittanceTypeDict.getString("dictName"));
                    }
                    if ((firmTypeDict = infoObject.getJSONObject("firmTypeDict")) != null) {
                        bo.setFirmTypeStr(firmTypeDict.getString("dictName"));
                    }
                    if ((firmBaseTypeDict = infoObject.getJSONObject("firmBaseTypeDict")) != null) {
                        bo.setFirmBaseTypeStr(firmBaseTypeDict.getString("dictName"));
                    }
                    bo.setSatisfaction(infoObject.getString("firmCertLevel"));
                    rows.add(bo);
                }
                rspBO.setRows(rows);
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        rspBO.setRespCode("8888");
        rspBO.setRespDesc(jsonObject.getString("message"));
        return rspBO;
    }
}

