/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.base.extension.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.base.extension.api.DycSscQryOperationListExtAtomService;
import com.tydic.dyc.atom.base.extension.bo.DycSscQryOperationListExtAtomReqBO;
import com.tydic.dyc.atom.base.extension.bo.DycSscQryOperationListExtAtomRspBO;
import com.tydic.dyc.atom.base.extension.bo.DycUmcMemOperationExtBO;
import com.tydic.dyc.atom.base.extension.bo.OperationListAtomBO;
import com.tydic.dyc.atom.base.extension.bo.ValueSource;
import com.tydic.dyc.atom.base.extension.utils.HttpUtil;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"dyc-service-group/1.0.0/com.tydic.dyc.atom.base.extension.api.DycSscQryOperationListExtAtomService"})
public class DycSscQryOperationListExtAtomServiceImpl
implements DycSscQryOperationListExtAtomService {
    private static final Logger log = LoggerFactory.getLogger(DycSscQryOperationListExtAtomServiceImpl.class);
    @Value(value="${operation.url}")
    private String operationUrl;

    @Override
    @PostMapping(value={"qryOperationList"})
    public DycSscQryOperationListExtAtomRspBO qryOperationList(@RequestBody DycSscQryOperationListExtAtomReqBO reqBO) {
        if (StringUtils.isEmpty((CharSequence)reqBO.getTaskId())) {
            throw new ZTBusinessException("\u5165\u53c2taskId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String taskId = reqBO.getTaskId();
        String operationResponseStr = "";
        try {
            operationResponseStr = HttpUtil.doGet(this.operationUrl + "?taskId=" + taskId + "&userId=1");
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u975e\u62db\u67e5\u8be2\u5ba1\u6279\u4fe1\u606f\u63a5\u53e3\u8c03\u7528\u5931\u8d25[" + this.operationUrl + "]");
        }
        log.info("\u67e5\u8be2\u5ba1\u6279\u4fe1\u606f\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)operationResponseStr));
        LinkedList operationBOList = new LinkedList();
        JSONObject result = JSONObject.parseObject((String)operationResponseStr);
        if ("true".equals(result.getString("success"))) {
            JSONArray data = result.getJSONArray("data");
            if ("1".equals(reqBO.getIsHis())) {
                JSONObject object = data.getJSONObject(0);
                JSONArray operations = object.getJSONArray("operations");
                this.resolveRsp("0", operations);
            } else {
                for (int i = data.size(); i > 0; --i) {
                    JSONObject object = data.getJSONObject(0);
                    JSONArray operations = object.getJSONArray("operations");
                    this.resolveRsp(i + "", operations);
                }
            }
        }
        return null;
    }

    private DycSscQryOperationListExtAtomRspBO resolveRsp(String orderBy, JSONArray data) {
        DycSscQryOperationListExtAtomRspBO rspBO = new DycSscQryOperationListExtAtomRspBO();
        if (data != null && data.size() > 0) {
            HashMap<String, List<OperationListAtomBO>> map = new HashMap<String, List<OperationListAtomBO>>();
            ArrayList<OperationListAtomBO> rows = new ArrayList<OperationListAtomBO>();
            for (int i = 0; i < data.size(); ++i) {
                JSONObject infoObject = data.getJSONObject(i);
                OperationListAtomBO fzbo = new OperationListAtomBO();
                fzbo.setOrderBy(i + "");
                String jsonStr = this.toParseObject(data.getJSONObject(i), DycUmcMemOperationExtBO.class);
                DycUmcMemOperationExtBO dycUmcMemOperationBO = (DycUmcMemOperationExtBO)JSONObject.parseObject((String)jsonStr, DycUmcMemOperationExtBO.class);
                fzbo.setActionStr(dycUmcMemOperationBO.getStepName());
                fzbo.setOrgName(dycUmcMemOperationBO.getUserName());
                fzbo.setOrgName(dycUmcMemOperationBO.getDeptName());
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                fzbo.setCreateTime(sdf.format(dycUmcMemOperationBO.getOperationTime()));
                fzbo.setResult(dycUmcMemOperationBO.getOperation());
                String operationCode = dycUmcMemOperationBO.getOperationCode();
                if (StringUtils.isNotBlank((CharSequence)operationCode)) {
                    if ("create".equals(operationCode)) {
                        fzbo.setTacheName("\u521b\u5efa\u6d41\u7a0b");
                    } else if ("pass".equals(operationCode)) {
                        fzbo.setTacheName("\u901a\u8fc7");
                    } else if ("reject".equals(operationCode)) {
                        fzbo.setTacheName("\u62d2\u7edd");
                    }
                }
                rows.add(fzbo);
            }
            map.put(orderBy, rows);
            rspBO.setMap(map);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public String toParseObject(JSONObject jsonObject, Class<?> clazz) {
        Field[] fieldList;
        JSONObject resultJson = new JSONObject();
        for (Field field : fieldList = clazz.getDeclaredFields()) {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            String valueSource = "";
            Object fieldValue = "";
            if (!ObjectUtils.isEmpty((Object)field.getAnnotation(ValueSource.class))) {
                valueSource = field.getAnnotation(ValueSource.class).source();
            }
            try {
                if (!StringUtils.isEmpty((CharSequence)valueSource)) {
                    JSONObject object = new JSONObject((Map)jsonObject);
                    if (valueSource.contains(".")) {
                        String[] list;
                        for (String key : list = valueSource.split("\\.")) {
                            object = object.getJSONObject(key);
                        }
                    } else {
                        object = object.getJSONObject(valueSource);
                    }
                    fieldValue = this.resolveFieldValue(field, object);
                } else {
                    fieldValue = this.resolveFieldValue(field, jsonObject);
                }
            }
            catch (Exception e) {
                log.error("\u5b57\u6bb5[" + field.getName() + "]\u83b7\u53d6\u503c\u5931\u8d25\uff01");
            }
            resultJson.put(field.getName(), fieldValue);
        }
        return JSONObject.toJSONString((Object)resultJson);
    }

    public Object resolveFieldValue(Field field, JSONObject jsonObject) {
        String fieldType = field.getType().getName();
        String fieldName = field.getName();
        if (!ObjectUtils.isEmpty((Object)field.getAnnotation(ValueSource.class)) && !StringUtils.isEmpty((CharSequence)field.getAnnotation(ValueSource.class).name())) {
            fieldName = field.getAnnotation(ValueSource.class).name();
        }
        if ("java.lang.String".equals(fieldType)) {
            return jsonObject.getString(fieldName);
        }
        if ("java.util.Date".equals(fieldType)) {
            if (StringUtils.isNotEmpty((CharSequence)jsonObject.getString(fieldName))) {
                return jsonObject.getDate(fieldName);
            }
            return null;
        }
        if ("java.lang.Integer".equals(fieldType)) {
            if (StringUtils.isNotEmpty((CharSequence)jsonObject.getString(fieldName))) {
                return jsonObject.getInteger(fieldName);
            }
            return null;
        }
        if ("java.math.BigDecimal".equals(fieldType)) {
            if (StringUtils.isNotEmpty((CharSequence)jsonObject.getString(fieldName))) {
                return jsonObject.getBigDecimal(fieldName);
            }
            return new BigDecimal(-1);
        }
        if ("java.util.Date".equals(fieldType)) {
            if (StringUtils.isNotEmpty((CharSequence)jsonObject.getString(fieldName))) {
                return jsonObject.getDate(fieldName);
            }
            return null;
        }
        if ("java.util.List".equals(fieldType)) {
            if (StringUtils.isNotEmpty((CharSequence)jsonObject.getString(fieldName))) {
                return jsonObject.getJSONArray(fieldName);
            }
            return null;
        }
        return jsonObject.getString(fieldName);
    }
}

