/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.purchase.ssc.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.atom.common.api.DycGeneralQueryFunction;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncRspBO;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.purchase.ssc.api.DycSscExportQrySchemeListExtService;
import com.tydic.dyc.purchase.ssc.api.bo.DycSscExportQrySchemeListExtRspBO;
import com.tydic.dyc.purchase.ssc.api.bo.DycSscQrySchemeListExtBO;
import com.tydic.dyc.purchase.ssc.api.bo.DycSscQrySchemeListExtReqBO;
import com.tydic.dyc.purchase.ssc.api.bo.DycSscQrySchemeListExtRspBO;
import com.tydic.dyc.purchase.ssc.api.bo.EsaySchemeAndMatBO;
import com.tydic.dyc.ssc.service.common.SscExtInfoQryService;
import com.tydic.dyc.ssc.service.common.bo.SscExtInfoBo;
import com.tydic.dyc.ssc.service.common.bo.SscExtInfoQryReqBO;
import com.tydic.dyc.ssc.service.common.bo.SscExtInfoQryRspBO;
import com.tydic.dyc.ssc.service.common.bo.SscExtObjInfoBo;
import com.tydic.dyc.ssc.service.scheme.SscQrySchemeMainInfoListExtService;
import com.tydic.dyc.ssc.service.scheme.bo.ExportEsaySchemeAndMatBO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.purchase.ssc.api.DycSscExportQrySchemeListExtService"})
public class DycSscQryExportSchemeListExtServiceImpl
implements DycSscExportQrySchemeListExtService {
    private static final Logger log = LoggerFactory.getLogger(DycSscQryExportSchemeListExtServiceImpl.class);
    private static final String qryCode = "ssc_scheme";
    private static final String TOTAL = "\u5168\u90e8";
    @Autowired
    private DycGeneralQueryFunction dycGeneralQueryFunction;
    @Autowired
    private SscQrySchemeMainInfoListExtService sscQrySchemeMainInfoListExtService;
    @Autowired
    private SscExtInfoQryService sscExtInfoQryService;

    @Override
    @PostMapping(value={"qryExportSchemeList"})
    public DycSscExportQrySchemeListExtRspBO qryExportSchemeList(@RequestBody DycSscQrySchemeListExtReqBO reqBO) {
        DycSscQrySchemeListExtRspBO rspBO;
        String format;
        DycSscExportQrySchemeListExtRspBO rsp = new DycSscExportQrySchemeListExtRspBO();
        reqBO.setCode(qryCode);
        reqBO.setCreateLoginId(reqBO.getUserId());
        reqBO.setAuditDealResultQryKeys(null);
        reqBO.setAuthList(new ArrayList<String>());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat simpleDateFormat1 = new SimpleDateFormat("yyyy-MM-dd");
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getMonthWith())) {
            String[] month = reqBO.getMonthWith().split("-");
            try {
                reqBO.setFinishEndTime(simpleDateFormat.parse(this.getLastDayOfMonth(Integer.valueOf(month[0]), Integer.valueOf(month[1])) + " 23:59:59"));
                reqBO.setFinishStartTime(simpleDateFormat.parse(reqBO.getMonthWith() + "-01 00:00:00"));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (reqBO.getCreateEndTime() != null) {
            format = simpleDateFormat1.format(reqBO.getCreateEndTime());
            try {
                reqBO.setCreateEndTime(simpleDateFormat.parse(format + " 23:59:59"));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (reqBO.getCreateStartTime() != null) {
            format = simpleDateFormat1.format(reqBO.getCreateStartTime());
            try {
                reqBO.setCreateStartTime(simpleDateFormat.parse(format + " 00:00:00"));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (reqBO.getFinishStartTime() != null) {
            format = simpleDateFormat1.format(reqBO.getFinishStartTime());
            try {
                reqBO.setFinishStartTime(simpleDateFormat.parse(format + " 00:00:00"));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (reqBO.getFinishEndTime() != null) {
            format = simpleDateFormat1.format(reqBO.getFinishEndTime());
            try {
                reqBO.setFinishEndTime(simpleDateFormat.parse(format + " 23:59:59"));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if ((rspBO = this.qryEsData(reqBO)) != null && !CollectionUtils.isEmpty(rspBO.getRows())) {
            List<DycSscQrySchemeListExtBO> rows = rspBO.getRows();
            List<ExportEsaySchemeAndMatBO> exportEsaySchemeAndMatBOS = this.setChang(rows);
            rsp.setRows(JUtil.jsl(exportEsaySchemeAndMatBOS, EsaySchemeAndMatBO.class));
            rsp.setPageNo(reqBO.getPageNo());
            rsp.setRecordsTotal(exportEsaySchemeAndMatBOS.size());
            int size = exportEsaySchemeAndMatBOS.size() / reqBO.getPageNo();
            int sizeyu = exportEsaySchemeAndMatBOS.size() % reqBO.getPageNo();
            rsp.setTotal(size);
            if (sizeyu != 0) {
                rsp.setTotal(size + 1);
            }
        } else {
            rsp.setRows(null);
            rsp.setPageNo(1);
            rsp.setRecordsTotal(0);
            rsp.setTotal(0);
        }
        return rsp;
    }

    private String getLastDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month);
        int lastDay = cal.getMinimum(5);
        cal.set(5, lastDay - 1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String lastDayOfMonth = sdf.format(cal.getTime());
        return lastDayOfMonth;
    }

    private List<ExportEsaySchemeAndMatBO> setChang(List<DycSscQrySchemeListExtBO> rows) {
        ArrayList<Long> list = new ArrayList<Long>();
        for (DycSscQrySchemeListExtBO dycSscQrySchemeListExtBO : rows) {
            list.add(dycSscQrySchemeListExtBO.getSchemeId());
        }
        List exportEsaySchemeAndMatBOS = this.sscQrySchemeMainInfoListExtService.selectEsaySchemeAndMat(list);
        SscExtInfoQryReqBO reqBO = new SscExtInfoQryReqBO();
        ArrayList<SscExtObjInfoBo> bos = new ArrayList<SscExtObjInfoBo>();
        for (ExportEsaySchemeAndMatBO bo : exportEsaySchemeAndMatBOS) {
            if (bo.getSchemeMatId() == null) continue;
            SscExtObjInfoBo infoBo = new SscExtObjInfoBo();
            infoBo.setObjId(bo.getSchemeMatId());
            infoBo.setObjType("ssc_scheme_mat_ext");
            infoBo.setOrderId(bo.getSchemeId());
            bos.add(infoBo);
        }
        reqBO.setExtObjInfos(bos);
        SscExtInfoQryRspBO sscExtInfoQryRspBO = this.sscExtInfoQryService.qryExtInfo(reqBO);
        if (sscExtInfoQryRspBO != null && !CollectionUtils.isEmpty((Collection)sscExtInfoQryRspBO.getExtObjInfos())) {
            List extObjInfos = sscExtInfoQryRspBO.getExtObjInfos();
            for (ExportEsaySchemeAndMatBO bo : exportEsaySchemeAndMatBOS) {
                for (SscExtObjInfoBo sscbo : extObjInfos) {
                    if (!bo.getSchemeId().equals(sscbo.getOrderId())) continue;
                    List extInfo = sscbo.getExtInfo();
                    for (SscExtInfoBo infobo : extInfo) {
                        if ("excuteStandard".equals(infobo.getFieldCode())) {
                            bo.setExcuteStandard(infobo.getFieldValue());
                        }
                        if ("qualityRequire".equals(infobo.getFieldCode())) {
                            bo.setQualityRequire(infobo.getFieldValue());
                        }
                        if (!"collecControl".equals(infobo.getFieldCode())) continue;
                        bo.setCollecControl(infobo.getFieldValue());
                    }
                }
            }
        }
        return exportEsaySchemeAndMatBOS;
    }

    private DycSscQrySchemeListExtRspBO qryEsData(DycSscQrySchemeListExtReqBO reqBO) {
        JSONObject reqBoJsonObj = JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)));
        DycGeneralQueryFuncReqBO dycGeneralQueryFuncReqBO = new DycGeneralQueryFuncReqBO();
        dycGeneralQueryFuncReqBO.setQueryCountFlag(Boolean.valueOf(false));
        dycGeneralQueryFuncReqBO.setReqParams(reqBoJsonObj.toJSONString());
        DycGeneralQueryFuncRspBO dycGeneralQueryFuncRspBO = this.dycGeneralQueryFunction.generalQuery(dycGeneralQueryFuncReqBO);
        log.info("\u91c7\u8d2d\u65b9\u6848\u67e5\u8be2es\u6570\u636e: {}", (Object)dycGeneralQueryFuncRspBO.getRspJsonStr());
        DycSscQrySchemeListExtRspBO rspBO = (DycSscQrySchemeListExtRspBO)((Object)JSONObject.parseObject((String)dycGeneralQueryFuncRspBO.getRspJsonStr(), DycSscQrySchemeListExtRspBO.class));
        log.info("\u91c7\u8d2d\u65b9\u6848es\u6570\u636e\u7ed3\u679c\u8f6c\u6362: {}", (Object)JSON.toJSONString((Object)((Object)rspBO)));
        return rspBO;
    }
}

