/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.purchase.ssc.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.purchase.ssc.api.DycSscQryOrderByContractListExtService;
import com.tydic.dyc.purchase.ssc.api.bo.DycSscPurchaseSourcingExtReqBO;
import com.tydic.dyc.purchase.ssc.api.bo.DycSscPurchaseSourcingExtRspBO;
import com.tydic.dyc.purchase.ssc.api.bo.ProcurementSourcingBO;
import com.tydic.uoc.common.ability.api.PebQryOrderByContractAbilityService;
import com.tydic.uoc.common.ability.bo.PebQryOrderByContractReqBO;
import com.tydic.uoc.common.ability.bo.PebQryOrderByContractRspBO;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.purchase.ssc.api.DycSscQryOrderByContractListExtService"})
public class DycSscQryOrderByContractListExtServiceImpl
implements DycSscQryOrderByContractListExtService {
    private static final Logger log = LoggerFactory.getLogger(DycSscQryOrderByContractListExtServiceImpl.class);
    @Autowired
    private PebQryOrderByContractAbilityService pebQryOrderByContractAbilityService;
    public static final String ORDER = "\u8ba2\u5355";

    @Override
    @PostMapping(value={"qryOrderByContractList"})
    public DycSscPurchaseSourcingExtRspBO qryOrderByContractList(@RequestBody DycSscPurchaseSourcingExtReqBO reqBO) {
        this.check(reqBO);
        PebQryOrderByContractReqBO contractReqBO = new PebQryOrderByContractReqBO();
        if (StrUtil.isNotEmpty((CharSequence)reqBO.getPlanId())) {
            contractReqBO.setPlanId(Long.valueOf(reqBO.getPlanId()));
        }
        contractReqBO.setPurchaseSchemePacketNo(reqBO.getPackCode());
        contractReqBO.setContractId(reqBO.getContractId());
        contractReqBO.setPlaAgreementCode(reqBO.getContractCode());
        log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u8ba2\u5355\u5217\u8868\u5165\u53c2: {}", (Object)JSON.toJSONString((Object)contractReqBO));
        PebQryOrderByContractRspBO contractRspBO = this.pebQryOrderByContractAbilityService.qryOrderByContract(contractReqBO);
        log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u8ba2\u5355\u5217\u8868\u51fa\u53c2: {}", (Object)JSON.toJSONString((Object)contractRspBO));
        if (!"0000".equals(contractRspBO.getRespCode())) {
            throw new ZTBusinessException(contractRspBO.getRespDesc());
        }
        DycSscPurchaseSourcingExtRspBO rspBO = new DycSscPurchaseSourcingExtRspBO();
        this.convertData(rspBO, contractRspBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void convertData(DycSscPurchaseSourcingExtRspBO rspBO, PebQryOrderByContractRspBO contractRspBO) {
        List orderInfoList = contractRspBO.getOrderInfo();
        if (CollectionUtil.isNotEmpty((Collection)orderInfoList)) {
            List<ProcurementSourcingBO> convertList = orderInfoList.stream().map(e -> {
                ProcurementSourcingBO procurementSourcingBO = new ProcurementSourcingBO();
                procurementSourcingBO.setContent(ORDER);
                procurementSourcingBO.setAuditStatus(e.getAuditStatus());
                procurementSourcingBO.setJumpUrl(e.getUrl() + "&jumpFromLowCode=1");
                procurementSourcingBO.setAuditTime(e.getAuditTime());
                procurementSourcingBO.setCreateTime(e.getCreateTime());
                procurementSourcingBO.setCreateName(e.getPurPlaceOrderName());
                procurementSourcingBO.setCreateOrgName(e.getPurName());
                procurementSourcingBO.setOrderId(Long.valueOf(e.getOrderId()));
                procurementSourcingBO.setOrderCode(e.getSaleVoucherNo());
                procurementSourcingBO.setOrderNo(e.getSaleVoucherNo());
                procurementSourcingBO.setOrderName(e.getOrderName());
                procurementSourcingBO.setContractCode(e.getPlaAgreementCode());
                procurementSourcingBO.setContractId(e.getAgreementId());
                procurementSourcingBO.setObjId(Long.valueOf(e.getOrderId()));
                procurementSourcingBO.setObjType(4);
                procurementSourcingBO.setContractType(e.getContractType());
                return procurementSourcingBO;
            }).collect(Collectors.toList());
            rspBO.setList(convertList);
        }
        rspBO.setTotal(contractRspBO.getTotal());
        rspBO.setPageNo(contractRspBO.getPageNo());
        rspBO.setRecordsTotal(contractRspBO.getRecordsTotal());
    }

    private void check(DycSscPurchaseSourcingExtReqBO reqBO) {
        if (ObjectUtil.isNull((Object)reqBO.getPlanId()) && StrUtil.isEmpty((CharSequence)reqBO.getPackCode()) && ObjectUtil.isNull((Object)reqBO.getContractId())) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[planId] \u548c [packCode] \u548c [contractId] \u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
    }
}

