/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.purchase.ssc.impl;

import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.commodity.common.ability.api.UccMdmCatalogsearchExtAbilityService;
import com.tydic.commodity.common.ability.bo.UccMdmCatalogsearchExtAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccMdmCatalogsearchExtAbilityRspBO;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.purchase.ssc.api.DycSscSchemeMatImportService;
import com.tydic.dyc.purchase.ssc.api.bo.DycSscSchemeMatImportReqBO;
import com.tydic.dyc.purchase.ssc.api.bo.DycSscSchemeMatImportRspBO;
import com.tydic.dyc.purchase.ssc.bo.SaasUccMdmCatalogsearchExtBO;
import com.tydic.dyc.ssc.service.scheme.SscAddSchemeMatBatchService;
import com.tydic.dyc.ssc.service.scheme.SscQrySchemeMatListService;
import com.tydic.dyc.ssc.service.scheme.bo.SscAddSchemeMatBatchReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeMatListPageReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeMatListPageRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeMatBO;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatterBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.purchase.ssc.api.DycSscSchemeMatImportService"})
public class DycSscSchemeMatImportServiceImpl
implements DycSscSchemeMatImportService {
    private static final Logger log = LoggerFactory.getLogger(DycSscSchemeMatImportServiceImpl.class);
    @Autowired
    private SscAddSchemeMatBatchService sscAddSchemeMatBatchService;
    @Autowired
    private SscQrySchemeMatListService sscQrySchemeMatListService;
    @Autowired
    private UccMdmCatalogsearchExtAbilityService uccMdmCatalogsearchAbilityService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @PostMapping(value={"addSchemeMatImport"})
    public DycSscSchemeMatImportRspBO addSchemeMatImport(@RequestBody DycSscSchemeMatImportReqBO reqBO) {
        log.info("^^^^^^^^^addSchemeMatImportaddSchemeMatImport^^^^^^^^^^^{}", JSON.toJSON((Object)((Object)reqBO)));
        DycSscSchemeMatImportRspBO rspBO = new DycSscSchemeMatImportRspBO();
        try {
            URL url = new URL(reqBO.getUrl());
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            InputStream fis = conn.getInputStream();
            HSSFWorkbook workbook = new HSSFWorkbook(fis);
            Sheet sheet = workbook.getSheetAt(0);
            int lastRowNum = sheet.getLastRowNum();
            if (lastRowNum <= 1) {
                throw new ZTBusinessException("\u5bfc\u5165\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a,\u5bfc\u5165\u5931\u8d25");
            }
            log.info("------------------------->lastRowNum:" + lastRowNum);
            ArrayList<SscSchemeMatBO> sscSchemeMat = new ArrayList<SscSchemeMatBO>();
            HashSet<String> matCodes = new HashSet<String>();
            this.getMatCodes(reqBO, matCodes);
            for (int i = 0; i < lastRowNum - 1; ++i) {
                log.info("\u8fdb\u5165\u4e86\u8bfb\u53d6excel");
                SscSchemeMatBO bo = new SscSchemeMatBO();
                Row row = sheet.getRow(i + 2);
                String checkResult = DycSscSchemeMatImportServiceImpl.checkRow(row);
                if (checkResult != null) {
                    throw new ZTBusinessException("\u5bfc\u5165\u6570\u636e\u6821\u9a8c\u5931\u8d25,\u5931\u8d25\u539f\u56e0:" + (String)checkResult);
                }
                log.info("\u5f53\u524d\u884c\u6821\u9a8c\u7ed3\u679c:" + (String)checkResult);
                bo.setPurchaseNum(new BigDecimal(DycSscSchemeMatImportServiceImpl.getCellValue(row.getCell(5))));
                bo.setNoTaxPrice(new BigDecimal(DycSscSchemeMatImportServiceImpl.getCellValue(row.getCell(6))));
                bo.setTaxRate(new BigDecimal(DycSscSchemeMatImportServiceImpl.getCellValue(row.getCell(7))));
                BigDecimal totalNoTaxPrice = bo.getNoTaxPrice().multiply(bo.getPurchaseNum()).setScale(2, 4);
                bo.setTotalNoTaxPrice(totalNoTaxPrice);
                BigDecimal taxRate = bo.getTaxRate().divide(new BigDecimal("100")).setScale(2, 4);
                BigDecimal taxPrice = bo.getNoTaxPrice().multiply(BigDecimal.ONE.add(taxRate)).setScale(2, 4);
                bo.setTaxPrice(taxPrice);
                BigDecimal totalTaxPrice = taxPrice.multiply(bo.getPurchaseNum()).setScale(2, 4);
                bo.setTotalTaxPrice(totalTaxPrice);
                bo.setDeliveryDate(DateUtils.strToDate((String)DycSscSchemeMatImportServiceImpl.getCellValue(row.getCell(8))));
                bo.setReqUnitName(DycSscSchemeMatImportServiceImpl.getCellValue(row.getCell(1)));
                String matCode = DycSscSchemeMatImportServiceImpl.getCellValue(row.getCell(2));
                if (!matCodes.contains(matCode)) {
                    matCodes.add(matCode);
                }
                bo.setMatCode(matCode);
                bo.setMatName(DycSscSchemeMatImportServiceImpl.getCellValue(row.getCell(3)));
                bo.setMeasureUnitName(DycSscSchemeMatImportServiceImpl.getCellValue(row.getCell(4)));
                bo.setMeasureUnitCode(DycSscSchemeMatImportServiceImpl.getCellValue(row.getCell(4)));
                bo.setBrand(DycSscSchemeMatImportServiceImpl.getCellValue(row.getCell(10)));
                bo.setRemark(DycSscSchemeMatImportServiceImpl.getCellValue(row.getCell(12)));
                bo.setPackId(reqBO.getPackId());
                bo.setSchemeId(reqBO.getSchemeId());
                ArrayList<BaseExtendFieldBo> detailExt = new ArrayList<BaseExtendFieldBo>();
                BaseExtendFieldBo excuteStandard = new BaseExtendFieldBo();
                excuteStandard.setFieldCode("excuteStandard");
                excuteStandard.setFieldName("\u6267\u884c\u6807\u51c6");
                excuteStandard.setFieldValue(DycSscSchemeMatImportServiceImpl.getCellValue(row.getCell(9)));
                detailExt.add(excuteStandard);
                BaseExtendFieldBo qualityRequire = new BaseExtendFieldBo();
                qualityRequire.setFieldCode("qualityRequire");
                qualityRequire.setFieldName("\u8d28\u91cf\u6280\u672f\u8981\u6c42");
                qualityRequire.setFieldValue(DycSscSchemeMatImportServiceImpl.getCellValue(row.getCell(11)));
                detailExt.add(qualityRequire);
                bo.setExtFields(detailExt);
                log.info("\u6253\u5370\u8bfb\u53d6\u7684\u6570\u636e:" + JSON.toJSONString((Object)bo));
                sscSchemeMat.add(bo);
            }
            HashSet<String> failQryMatCodes = new HashSet<String>();
            if (!CollectionUtils.isEmpty(sscSchemeMat)) {
                Set qryMatCodes = sscSchemeMat.stream().filter(e -> !StringUtils.isEmpty((Object)e.getMatCode())).map(SscSchemeMatBO::getMatCode).collect(Collectors.toSet());
                ArrayList<String> list = new ArrayList<String>();
                if (!CollectionUtils.isEmpty(qryMatCodes)) {
                    for (String qryMatCode : qryMatCodes) {
                        if (qryMatCode.length() == 12 && qryMatCode.endsWith("000000")) {
                            list.add(qryMatCode.substring(0, 6));
                            continue;
                        }
                        failQryMatCodes.add(qryMatCode);
                    }
                    if (!CollectionUtils.isEmpty(failQryMatCodes)) {
                        throw new ZTBusinessException("\u5f02\u5e38\u7684\u7269\u8d44\u7f16\u7801\u6570\u636e\uff0c\u5e94\u8be5\u4e3a12\u4f4d\u7684\u901a\u7528\u7269\u6599\uff1a" + failQryMatCodes);
                    }
                    UccMdmCatalogsearchExtAbilityReqBO uccMdmCatalogsearchAbilityReqBO = new UccMdmCatalogsearchExtAbilityReqBO();
                    uccMdmCatalogsearchAbilityReqBO.setCatalogCodes(list);
                    uccMdmCatalogsearchAbilityReqBO.setPageNo(1);
                    uccMdmCatalogsearchAbilityReqBO.setPageSize(qryMatCodes.size() + 1);
                    UccMdmCatalogsearchExtAbilityRspBO uccMdmCatalogsearchAbilityRspBO = this.uccMdmCatalogsearchAbilityService.qrymdmCatalogsearch(uccMdmCatalogsearchAbilityReqBO);
                    if (!"0000".equals(uccMdmCatalogsearchAbilityRspBO.getRespCode())) throw new ZTBusinessException("\u67e5\u8be2\u7269\u6599\u6570\u636e\u5931\u8d25" + uccMdmCatalogsearchAbilityRspBO.getRespDesc());
                    if (CollectionUtils.isEmpty((Collection)uccMdmCatalogsearchAbilityRspBO.getRows())) throw new ZTBusinessException("\u67e5\u8be2\u7684\u7269\u6599\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u7269\u6599");
                    List rows = JSONObject.parseArray((String)JSONObject.toJSONString((Object)uccMdmCatalogsearchAbilityRspBO.getRows()), SaasUccMdmCatalogsearchExtBO.class);
                    Map<String, List<SaasUccMdmCatalogsearchExtBO>> catalogCodeMap = rows.stream().collect(Collectors.groupingBy(SaasUccMdmCatalogsearchExtBO::getCatalogCode));
                    for (SscSchemeMatBO sscSchemeMatBO : sscSchemeMat) {
                        if (StringUtils.isEmpty((Object)sscSchemeMatBO.getMatCode())) continue;
                        String catalogCode = sscSchemeMatBO.getMatCode().substring(0, 6);
                        List<SaasUccMdmCatalogsearchExtBO> uccMdmCatalogsearchBOS = catalogCodeMap.get(catalogCode);
                        if (!CollectionUtils.isEmpty(uccMdmCatalogsearchBOS)) {
                            SaasUccMdmCatalogsearchExtBO uccMdmCatalogsearchBO = uccMdmCatalogsearchBOS.get(0);
                            String inImplementCatalog = uccMdmCatalogsearchBO.getInImplementCatalog();
                            String inControlsCatalog = uccMdmCatalogsearchBO.getInControlsCatalog();
                            List extFields = sscSchemeMatBO.getExtFields();
                            BaseExtendFieldBo excuteStandard = new BaseExtendFieldBo();
                            excuteStandard.setFieldCode("collecImpl");
                            excuteStandard.setFieldName("\u96c6\u91c7\u5b9e\u65bd\u76ee\u5f55");
                            String inImplementCatalogStr = "";
                            if (!StringUtils.isEmpty((Object)inImplementCatalog)) {
                                if (inImplementCatalog.equals("Y")) {
                                    inImplementCatalogStr = "\u662f";
                                } else if (inImplementCatalog.equals("N")) {
                                    inImplementCatalogStr = "\u5426";
                                }
                            }
                            excuteStandard.setFieldValue(inImplementCatalogStr);
                            extFields.add(excuteStandard);
                            String collecControlStr = "";
                            BaseExtendFieldBo qualityRequire = new BaseExtendFieldBo();
                            qualityRequire.setFieldCode("collecControl");
                            qualityRequire.setFieldName("\u96c6\u91c7\u7ba1\u63a7\u76ee\u5f55");
                            if (!StringUtils.isEmpty((Object)inControlsCatalog)) {
                                if (inControlsCatalog.equals("Y")) {
                                    collecControlStr = "\u662f";
                                } else if (inControlsCatalog.equals("N")) {
                                    collecControlStr = "\u5426";
                                }
                            }
                            qualityRequire.setFieldValue(collecControlStr);
                            extFields.add(qualityRequire);
                            sscSchemeMatBO.setCatalogCode(uccMdmCatalogsearchBO.getCatalogCode());
                            sscSchemeMatBO.setCatalogName(uccMdmCatalogsearchBO.getCatalogName());
                            continue;
                        }
                        failQryMatCodes.add(sscSchemeMatBO.getMatCode());
                    }
                    if (!CollectionUtils.isEmpty(failQryMatCodes)) {
                        throw new ZTBusinessException("\u67e5\u8be2\u7684\u7269\u6599\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u7269\u6599" + failQryMatCodes);
                    }
                }
            }
            log.info("\u6253\u5370\u6279\u91cf\u63d2\u5165:" + JSON.toJSONString(sscSchemeMat));
            if (!CollectionUtils.isEmpty(sscSchemeMat)) {
                log.info("\u8fdb\u5165\u4e86\u6279\u91cf\u63d2\u5165");
                SscAddSchemeMatBatchReqBO detailBO = (SscAddSchemeMatBatchReqBO)JUtil.js((Object)((Object)reqBO), SscAddSchemeMatBatchReqBO.class);
                detailBO.setSscSchemeMat(sscSchemeMat);
                detailBO.setEnableDraft(Boolean.valueOf(true));
                this.sscAddSchemeMatBatchService.addSchemeMatBatch(detailBO);
            }
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setRespCode("0000");
            return rspBO;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new ZTBusinessException(e2.getMessage());
        }
    }

    private void getMatCodes(DycSscSchemeMatImportReqBO reqBO, Set<String> matCodes) {
        SscQrySchemeMatListPageReqBO mReqBO = new SscQrySchemeMatListPageReqBO();
        mReqBO.setEnableDraft(Boolean.valueOf(true));
        mReqBO.setPageNo(Integer.valueOf(-1));
        mReqBO.setPageSize(Integer.valueOf(-1));
        mReqBO.setSchemeId(reqBO.getSchemeId());
        SscQrySchemeMatListPageRspBO sscQrySchemeMatListPageRspBO = this.sscQrySchemeMatListService.qrySchemeMatList(mReqBO);
        for (SscSchemeMatBO row : sscQrySchemeMatListPageRspBO.getRows()) {
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)row.getMatCode())) continue;
            matCodes.add(row.getMatCode());
        }
    }

    public static void main(String[] args) throws IOException {
        FileInputStream fis = new FileInputStream("D:\\\u7b80\u6613\u91c7\u8d2d\u8ba1\u5212\u91c7\u8d2d\u6e05\u5355\u6a21\u677f0525.xls");
        HSSFWorkbook workbook = new HSSFWorkbook((InputStream)fis);
        Sheet sheet = workbook.getSheetAt(0);
        int lastRowNum = sheet.getLastRowNum();
        log.info("------------------------->lastRowNum:" + lastRowNum);
        ArrayList sscSchemeMat = new ArrayList();
        HashSet matCodes = new HashSet();
        for (int i = 0; i < lastRowNum - 1; ++i) {
            log.info("\u8fdb\u5165\u4e86\u8bfb\u53d6excel");
            SscSchemeMatBO bo = new SscSchemeMatBO();
            Row row = sheet.getRow(i + 2);
            String string = DycSscSchemeMatImportServiceImpl.checkRow(row);
        }
    }

    private static String checkRow(Row row) {
        String checkResult = null;
        String matCode = DycSscSchemeMatImportServiceImpl.getCellValue(row.getCell(2));
        if ("".equals(matCode)) {
            checkResult = "\u7269\u8d44\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a";
        } else if ("".equals(DycSscSchemeMatImportServiceImpl.getCellValue(row.getCell(3)))) {
            checkResult = "\u7269\u8d44\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a";
        } else if ("".equals(DycSscSchemeMatImportServiceImpl.getCellValue(row.getCell(4)))) {
            checkResult = "\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a";
        } else if ("".equals(DycSscSchemeMatImportServiceImpl.getCellValue(row.getCell(5))) || row.getCell(5).getCellType() != CellType.NUMERIC) {
            checkResult = "\u91c7\u8d2d\u6570\u91cf\u4e3a\u7a7a\u6216\u8005\u4e3a\u975e\u6570\u5b57\u7c7b\u578b";
        } else if ("".equals(DycSscSchemeMatImportServiceImpl.getCellValue(row.getCell(6))) || row.getCell(6).getCellType() != CellType.NUMERIC) {
            checkResult = "\u9884\u7b97\u4e0d\u542b\u7a0e\u5355\u4ef7\u4e3a\u7a7a\u6216\u8005\u4e3a\u975e\u6570\u5b57\u7c7b\u578b";
        } else if ("".equals(DycSscSchemeMatImportServiceImpl.getCellValue(row.getCell(7)))) {
            checkResult = "\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a";
        } else if (!DycSscSchemeMatImportServiceImpl.validDateStr(DycSscSchemeMatImportServiceImpl.getCellValue(row.getCell(8)), null)) {
            checkResult = "\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\u6216\u8005\u4e3a\u7a7a";
        }
        return checkResult;
    }

    public static String getCellValue(Cell cell) {
        String cellValue = "";
        if (!StringUtils.isEmpty((Object)cell)) {
            switch (cell.getCellType()) {
                case NUMERIC: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        cellValue = sdf.format(DateUtil.getJavaDate((double)cell.getNumericCellValue())).toString();
                        break;
                    }
                    DataFormatter dataFormatter = new DataFormatter();
                    cellValue = dataFormatter.formatCellValue(cell);
                    break;
                }
                case STRING: {
                    cellValue = cell.getStringCellValue();
                    break;
                }
                case BOOLEAN: {
                    cellValue = cell.getBooleanCellValue() + "";
                    break;
                }
                case FORMULA: {
                    cellValue = cell.getCellFormula() + "";
                    break;
                }
                case BLANK: {
                    cellValue = "";
                    break;
                }
                case ERROR: {
                    cellValue = "\u975e\u6cd5\u5b57\u7b26";
                    break;
                }
                default: {
                    cellValue = "\u672a\u77e5\u7c7b\u578b";
                }
            }
        }
        return cellValue;
    }

    public static boolean validDateStr(String dateStr, String pattern) {
        if (StringUtil.isEmpty((String)pattern)) {
            pattern = "yyyy-MM-dd";
        }
        try {
            LocalDate.parse(dateStr, new DateTimeFormatterBuilder().appendPattern(pattern).parseStrict().toFormatter());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

