/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.purchase.ssc.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.dyc.atom.base.extension.utils.HttpUtil;
import com.tydic.dyc.atom.common.api.DycEacQueryOperationRecordsListFunction;
import com.tydic.dyc.atom.common.bo.DycEacOperationRecordsInfoFuncBO;
import com.tydic.dyc.atom.common.bo.DycEacQueryOperationRecordsListAbilityFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycEacQueryOperationRecordsListAbilityFuncRspBO;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.dyc.purchase.ssc.api.QrySchemeWordExportService;
import com.tydic.dyc.purchase.ssc.api.bo.QrySchemeWordExportReqBO;
import com.tydic.dyc.purchase.ssc.api.bo.QrySchemeWordExportRsqBO;
import com.tydic.dyc.purchase.ssc.bo.SscSchemeInviteSupExtBO;
import com.tydic.dyc.purchase.ssc.bo.SscSchemeMatExtBO;
import com.tydic.dyc.ssc.service.scheme.SscQrySchemeDetailService;
import com.tydic.dyc.ssc.service.scheme.SscQrySchemeInviteSupListService;
import com.tydic.dyc.ssc.service.scheme.SscQrySchemeMatListService;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeDetailBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeDetailReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeDetailRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeInviteSupListPageReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeInviteSupListPageRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeMatListPageReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeMatListPageRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeInviteSupBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeMatBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemePackBO;
import com.tydic.uoc.common.ability.api.PebOrdHistryAbilityService;
import com.tydic.uoc.common.ability.bo.PebOrdHistryReqBO;
import com.tydic.uoc.common.ability.bo.PebOrdHistryRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdHistoryBO;
import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.document.IXDocReport;
import fr.opensagres.xdocreport.document.registry.XDocReportRegistry;
import fr.opensagres.xdocreport.template.IContext;
import fr.opensagres.xdocreport.template.TemplateEngineKind;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.purchase.ssc.api.QrySchemeWordExportService"})
public class QrySchemeWordExportServiceImpl
implements QrySchemeWordExportService {
    private static final Logger log = LoggerFactory.getLogger(QrySchemeWordExportServiceImpl.class);
    @Autowired
    private SscQrySchemeDetailService sscQrySchemeDetailService;
    @Autowired
    private SscQrySchemeMatListService sscQrySchemeMatListService;
    @Autowired
    private SscQrySchemeInviteSupListService sscQrySchemeInviteSupListService;
    @Autowired
    private DycEacQueryOperationRecordsListFunction dycEacQueryOperationRecordsListFunction;
    private static final String PATH = "scheme/word";
    @Autowired
    private FileClient fileClient;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    public static final String FILE_TYPE_OSS = "OSS";
    public static final String FILE_TYPE_FASTDFS = "FASTDFS";
    @Autowired
    private PebOrdHistryAbilityService pebOrdHistryAbilityService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PostMapping(value={"qrySchemeWordExport"})
    public QrySchemeWordExportRsqBO qrySchemeWordExport(@RequestBody QrySchemeWordExportReqBO reqBO) {
        this.check(reqBO);
        QrySchemeWordExportRsqBO qrySchemeWordExportRsqBO = new QrySchemeWordExportRsqBO();
        InputStream in = null;
        FileOutputStream out = null;
        String templateUrl = reqBO.getWordExportUrl();
        try {
            String exportUrl;
            String stampName = "scheme_" + new Date().getTime() + ".docx";
            File file = new File(System.getProperty("user.dir") + "/schemeWordFile/" + stampName);
            File fileParent = file.getParentFile();
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            HttpUtil.httpDownload(templateUrl, file.getAbsolutePath());
            in = new FileInputStream(new File(file.getAbsolutePath()));
            IXDocReport report = XDocReportRegistry.getRegistry().loadReport(in, TemplateEngineKind.Freemarker);
            IContext context = report.createContext();
            SscQrySchemeDetailReqBO dReqBO = new SscQrySchemeDetailReqBO();
            dReqBO.setEnableDraft(Boolean.valueOf(false));
            dReqBO.setSchemeId(reqBO.getSchemeId());
            SscQrySchemeDetailRspBO qrySchemeDetail = this.sscQrySchemeDetailService.qrySchemeDetail(dReqBO);
            log.info("\u901a\u8fc7\u65b9\u6848id\u4e3a\u3010" + reqBO.getSchemeId() + "\u3011\u67e5\u8be2\u65b9\u6848\u4fe1\u606f\u8fd4\u56de\u662f\uff1a" + JSON.toJSONString((Object)qrySchemeDetail));
            if (qrySchemeDetail == null) {
                QrySchemeWordExportRsqBO qrySchemeWordExportRsqBO2 = null;
                return qrySchemeWordExportRsqBO2;
            }
            SscQrySchemeDetailBO sscQrySchemeDetailBO = qrySchemeDetail.getSscQrySchemeDetailBO();
            String name = "\u7b80\u6613\u91c7\u8d2d\u8ba1\u5212\u540d\u79f0";
            String code = "\u7b80\u6613\u91c7\u8d2d\u8ba1\u5212\u7f16\u7801";
            String no = "\u7b80\u6613\u91c7\u8d2d\u8ba1\u5212\u7f16\u53f7";
            if (!"2".equals(sscQrySchemeDetailBO.getSchemeType())) {
                name = "\u91c7\u8d2d\u5305\u540d\u79f0";
                code = "\u91c7\u8d2d\u5305\u7f16\u7801";
                no = "\u91c7\u8d2d\u5305\u7f16\u53f7";
            }
            context.put("name", (Object)name);
            context.put("code", (Object)code);
            context.put("no", (Object)no);
            String contractType = null;
            String subcontractType = null;
            String undertakeSubcontractType = null;
            String innerFlag = null;
            if (!CollectionUtils.isEmpty((Collection)sscQrySchemeDetailBO.getExtFields())) {
                for (BaseExtendFieldBo baseExtendFieldBo : sscQrySchemeDetailBO.getExtFields()) {
                    if ("contractType".equals(baseExtendFieldBo.getFieldCode())) {
                        contractType = baseExtendFieldBo.getFieldValue();
                    }
                    if ("subcontractType".equals(baseExtendFieldBo.getFieldCode())) {
                        subcontractType = baseExtendFieldBo.getFieldValue();
                    }
                    if ("undertakeSubcontractType".equals(baseExtendFieldBo.getFieldCode())) {
                        undertakeSubcontractType = baseExtendFieldBo.getFieldValue();
                    }
                    if (!"innerFlag".equals(baseExtendFieldBo.getFieldCode())) continue;
                    innerFlag = baseExtendFieldBo.getFieldValue();
                }
            }
            String createOrgName = sscQrySchemeDetailBO.getCreateOrgName();
            String schemeName = sscQrySchemeDetailBO.getSchemeName();
            String schemeNo = sscQrySchemeDetailBO.getSchemeNo();
            String schemeCode = sscQrySchemeDetailBO.getSchemeCode();
            String purchaseType = sscQrySchemeDetailBO.getPurchaseTypeStr();
            String estAmount = sscQrySchemeDetailBO.getEstAmount() == null ? BigDecimal.ZERO.toPlainString() : sscQrySchemeDetailBO.getEstAmount().setScale(2, 4).toPlainString();
            String schemeClass = sscQrySchemeDetailBO.getSchemeClassStr();
            String importFlag = sscQrySchemeDetailBO.getImportFlagStr();
            String organizationForm = sscQrySchemeDetailBO.getOrganizationFormStr();
            String emergencyFlag = sscQrySchemeDetailBO.getEmergencyFlagStr();
            String createName = sscQrySchemeDetailBO.getCreateName();
            SscSchemePackBO sscSchemePack = null;
            if (reqBO.getPackId() != null && reqBO.getPackId() != 0L) {
                List sscSchemePacks = sscQrySchemeDetailBO.getSscSchemePack();
                for (SscSchemePackBO sscSchemePackBO : sscSchemePacks) {
                    if (!sscSchemePackBO.getPackId().equals(reqBO.getPackId())) continue;
                    sscSchemePack = sscSchemePackBO;
                    break;
                }
            }
            if (sscSchemePack != null) {
                schemeName = sscSchemePack.getPackName();
                schemeNo = sscSchemePack.getPackNo();
                schemeCode = sscSchemePack.getPackCode();
                estAmount = sscSchemePack.getEstAmount().setScale(2, 4) + "";
            } else if (!"2".equals(sscQrySchemeDetailBO.getSchemeType())) {
                schemeCode = "";
                schemeNo = "";
                schemeName = "";
            }
            context.put("innerFlag", (Object)this.converNull(innerFlag));
            context.put("subcontractType", (Object)this.converNull(subcontractType));
            context.put("undertakeSubcontractType", (Object)this.converNull(undertakeSubcontractType));
            context.put("createOrgName", (Object)this.converNull(createOrgName));
            context.put("schemeName", (Object)this.converNull(schemeName));
            context.put("schemeNo", (Object)this.converNull(schemeNo));
            context.put("schemeCode", (Object)this.converNull(schemeCode));
            context.put("purchaseType", (Object)this.converNull(purchaseType));
            context.put("contractType", (Object)this.converNull(contractType));
            if (estAmount != null) {
                context.put("estAmount", (Object)this.converNull(new BigDecimal(estAmount).setScale(2, 4).toString()));
            } else {
                context.put("estAmount", (Object)this.converNull(estAmount));
            }
            context.put("schemeClass", (Object)this.converNull(schemeClass));
            context.put("importFlag", (Object)this.converNull(importFlag));
            context.put("organizationForm", (Object)this.converNull(organizationForm));
            context.put("emergencyFlag", (Object)this.converNull(emergencyFlag));
            context.put("createName", (Object)this.converNull(createName));
            context.put("remark", (Object)this.converNull(sscQrySchemeDetailBO.getRemark()));
            SscQrySchemeMatListPageReqBO mReqBO = new SscQrySchemeMatListPageReqBO();
            mReqBO.setPageNo(Integer.valueOf(-1));
            mReqBO.setPageSize(Integer.valueOf(-1));
            if (reqBO.getPackId() != null && reqBO.getPackId() != 0L) {
                mReqBO.setPackId(reqBO.getPackId());
            }
            mReqBO.setSchemeId(reqBO.getSchemeId());
            if (sscSchemePack != null) {
                mReqBO.setPackId(reqBO.getPackId());
            }
            mReqBO.setEnableDraft(Boolean.valueOf(false));
            SscQrySchemeMatListPageRspBO qrySchemeMatList = this.sscQrySchemeMatListService.qrySchemeMatList(mReqBO);
            log.info("\u901a\u8fc7\u65b9\u6848id\u4e3a\u3010" + reqBO.getSchemeId() + "\u3011\u67e5\u8be2\u7269\u88c5\u660e\u7ec6\u4fe1\u606f\u8fd4\u56de\u662f\uff1a" + JSON.toJSONString((Object)qrySchemeMatList));
            List mats = null;
            if (qrySchemeMatList != null) {
                mats = qrySchemeMatList.getRows();
            }
            ArrayList<String> maCode = new ArrayList<String>();
            if (!CollectionUtils.isEmpty((Collection)mats)) {
                for (SscSchemeMatBO sscSchemeMatBO : mats) {
                    maCode.add(sscSchemeMatBO.getMatCode());
                }
            }
            ArrayList<SscSchemeMatExtBO> list = new ArrayList<SscSchemeMatExtBO>();
            Map<Object, Object> historyMap = new HashMap();
            if (maCode.size() > 0) {
                PebOrdHistryReqBO histryReqBO = new PebOrdHistryReqBO();
                histryReqBO.setMaterialCodes(maCode);
                histryReqBO.setUsername(sscQrySchemeDetailBO.getCreateUsername());
                histryReqBO.setOrgCodeIn(sscQrySchemeDetailBO.getCreateOrgCode());
                PebOrdHistryRspBO histryRspBO = this.pebOrdHistryAbilityService.qryLastHistory(histryReqBO);
                log.debug("\u67e5\u8be2\u5386\u53f2\u6210\u4ea4\u4ef7\u683c\uff1a" + JSON.toJSONString((Object)histryRspBO));
                if (!CollectionUtils.isEmpty((Collection)histryRspBO.getRows())) {
                    historyMap = histryRspBO.getRows().stream().collect(Collectors.toMap(UocOrdHistoryBO::getMaterialCode, i -> i));
                }
            }
            if (!CollectionUtils.isEmpty((Collection)mats)) {
                SscSchemeMatExtBO bo = null;
                for (int i2 = 0; i2 < mats.size(); ++i2) {
                    SscSchemeMatBO sscSchemeMatBO = (SscSchemeMatBO)mats.get(i2);
                    bo = new SscSchemeMatExtBO();
                    bo.setMatCode(this.converNull(sscSchemeMatBO.getMatCode()));
                    bo.setMatName(this.converNull(sscSchemeMatBO.getMatName()));
                    bo.setMeasureUnitName(this.converNull(sscSchemeMatBO.getMeasureUnitName()));
                    bo.setPurchaseNum(sscSchemeMatBO.getPurchaseNum() != null ? sscSchemeMatBO.getPurchaseNum() : new BigDecimal("0"));
                    bo.setPurchaseNumStr(bo.getPurchaseNum().stripTrailingZeros().toPlainString());
                    bo.setExpectPrice(sscSchemeMatBO.getExpectPrice() != null ? sscSchemeMatBO.getExpectPrice() : new BigDecimal("0"));
                    bo.setExpectMoney(sscSchemeMatBO.getExpectMoney() != null ? sscSchemeMatBO.getExpectMoney() : new BigDecimal("0"));
                    if (!"2".equals(sscQrySchemeDetailBO.getSchemeType())) {
                        bo.setExpectPriceStr(bo.getExpectPrice().stripTrailingZeros().toPlainString());
                        if (sscSchemeMatBO.getExpectPrice() == null && sscSchemeMatBO.getTaxPrice() != null) {
                            bo.setExpectPriceStr(sscSchemeMatBO.getTaxPrice().stripTrailingZeros().toPlainString());
                        }
                        bo.setExpectMoneyStr(bo.getExpectMoney().stripTrailingZeros().toPlainString());
                    } else {
                        if (sscSchemeMatBO.getTaxPrice() != null) {
                            bo.setExpectPriceStr(sscSchemeMatBO.getTaxPrice().stripTrailingZeros().toPlainString());
                        } else {
                            bo.setExpectPriceStr("0");
                        }
                        if (sscSchemeMatBO.getTotalTaxPrice() != null) {
                            bo.setExpectMoneyStr(sscSchemeMatBO.getTotalTaxPrice().stripTrailingZeros().toPlainString());
                        } else {
                            bo.setExpectMoneyStr("0");
                        }
                    }
                    bo.setTaxRate(sscSchemeMatBO.getTaxRate() != null ? sscSchemeMatBO.getTaxRate() : new BigDecimal("0"));
                    bo.setPlanCode(this.converNull(sscSchemeMatBO.getPlanCode()));
                    bo.setDeclareUnitName(this.converNull(sscSchemeMatBO.getDeclareUnitName()));
                    bo.setReqUnitName(this.converNull(sscSchemeMatBO.getReqUnitName()));
                    bo.setQualityRequire("");
                    List extFields = sscSchemeMatBO.getExtFields();
                    if (!CollectionUtils.isEmpty((Collection)extFields)) {
                        for (BaseExtendFieldBo extendFieldBo : extFields) {
                            if (!"qualityRequire".equals(extendFieldBo.getFieldCode())) continue;
                            bo.setQualityRequire(this.converNull(extendFieldBo.getFieldValue()));
                            break;
                        }
                    }
                    bo.setOrderBy(String.valueOf(i2 + 1));
                    if (historyMap.size() > 0 && StringUtils.isNotBlank((String)bo.getMatCode())) {
                        UocOrdHistoryBO historyBO = (UocOrdHistoryBO)historyMap.get(bo.getMatCode());
                        if (historyBO == null) {
                            bo.setLastOrderTime("");
                            bo.setLastOrderPrice("");
                        } else {
                            bo.setLastOrderPrice(historyBO.getSalePrice().toPlainString());
                            if (historyBO.getAuditTime() != null) {
                                bo.setLastOrderTime(DateUtils.dateToStr((Date)historyBO.getAuditTime()));
                            } else {
                                bo.setLastOrderTime(DateUtils.dateToStr((Date)new Date()));
                            }
                        }
                    } else {
                        bo.setLastOrderTime("");
                        bo.setLastOrderPrice("");
                    }
                    list.add(bo);
                }
            }
            context.put("mat", list);
            SscQrySchemeInviteSupListPageReqBO sReqBO = new SscQrySchemeInviteSupListPageReqBO();
            sReqBO.setSchemeId(reqBO.getSchemeId());
            if (reqBO.getPackId() != null && reqBO.getPackId() != 0L) {
                sReqBO.setPackId(reqBO.getPackId());
            }
            sReqBO.setEnableDraft(Boolean.valueOf(false));
            sReqBO.setPageNo(Integer.valueOf(-1));
            sReqBO.setPageSize(Integer.valueOf(-1));
            SscQrySchemeInviteSupListPageRspBO qrySchemeInviteSupList = this.sscQrySchemeInviteSupListService.qrySchemeInviteSupList(sReqBO);
            log.info("\u901a\u8fc7\u65b9\u6848id\u4e3a\u3010" + reqBO.getSchemeId() + "\u3011\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f\u8fd4\u56de\u662f\uff1a" + JSON.toJSONString((Object)qrySchemeInviteSupList));
            List sup = null;
            if (qrySchemeInviteSupList != null) {
                sup = qrySchemeInviteSupList.getRows();
            }
            ArrayList<SscSchemeInviteSupExtBO> list1 = new ArrayList<SscSchemeInviteSupExtBO>();
            if (!CollectionUtils.isEmpty((Collection)mats)) {
                SscSchemeInviteSupExtBO bo = null;
                for (int i3 = 0; i3 < sup.size(); ++i3) {
                    SscSchemeInviteSupBO ssc = (SscSchemeInviteSupBO)sup.get(i3);
                    bo = new SscSchemeInviteSupExtBO();
                    bo.setSupCode(this.converNull(ssc.getSupCode()));
                    bo.setSupName(this.converNull(ssc.getSupName()));
                    bo.setContractName(this.converNull(ssc.getContractName()));
                    bo.setMobile(this.converNull(ssc.getMobile()));
                    bo.setConttactAddress(this.converNull(ssc.getConttactAddress()));
                    bo.setSupType("");
                    List extFields = ssc.getExtFields();
                    if (!CollectionUtils.isEmpty((Collection)extFields)) {
                        Iterator iterator = extFields.iterator();
                        while (iterator.hasNext()) {
                            BaseExtendFieldBo extendFieldBo = (BaseExtendFieldBo)iterator.next();
                            if (!"supType".equals(extendFieldBo.getFieldCode())) continue;
                            bo.setSupType(this.converNull(extendFieldBo.getFieldValue()));
                            break;
                        }
                    }
                    bo.setOrderBy(String.valueOf(i3 + 1));
                    list1.add(bo);
                }
            }
            context.put("sup", list1);
            StringBuffer buffer = new StringBuffer();
            if (StringUtils.isNotBlank((String)reqBO.getProcInstId())) {
                DycEacQueryOperationRecordsListAbilityFuncReqBO dyceorafBO = new DycEacQueryOperationRecordsListAbilityFuncReqBO();
                dyceorafBO.setProcInstId(reqBO.getProcInstId());
                DycEacQueryOperationRecordsListAbilityFuncRspBO funcRspBOs = this.dycEacQueryOperationRecordsListFunction.queryOperationRecordsList(dyceorafBO);
                if (funcRspBOs != null && !CollectionUtils.isEmpty((Collection)funcRspBOs.getRows())) {
                    for (DycEacOperationRecordsInfoFuncBO funcBO : funcRspBOs.getRows()) {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        if (StringUtils.isEmpty((String)funcBO.getActionStr()) || funcBO.getCreateTime() == null) continue;
                        buffer.append(funcBO.getUserName()).append("/").append(funcBO.getActionStr()).append("/").append(funcBO.getCreateTime() == null ? "" : simpleDateFormat.format(funcBO.getCreateTime())).append("\n");
                    }
                }
            }
            context.put("info", (Object)this.converNull(buffer.toString()));
            FieldsMetadata fm = report.createFieldsMetadata();
            fm.load("mat", SscSchemeMatExtBO.class, true);
            fm.load("sup", SscSchemeInviteSupExtBO.class, true);
            String wordName = "scheme_" + System.currentTimeMillis() + ".docx";
            String wordUrl = System.getProperty("user.dir") + "/schemeWordFile/" + wordName;
            out = new FileOutputStream(new File(wordUrl));
            report.process(context, (OutputStream)out);
            FileInputStream fileInput = new FileInputStream(wordUrl);
            in.close();
            out.close();
            HttpUtil.deleteFile("schemeWordFile/" + file.getName());
            HttpUtil.deleteFile("schemeWordFile/" + wordName);
            String fileName = "\u65b9\u6848\u4fe1\u606f\u5bfc\u51fa.docx";
            String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)fileInput);
            if (FILE_TYPE_OSS.equals(this.fileType)) {
                exportUrl = this.ossFileUrl + path;
            } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
                FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
                exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            } else {
                throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
            }
            qrySchemeWordExportRsqBO.setUrl(exportUrl);
            qrySchemeWordExportRsqBO.setFileName(qrySchemeDetail.getSscQrySchemeDetailBO().getSchemeName() + ".docx");
        }
        catch (IOException e) {
            log.error("\u8bfb\u53d6Word\u6a21\u677f\u5f02\u5e38", (Throwable)e);
        }
        catch (XDocReportException e) {
            log.error("word\u6a21\u677f\u751f\u6210\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return qrySchemeWordExportRsqBO;
    }

    private void check(QrySchemeWordExportReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("word\u5bfc\u51fa\u5165\u53c2\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (reqBO.getSchemeId() == null || reqBO.getSchemeId() == 0L) {
            throw new ZTBusinessException("word\u5bfc\u51fa\u5165\u53c2schemeId\u4e0d\u53ef\u4e3a\u7a7a");
        }
    }

    private String converNull(String data) {
        if (data == null) {
            return "";
        }
        return data;
    }
}

