/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.nlp.service.data;

import com.tydic.nlp.util.SentencesUtil;
import com.tydic.se.nlp.intfs.QueryCorpusDataService;
import com.tydic.se.nlp.req.QueryCorpusDataReqBo;
import com.tydic.se.nlp.rsp.QueryCorpusDataRspBo;
import com.tydic.se.nlp.service.constant.CountSqlEnum;
import com.tydic.se.nlp.service.constant.QuerySqlEnum;
import com.tydic.se.nlp.service.utils.TxtFileUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="querySpecService")
public class QuerySpecServiceImpl
implements QueryCorpusDataService {
    private static final Logger log = LoggerFactory.getLogger(QuerySpecServiceImpl.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private final String suffix_txt = ".txt";
    private final String suffix_dic = ".dic";
    private final String fileName = "spec";
    private static final int PAGE_SIZE = 50000;
    List<String> spcNameList = new ArrayList<String>();
    List<String> spcDicList = new ArrayList<String>();

    public QueryCorpusDataRspBo saveDataToTxt(QueryCorpusDataReqBo reqBo) {
        String txtFile = reqBo.getOutPath() + "spec" + ".txt";
        String dicFile = reqBo.getOutPath() + "spec" + ".dic";
        QueryCorpusDataRspBo rspBo = new QueryCorpusDataRspBo();
        int counter = (Integer)this.jdbcTemplate.queryForObject(CountSqlEnum.SPEC.getSql(), Integer.class);
        int totalPage = counter % 50000 == 0 ? counter / 50000 : counter / 50000 + 1;
        log.info("\u67e5\u8be2\u8fd4\u56de\u7684\u603b\u8bb0\u5f55\u6570\u91cf\uff1a" + counter + ",\u8fd4\u56de\u7684\u603b\u5206\u9875\uff1a" + totalPage);
        for (int i = 0; i < totalPage; ++i) {
            this.dealData(i);
        }
        TxtFileUtil.writeContent(this.spcNameList, txtFile, true);
        TxtFileUtil.writeContent(this.spcDicList, dicFile, true);
        log.info("\u5904\u7406\u5b8c\u6210\uff01\uff01\uff01\uff01");
        rspBo.setCode("0");
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }

    private void dealData(int startPage) {
        String querySql = QuerySqlEnum.SPEC.getSql() + startPage * 50000 + "," + 50000;
        log.info("\u5f00\u59cb\u5904\u7406\u9875\u6570" + startPage + ",\u67e5\u8be2\u8bed\u53e5\uff1a" + querySql);
        try {
            SqlRowSet rs = this.jdbcTemplate.queryForRowSet(querySql);
            while (rs.next()) {
                String dealName;
                String name = rs.getString(1);
                if (StringUtils.isEmpty((Object)name) || StringUtils.isEmpty((Object)(dealName = this.dealSpecMatches(name)))) continue;
                this.spcNameList.add(dealName);
                this.spcDicList.addAll(SentencesUtil.toSentenceList((String)dealName));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String dealSpecMatches(String msg) {
        if (msg.matches("[A-Za-z0-9\u00b7\\-]{2,12}")) {
            if (msg.matches("[0-9]{2,12}")) {
                return null;
            }
            return msg;
        }
        return null;
    }
}

