/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.nlp.service.data;

import com.tydic.se.nlp.intfs.TextCategorizationService;
import com.tydic.se.nlp.req.QueryCorpusDataReqBo;
import com.tydic.se.nlp.rsp.QueryCorpusDataRspBo;
import com.tydic.se.nlp.service.constant.QuerySqlEnum;
import com.tydic.se.nlp.service.utils.TxtFileUtil;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class TextCategorizationServiceImpl
implements TextCategorizationService {
    private static final Logger log = LoggerFactory.getLogger(TextCategorizationServiceImpl.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private final String suffix_txt = ".txt";

    public QueryCorpusDataRspBo saveDataToTxt(QueryCorpusDataReqBo reqBo) {
        QueryCorpusDataRspBo rspBo = new QueryCorpusDataRspBo();
        try {
            SqlRowSet rs = this.jdbcTemplate.queryForRowSet(QuerySqlEnum.COMMODITY_TYPE.getSql());
            while (rs.next()) {
                String typeId = rs.getString(1);
                String typeName = rs.getString(2);
                log.info("\u67e5\u8be2\u5230\u5546\u54c1\u7c7b\u578b\uff0c\u5f00\u59cb\u751f\u6210{},\u5bf9\u5e94\u7684\u6587\u4ef6", (Object)typeName);
                String filePath = reqBo.getOutPath() + File.separator + typeName;
                this.dealTypeFile(typeId, filePath);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        rspBo.setCode("0");
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }

    private void dealTypeFile(String typeId, String filePath) {
        String queryNameSql = QuerySqlEnum.COMMODITY_NAME.getSql() + typeId;
        try {
            SqlRowSet rs = this.jdbcTemplate.queryForRowSet(queryNameSql);
            int i = 0;
            while (rs.next()) {
                String commodityName = rs.getString(1);
                if (StringUtils.isEmpty((Object)commodityName)) continue;
                String fileName = filePath + File.separator + typeId + "_" + String.format("%05d", i) + ".txt";
                TxtFileUtil.writeNameToTxt(commodityName, fileName);
                ++i;
                log.info("\u6587\u4ef6\u751f\u6210\u5b8c\u6210\uff0c\u6587\u4ef6\u540d\u79f0\uff1a{}", (Object)fileName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

