package com.tydic.dyc.ssc.service.scheme;

import com.tydic.dyc.ssc.service.scheme.bo.SscSmartApprovePushChangeInfoReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSmartApprovePushChangeInfoRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSmartApproveRelationReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSmartApproveRelationRspBO;
import lombok.extern.ohaotian.HTServiceAPI;

/**
 * 智慧评审与采购方案关联
 *
 * @author hsw
 * @since 2024-8-16 11:19:58
 */
@HTServiceAPI
public interface SscSmartApproveRelationService {

    /**
     * 智慧评审-简易采购计划关联
     *
     * @param reqBO
     * @return
     */
    SscSmartApproveRelationRspBO dealRelationSimpleScheme(SscSmartApproveRelationReqBO reqBO);


    /**
     * 智慧评审-方案包关联
     *
     * @param reqBO
     * @return
     */
    SscSmartApproveRelationRspBO dealRelationPack(SscSmartApproveRelationReqBO reqBO);

    /**
     * 变更审批通过后推送变动信息给智能评审
     *
     * @param reqBO
     * @return
     */
    SscSmartApprovePushChangeInfoRspBO dealPushChangeInfo(SscSmartApprovePushChangeInfoReqBO reqBO);
}
