package com.tydic.dyc.ssc.service.scheme.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 描述:
 *
 * @author XiaWD
 * @date 2023/4/13 15:45
 * @Copyright: 2022 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于深圳天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class SscQrySchemePackExtBO implements Serializable {

    /**
     * 标段ID
     */
    private Long packId;
    /**
     * 方案ID
     */
    private Long schemeId;
    /**
     * 包名称
     */
    private String packName;
    /**
     * 包编码
     */
    private String packCode;
    /**
     * 包状态
     */
    private String packStatus;
    /**
     * 包描述
     */
    private String packDesc;
    /**
     * 保证金金额
     */
    private BigDecimal bidMarginAmount;
    /**
     * 标书费用
     */
    private BigDecimal tenderCost;
    /**
     * 预计总金额
     */
    private BigDecimal estAmount;
    /**
     * 供应商最少响应数
     */
    private Integer minSupNum;
    /**
     * 排序编码
     */
    private Integer sortCode;
    /**
     * 创建人名称
     */
    private String createName;
    /**
     * 创建人用户名
     */
    private String createUsername;
    /**
     * 创建人ID
     */
    private Long createLoginId;
    /**
     * 创建时间
     */
    private Date createTime;
    private Date createTimeStart;
    private Date createTimeEnd;
    /**
     * 创建人单位
     */
    private Long createOrgId;
    /**
     * 创建人单位名称
     */
    private String createOrgName;
    /**
     * 更新者ID
     */
    private Long updateLoginId;
    /**
     * 更新人
     */
    private String updateName;
    /**
     * 更新人用户名
     */
    private String updateUsername;
    /**
     * 删除标志
     */
    private Integer delTag;
    /**
     * 更新时间
     */
    private Date updateTime;
    private Date updateTimeStart;
    private Date updateTimeEnd;
    /**
     * 标段编号
     */
    private String packNo;
    /**
     * 执行状态
     */
    private String packExectStatus;
    /**
     * 执行人名称
     */
    private String implName;
    /**
     * 执行人编码
     */
    private String implCode;
    /**
     * 执行人ID
     */
    private String implId;

    /**
     * 本次删除的包id
     */
    private Long deletePackId;
    /**
     * 本次新增的包id
     */
    private Long addPackId;
    /**
     * 执行状态
     */
    private String schemeExectStatus;
    /**
     * 采购包id
     */
    private String purchasePackId;
    /**
     * 推送状态 0 成功 1 失败  2 同步中
     */
    private Integer pushStatus;
    /**
     * 推送类型 1-推送方案 5 同步状态给非招 6  同步执行人给非招
     */
    private Integer type;
    /**
     * 推送时间
     */
    private Date pushTime;
    /**
     * 推送报文
     */
    private String reqJson;
    /**
     * 响应报文
     */
    private String rspJson;
    /**
     * 推送ERP状态 0 成功 1 失败  2 同步中
     */
    private Integer pushErpStatus;
    /**
     * 同步返回值（给前端页面展示的返回中文）
     */
    private String pushReturnInfo;
    /**
     * 分交方式
     */
    private String schemeSubmitType;
    /**
     * 方案版本
     */
    private String schemeVersion;
    /**
     * 采购组织形式
     */
    private String organizationForm;
}
