package com.tydic.dyc.ssc.service.scheme.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 订单数量
 */
@Data
public class SscSchemeTenderItemReportBO implements Serializable {
    /**
     *包id
     */
    private String packId;

    /**
     * 申报单位编码（实际取值申报单位id）
     */
    private String decCompanyCode;
    /**
     * 申报单位编码(实际取值申报单位编码)
     */
    private String decCompanyCodeErp;

    /**
     * 申报单位名称
     */
    private String decCompanyName;

    /**
     * 采购计划编码
     */
    private String planNo;

    /**
     * 物资编码
     */
    private String itemCode;
    /**
     * 物资描述
     */
    private String itemName;

    /**
     * 计量单位
     */
    private String itemUnit;

    /**
     * 招标编码/标段编码
     */
    private String businessCode;

    /**
     * 招标编码/标段编码
     */
    private String businessName;


    /**
     * 招标采购量
     */
    private String businessNum;
    /**
     * 中标量
     */
    private Double itemNum;
    /**
     * 已订货数量
     */
    private Double orderCount;
    /**
     * 中标未定量
     */
    private Double itemNumNot;


    /**
     * 报价单价
     */
    private Double priceTax;
    /**
     * 报价单价(不含税)
     */
    private Double priceNotax;


    /**
     * 成交单价
     */
    private Double awardPriceTax;
    /**
     * 成交单价(不含税)
     */
    private Double awardPriceNotax;


    /**
     * 报价运杂费
     */
    private Double bidFreight;
    /**
     * 成交运杂费
     */
    private Double awardFreight;

    /**
     * 报价货款(含税)
     */
    private Double amountTax;
    /**
     * 成交货款(含税)
     */
    private Double awardAmountTax;
    /**
     * 项目编码
     */
    private String projectCode;
    /**
     * 项目名称
     */
    private String projectName;
    /**
     * 质量技术说明
     */
    private String technicalNorms;
    private Integer pageNo;
    private Integer pageSize;

    /**
     * 授标明细表id
     */
    private String awardNumId;

    /**
     * 合同类型 CONTRACT_CQCGXY 采购框架协议（定价）  CONTRACT_JSXY 采购框架协议（寄售）  CONTRACT_BZCGDD 现货采购合同
     */
    private String contractType;


    /**
     * 供应商主键id
     */
    private String companyId;
    /**
     * 供应商编码
     */
    private String companyCode;
    /**
     * 供应商名称
     */
    private String companyName;

    /**
     * 税率
     */
    private String awardItemTax;

    /**
     * 方案类型
     */
    private String schemeType;
    /**
     * 采购方式
     */
    private Integer dycBuyType;
    /**
     * 打包人
     */
    private String awardUserName;

    /**
     * 打包人编码
     */
    private String awardEmployeeNumber;
    /**
     * 计划明细ID
     */
    private String dycPlanItemId;
    /**
     * 可下单数量
     */
    private BigDecimal canOrderNum;
    /**
     * 物资分类字段
     */
    private Integer materialCategory;
    /**
     * 方案物资类别 (0:工程 1:货物 2:服务 3:金属 4:非金属 5:设备 6:配件)
     */
    private Integer schemeClass;
    /**
     * 申报单位编码
     */
    private String erpDeptCode;
    /**
     * 产地品牌
     */
    private String itemBrand;
    /**
     * 使用单位名称
     */
    private String reqUnitName;
    /**
     * 费率
     */
    private BigDecimal rate;
    /**
     * 报价类型
     */
    private BigDecimal quoteType;

}
