package com.tydic.dyc.ssc.service.scheme.bo;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 订单数量
 */
@Data
public class SscSchemeTenderReportBO implements Serializable {


    /**
     *包id
     */
    private String packId;
    /**
     * 申报单位编码
     */
    private String decCompanyCode;

    /**
     * 申报单位名称
     */
    private String decCompanyName;

    /**
     * 采购计划编码
     */
    private String planNo;

    /**
     * 物资编码
     */
    private String itemCode;
    /**
     * 物资描述
     */
    private String itemName;

    /**
     * 计量单位
     */
    private String itemUnit;


    /**
     * 招标采购量
     */
    private String businessNum;
    /**
     * 中标量
     */
    private Double itemNum;
    /**
     * 已订货数量
     */
    private Double orderCount;
    /**
     * 中标未定量
     */
    private Double itemNumNot;


    /**
     * 报价单价
     */
    private Double priceTax;
    /**
     * 报价单价(不含税)
     */
    private Double priceNotax;


    /**
     * 成交单价
     */
    private Double awardPriceTax;
    /**
     * 成交单价(不含税)
     */
    private Double awardPriceNotax;


    /**
     * 报价运杂费
     */
    private Double bidFreight;
    /**
     * 成交运杂费
     */
    private Double awardFreight;

    /**
     * 报价货款(含税)
     */
    private Double amountTax;
    /**
     * 成交货款(含税)
     */
    private Double awardAmountTax;
    /**
     * 项目编码
     */
    private String projectCode;
    /**
     * 项目名称
     */
    private String projectName;
    /**
     * 质量技术说明
     */
    private String technicalNorms;
    private Integer pageNo;
    private Integer pageSize;

    private String packageCode;

    private String packageName;
}
