package com.tydic.dyc.ssc.service.scheme.bo;

import lombok.Data;

import java.io.Serializable;
import java.util.List;


@Data
public class SchemeTenderReportReqBO  implements Serializable{


    /**
     * 第几页, 从1开始
     */
    private Integer pageNo;

    /**
     * 每页的数量
     */
    private Integer pageSize;
    /**
     * 招标编码
     */
    private String businessCode;
    /**
     * 招标名称
     */
    private String businessName;
    /**
     * 招标编号
     */
    private String businessNo;
    /**
     * 报价编码
     */
    private String bidCode;
    /**
     * 申报单位编码
     */
    private String declareCompanyCode;
    /**
     * 申报单位名称
     */
    private String declareCompanyName;
    /**
     * 项目编码
     */
    private String projectCode;
    /**
     * 采购计划编码
     */
    private String planNo;
    /**
     * 采购员编码
     */
    private String buyerId;
    /**
     * 费用类别
     */
    private String feeType;
    /**
     * 物资编码
     */
    private String itemCode;
    /**
     * 物资描述
     */
    private String itemName;
    /**
     * 项目名称
     */
    private String projectName;
    /**
     * 供应商编码
     */
    private String firmCode;
    /**
     * 供应商名称
     */
    private String firmName;
    /**
     * 采购级别
     */
    private String buyerLevel;
    /**
     * 询价制单人编码
     */
    private String createUid;
    /**
     * 结果制单人编码
     */
    private String awardCreateUserCode;
    /**
     * 计划使用单位
     */
    private String userCompanyName;

    private String authToken;
    /**
     * 查询全量明细的标志 为1时查询全量
     */
    private Integer queryAllStatus;

    /**
     * 自采/外采标识：
     * 1.自采 2外采
     */
    private String type;

    /**
     * 是否多经销商：0否1是
     */
    private Integer dealerFlag;
    /**
     * 传1的时候，能查出多经销商和未做过合同的，传0的时候能查出非多经销商和未做过合同的
     */
    private Integer contractFlag;
    /**
     * //1订单  0协议
     */
    private Integer orderType;
    /**
     * 是否查询通用物料编码（1或null:是（含通用物料编码）  0:否（不含通用物料编码））
     */
    private Integer universalItemCodeFlag;


    /**
     * 1是建议计划，不传或者其他不查询简易计划
     */
    private Integer isJy;

    /**
     * 单位类型0开发公司1采购单位
     */
    private Integer UnitType;

    /**
     * 查询类型 1集中采购 2委托采购 3自行采购
     */
    private Integer queryType;

    /**
     * 单位权限ID集合
     */
    List<String> authOrgIds;
    /**
     * erpCode编码
     */
    List<String> erpCodeList;
    /**
     * 采购包编码
     */
    private String packCode;

    /**
     * 采购包名称
     */
    private String packName;

    /**
     * 采购包编号
     */
    private String packNo;

    /**
     * 标段编码
     */
    private String bdCode;
    /**
     * 采购方式集合
     */
    private List<Integer> purchaseTypes;
    /**
     * 方案编码
     */
    private String schemeCode;

    /**
     * 方案名称
     */
    private String schemeName;

    /**
     * 页签类型 1集采合同 2集采现货合同 3采购标准合同 4采购框架合同
     */
    private Integer tabType;

    private String packageCode;

    private String packageName;
    /**
     * 合同起草人编码
     */
    private String crcHtQcUserCode;
    /**
     * 合同起草人名称
     */
    private String crcHtQcUserName;
    /**
     * 是否可下单 0：可展示为可下单量为0的数据 1：不展示
     */
    private String ifAllowOrder;
    /**
     * 是否查询中标时间，不为空 且为1 代表是
     */
    private Integer isQryBidTime;
    /**
     * 是否外部合同系统查询，不为空 或者 为1 代表是，因为占用的时候会判断合同或者订单只能存在一种，所以直接把做过订单的数据排除掉
     */
    private Integer isHTQry;
    /**
     *项目编码
     */
    private String bdCodeLike;
    /**
     *项目名称
     */
    private String bdNameLike;
}
