package com.tydic.dyc.ssc.service.scheme.bo;

import com.tydic.dyc.base.bo.BaseRspBo;
import lombok.Data;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 描述:
 *
 * @author XiaWD
 * @date 2023/4/13 15:41
 * @Copyright: 2022 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于深圳天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class SscQrySchemePackExtReqBO  extends BaseRspBo {
    /**
     * 是否全量同步ES
     */
    private Integer isFullSyncEs;
    /**
     * 方案ids
     */
    private List<Long> schemeIds;
    /**
     * 计划包Ids
     */
    private List<Long> packIds;
    /**
     * 包数据
     */
    private List<SscQrySchemePackExtBO> sscSchemePack;
    /**
     * 包的执行状态
     */
    private String packExectStatus;

    /**
     * 方案
     */
    private Long schemeId;
    /**
     * 计划包Ids
     */
    private Long packId;
    /**
     * 分配人id
     */
    private Long implId;
    /**
     * 分配人编码
     */
    private String implCode;
    /**
     * 分配人名称
     */
    private String implName;

    /**
     * 方案的执行状态
     */
    private String schemeExectStatus;
    /**
     * 计划包Ids（采购包）
     */
    private List<Long> purchasePackIds;
    /**
     *  是否查询数据库后再推送非招同步状态  不为空 且为 0 才是
     */
    private Integer isQryDatabaseSync;
    private Integer pageNo=1;
    private Integer pageSize=10;
    /**
     * 查询推送
     */
    private List<Integer> types;
    /**
     * 计划id
     */
    private Long planId;
    private List<Long> planIds;
    /**
     * 物料编码
     */
    private String itemNo;
    /**
     * 物料名称
     */
    private String itemName;
    /**
     * 物料名称
     */
    private String itemDesc;
    /**
     * 物料规格
     */
    private String spec;
    /**
     * 物料型号
     */
    private String model;
    /**
     * 计量单位名称
     */
    private String measureUnitName;
    /**
     * 物料分类编码
     */
    private String catalogCode;
    /**
     * 物料分类编码
     */
    private String catalogName;
    /**
     * 集采管控目录  是、否 、空
     */
    private String inControlsCatalog;
    /**
     * 集采实施目录 是、否 、空
     */
    private String inImplementCatalog;
    /**
     * 方案编号
     */
    private String schemeNo;
    /**
     * 创建人名称
     */
    private String createName;
    /**
     * 创建人账号
     */
    private String createUsername;
    /**
     * 方案类型
     */
    private String schemeType;
    /**
     * 查询哪张物资表，1是 查询草稿表  2 是查询正式表  3 是查询历史表
     */
    private Integer qryFlag;
    /**
     * 方案历史id
     */
    private Long schemeHisId;
    /**
     * 采购方案包ids (当方案修改时，新添加的分配的采购方案包，因为此时包数据还没有存到数据库)
     */
    private List<Long> purchasePackageIds;

    /**
     * 方案物料信息
     */
    private List<SscSchemeMatCceExtBO> sscSchemeMat;
    /**
     * 令牌
     */
    private String token;
    /**
     * 是否草稿
     */
    private Boolean enableDraft;
    /**
     * 更新类型
     */
    private String updateType;
    /**
     * 是否统计预算金额
     */
    private Boolean estAmountFlag;
    /**
     * 采购方案分交方式变更记录
     */
    private List<SscSchemeChangeDistributionModeLogBO> list;
    /**
     * 用户id，不需要前端传入，会员中心注入
     */
    private Long userId;
    /**
     * 用户名称，不需要前端传入，会员中心注入
     */
    private String name;
    /**
     * 用户登陆名称，不需要前端传入，会员中心注入
     */
    private String username;
    /**
     * 用户id，不需要前端传入，会员中心注入
     */
    private Long operateId;
    /**
     * 用户名称，不需要前端传入，会员中心注入
     */
    private String operateName;
    /**
     * 用户登陆名称，不需要前端传入，会员中心注入
     */
    private String operateCode;
    /**
     * 依据附件BOS
     */
    private List<SchemeBasisFileBO> basisFileBoList;
    /**
     * 依据附件生成失败BO
     */
    private SchemeBasisFileBuildFailBO schemeBasisFileBuildFailBO;
    /**
     * 依据附件生成失败BOS
     */
    private List<SchemeBasisFileBuildFailBO> basisFailBoList;
    /**
     * 依据附件初始化BOS
     */
    private List<SchemeBasisFileInitBO> basisFileInitBoList;
    /**
     * 处理失败的主键id
     */
    private List<Long> failIds;
    /**
     * 0 未处理 1已处理 2失败补偿正在处理中
     */
    private Integer status;
    /**
     * 文件类型：1是采购方案word导出
     */
    private Integer fileType;

    /**
     * 用于加签记录
     */
    private List<SscJoinSignLogBO> joinSignLogBOS;
    /**
     * 将要查询加签记录的任务ids
     */
    private List<String> taskIds;
    /**
     * 实例Id
     */
    private String procInstId;
    /**
     * 任务Id
     */
    private String formUrl;
    /**
     * 方案Id
     */
    private Long orderId;
    /**
     * uoc_order_task_inst的objId
     */
    private Long objId;
    /**
     * 方案关联的智能评审
     */
    private SscQrySchemeRelationExtBO schemeRelationExtBO;
    /**
     * 方案包关联的智能评审
     */
    private List<SscQrySchemePackRelationExtBO> packRelationExtBOS;

}
