package com.tydic.dyc.ssc.service.scheme.bo;

import lombok.Data;

import java.io.Serializable;
import java.util.List;


/**
* 标题:XwgLSaveLogReqBoXwglLogs
* 说明:
* 时间:2024/12/12 19:42:16
* 作者:liaoxj
*/
@Data
public class XwgLSaveLogXwglLogBO implements Serializable {

    private static final long serialVersionUID = 100000000430667421L;

    /**
    * 主键id
    * 是否必传：true
    */
    private Long id;
    /**
    * 是否必传：false
    */
    private String ext1;
    /**
    * 是否必传：false
    */
    private String ext2;
    /**
    * 是否必传：false
    */
    private String ext3;
    /**
    * 是否必传：false
    */
    private String ext4;
    /**
    * 规则id
    * 是否必传：true
    */
    private Long rulId;
    /**
    * 适用的应用系统(一级类型id)
    * 是否必传：false
    */
    private Long applicableSystemId;
    /**
    * 业务域(二级类型id)
    * 是否必传：false
    */
    private Long businessDomainId;
    /**
    * 业务环节(三级类型id)
    * 是否必传：false
    */
    private Long businessSegmentId;
    /**
    * 适用的应用系统(一级类型名称)
    * 是否必传：false
    */
    private String applicableSystem;
    /**
    * 业务域(二级类型名称)
    * 是否必传：false
    */
    private String businessDomain;
    /**
    * 业务环节(三级类型名称)
    * 是否必传：false
    */
    private String businessSegment;
    /**
    * 规则编号
    * 是否必传：true
    */
    private String ruleNo;
    /**
    * 规则名称
    * 是否必传：true
    */
    private String ruleName;
    /**
    * 规则的具体内容
    * 是否必传：true
    */
    private String ruleContent;
    /**
    * 规则类别(1-业务提醒，2-风险预警,3-强制拦截,4-事后分析)
    * 是否必传：true
    */
    private String ruleCategory;
    /**
    * 是否有值，不允许为空(1是，0不是)
    * 是否必传：true
    */
    private String hasValue;
    /**
    * 处理方式，枚举类型 (1-弹窗提醒-填写说明，2-弹窗提醒-上传附件，3-异常项目标记，4提级审批,5-弹窗提醒)多个值英文,分隔
    * 是否必传：true
    */
    private String processingMethod;
    /**
    * 预警来源
    * 是否必传：false
    */
    private String warningSource;
    /**
    * 预警说明
    * 是否必传：false
    */
    private String warningDescription;
    /**
    * 类型 1-合规监管规则，2-库存监管规则
    * 是否必传：false
    */
    private String ruleManagementType;
    /**
    * 版本号
    * 是否必传：false
    */
    private String ruleManagementVersion;
    /**
    * 变量值
    * 是否必传：false
    */
    private String ruleManagementVariableValue;
    /**
    * 变量数量
    * 是否必传：false
    */
    private String variableCount;
    /**
    * 跳转地址前缀
    * 是否必传：false
    */
    private String preUrl;
    /**
    * 0未删除1已经删除
    * 是否必传：true
    */
    private String isDeleted;
    /**
    * 业务主键ID
    * 是否必传：true
    */
    private String businessId;
    /**
    * 业务code
    * 是否必传：true
    */
    private String businessCode;
    /**
    * 业务名称
    * 是否必传：true
    */
    private String businessName;
    /**
    * 查看的页面URL，不包括HTTP://IP:PORT的落地页，以/开头
    * 是否必传：true
    */
    private String businessUrl;
    /**
    * 警告中的供应商ID，如果有
    * 是否必传：false
    */
    private Long xwglSupplierId;
    /**
    * 警告中的供应商名称（冗余）
    * 是否必传：false
    */
    private String xwglSupplierName;
    /**
    * 警告中我方用户ID（项目经理/责任人/创建人）
    * 是否必传：false
    */
    private Long managerId;
    /**
    * 警告中我方用户姓名（冗余）
    * 是否必传：false
    */
    private String managerName;
    /**
    * 部门ID，公司ID,MANAGER_ID所在的公司ID（如果有）
    * 是否必传：false
    */
    private Long deptId;
    /**
    * 部门名称（冗余）
    * 是否必传：false
    */
    private String deptName;
    /**
    * 公司ID，MANAGER_ID所在的公司ID
    * 是否必传：false
    */
    private Long companyId;
    /**
    * 公司名称（冗余）
    * 是否必传：false
    */
    private String companyName;
    /**
    * 附件
    * 是否必传：true
    */
    private List<XwgLXwglLogsFileInfo> fileInfo;
    /**
     * 是否直接记录到中台
     */
    private Integer isZj;

}