package com.tydic.dyc.ssc.service.scheme.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 描述:
 *
 * @author XiaWD
 * @date 2024/11/13 下午8:51
 * @Copyright: 2022 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于深圳天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class SscEntrustResultPO implements Serializable {
    /**
     * 结果id
     */
    private Long resultId;
    /**
     * 委托书表的packId
     */
    private Long packId;
    /**
     * 同步表id
     */
    private Long syncId;
    /**
     * 寻源id集合
     */
    private List<Long> resultIds;
    /**
     * 委托书id
     */
    private Long entrustId;
    /**
     * 委托书id
     */
    private List<Long> entrustIds;
    /**
     * 项目进展(1委托退回,2委托书,3评标报告,4结果录入，6定标,7公示通知,8委托完成,9废标,10委托终止)
     */
    private BigDecimal procProgress;

    /**
     * 项目进展(1委托退回,2委托书,3评标报告,4结果录入，6定标,7公示通知,8委托完成,9废标,10委托终止)
     */
    private BigDecimal noProcProgress;

    public BigDecimal getProcProgress() {
        if(procProgress != null){
            return  procProgress.stripTrailingZeros();
        }
        return procProgress;
    }

    public void setProcProgress(BigDecimal procProgress) {
        this.procProgress = procProgress;
    }

    /**
     * 审批状态(4委托书审批通过,5.定标审批中，6定标审批驳回,7定标审批通过,8.结果公示审批中，9结果公示审批驳回,10结果公示审批通过，11.结果公示审批中，12结果通知审批驳回,13结果通知审批通过)
     */
    private Integer auditStatus;
    /**
     * 标段编码
     */
    private String bdCode;
    /**
     * 标段名称
     */
    private String bdName;
    /**
     * 招标项目编码
     */
    private String projectCode;
    /**
     * 招标项目名称
     */
    private String projectName;
    /**
     * 项目联系人
     */
    private String contactName;
    /**
     * 项目电话
     */
    private String contactTel;
    /**
     * 项目负责人
     */
    private String projectLeader;
    /**
     * 部门负责人
     */
    private String departmentLeader;
    /**
     * 非招(招标)项目进展
     */
    private String fzzbProgress;
    /**
     * 定标人id
     */
    private String dbUserId;
    /**
     * 定标人姓名
     */
    private String dbUserName;
    /**
     * 定标人编码
     */
    private String dbUserCode;
    /**
     * 同步状态(0:同步中,1待同步,2同步失败,3:同步成功)
     */
    private Integer syncStatus;
    /**
     * 定标意见(废标意见)
     */
    private String remarkDesc;
    /**
     * 废标操作人编码
     */
    private String fbUserCode;
    /**
     * 废标操作人名称
     */
    private String fbUserName;
    /**
     * 废标操作时间
     */
    private Date fbOperTime;
    private Date fbOperTimeStart;
    private Date fbOperTimeEnd;
    /**
     * 询价状态(1正常,0废标)
     */
    private Integer xjStatus;
    /**
     * 终止状态(1正常,0废标)
     */
    private Integer zzStatus;
    /**
     * 终止意见(终止意见)
     */
    private String zzRemarkDesc;
    /**
     * 终止操作人编码
     */
    private String zzUserCode;
    /**
     * 终止操作人名称
     */
    private String zzUserName;
    /**
     * 终止操作时间
     */
    private Date zzOperTime;
    private Date zzOperTimeStart;
    private Date zzOperTimeEnd;
    private String auditKey;
    /**
     * 创建时间
     */
    private Date createTime;
    private Date createTimeStart;
    private Date createTimeEnd;
    /**
     * 审批时间
     */
    private Date auditTime;
    private Date auditTimeStart;
    private Date auditTimeEnd;
    /**
     * 修改时间
     */
    private Date updateTime;
    private Date updateTimeStart;
    private Date updateTimeEnd;
    /**
     * 成交方式（1总价，2单价，3费率）
     */
    private String cjfs;
    /**
     * 提交单位编码
     */
    private String tjDeptCode;
    /**
     * 提交单位名称
     */
    private String tjDeptName;
    /**
     * 提交时间
     */
    private String tjTime;
    /**
     * 提交单位id
     */
    private String tjDeptId;
    /**
     * 定标意见
     */
    private String dbRemark;
    /**
     * 审批撤回原因
     */
    private String auditRemark;
    private String ext1;
    private String ext2;
    private String ext3;
    private String ext4;
    private String ext5;
    private String ext6;
    private String ext7;
    private String ext8;


    /**
     * 记录开标时间
     */
    private Date bidOpeningTime;
    /**
     * 退回操作人编码
     */
    private String thUserCode;
    /**
     * 退回操作人名称
     */
    private String thUserName;
    /**
     * 退回意见
     */
    private String thRemarkDesc;
    /**
     * 退回时间
     */
    private Date thOperTime;
    private Date thOperTimeStart;
    private Date thOperTimeEnd;
    /**
     * 排序
     */
    private String orderBy;
    /**
     * 委托书编码
     */
    private String entrustCode;

    /**
     * 方案id
     */
    private  Long schemeId;
    /**
     * 报价方式
     */
    private String quotationType;
    /**
     * 下发状态
     */
    private Integer sendStatus;
    /**
     *合同起草用户id
     */
    private String htQcUserId;
    /**
     *合同起草用户code
     */
    private String htQcUserCode;
    /**
     *合同起草用户
     */
    private String htQcUserName;
    /**
     *合同起草分配操作用户id集合
     */
    private String operUserId;
    /**
     * 委托书来源:1:采购方案,2简易采购计划
     */
    private String source;
    /**
     * 下发时间
     */
    private Date sendTime;
    /**
     * 采购方式
     */
    private String purType;
    private String setSyncStatus;
    /**
     * 委托书表的packId
     */
    private List<Long> packIds;
    /**
     * 排除项目进展(1委托退回,2委托书,3评标报告,4结果录入，6定标,7公示通知,8委托完成,9废标,10委托终止)
     */
    private BigDecimal exetProcProgress;
    /**
     * 委托书名称
     */
    private String entrustName;
    /**
     * 委托书编号
     */
    private String entrustNo;
    /**
     * 制单人编码
     */
    private String createUsername;
    /**
     * 制单人名称
     */
    private String createName;
    /**
     * 制单单位编码
     */
    private String createOrgNo;
    /**
     * 制单单位名称
     */
    private String createOrgName;
    /**
     * 计划Id
     */
    private Long planId;
    /**
     * 委托书成交方式（1总价，2单价，3费率）
     */
    private String cjType;
    /**
     * 排除废标和委托终止的标志位
     */
    private Integer extStatus;
}
