package com.tydic.dyc.ssc.service.scheme.bo;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.math.BigDecimal;
import java.util.List;

/**
 * 标题：采购方案询比结果主体 BO
 * 时间：2023/08/07
 */
@Data
public class SscGetAwardResultExtBO implements Serializable {

    private static final long serialVersionUID = 7026865402707762994L;

    /**
     * 供应商编码
     */
    private String companyCode;

    /**
     * 供应商名称
     */
    private String companyName;

    /**
     * 报价编码
     */
    private String bidCode;

    /**
     * 询价书主键ID
     */
    private String businessId;

    /**
     * 询价书编码
     */
    private String businessCode;

    /**
     * 询价书名称
     */
    private String businessName;

    /**
     * 采购结果
     */
    private String purchaserResult;

    /**
     * 授标结果主键ID
     */
    private String awardId;

    /**
     * 采购包编码
     */
    private String packageCode;

    /**
     * 采购包Id
     */
    private String packId;

    /**
     * 方案类型
     */
    private Integer schemeType;

    /**
     * 方案编码
     */
    private String schemeCode;

    /**
     * 方案名称
     */
    private String schemeName;

    /**
     * 合同类型 CONTRACT_CQCGXY 采购框架协议（定价）  CONTRACT_JSXY 采购框架协议（寄售）  CONTRACT_BZCGDD 现货采购合同
     */
    private String contractType;

    /**
     * 采购方案询比结果明细 BO
     */
    private List<SscGetAwardResultItemExtBO> itemResultVoList;

    private String bdCode;
    /**
     * 采购单位编码
     */
    private String createCompanyCode;

    /**
     * 采购单位名称
     */
    private String createCompanyName;
    /**
     * 成交方式1.总价成交2.单价成交3.费率成交
     */
    private String cjType;
    /**
     * 供应商中标表主键Id
     */
    private Long supTabId;
    /**
     * 审批时间
     */
    private Date auditTime;
    /**
     * 中标时间
     */
    private Date bidTime;
    /**
     * 是否紧急采购 0否1是
     */
    private Integer emergencyFlag;
    /**
     * 报价类型 10-含税报价，20-不含税报价，30-费率
     */
    private Integer quoteType;
    /**
     * 费率值
     */
    private BigDecimal rate;
    /**
     * 币种
     */
    private String currency;
    private String currencyName;
    /**
     * 询价制单人编码
     */
    private String createUid;
    /**
     * 询价制单人编码名称
     */
    private String createUidName;
    /**
     * 结果制单人编码
     */
    private String awardCreateUserCode;
    /**
     * 结果制单人名称
     */
    private String awardCreateUserName;
    /**
     * 产地品牌
     */
    private String produceBrand;
    /**
     * 执行标准
     */
    private String technicalNorms;

}
