package com.tydic.dyc.ssc.service.scheme.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 描述:
 *
 * @author XiaWD
 * @date 2024/11/13 下午7:44
 * @Copyright: 2022 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于深圳天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class SscInquiryPO implements Serializable {
    /**
     * 询价id
     */
    private Long inquiryId;
    /**
     * 项目进展(1授标，2公示通知，3询比完成，4废标)
     */
    private BigDecimal progress;
    /**
     * 审批状态(1:询价书审批通过,2.授标审批中，3授标审批驳回,4授标审批通过,8.结果公示审批中，9结果公示审批驳回,10结果公示审批通过，11.结果通知审批中，12结果通知审批驳回,13结果通知审批通过,20询价书变更审批通过,21询价书变更审批撤回,22询价书变更审批驳回,23授标回退)
     */
    private Integer auditStatus;
    /**
     * 询价书编码
     */
    private String inquiryCode;
    /**
     * 询价通知书编码
     */
    private String xbCode;
    /**
     * 询价名称
     */
    private String inquirytName;
    /**
     * 询价编号
     */
    private String inquiryNo;
    /**
     * 采购方式
     */
    private String purType;
    /**
     * 报价方式
     */
    private String quotationType;
    /**
     * 报名单位
     */
    private String bmDw;
    /**
     * 报价单位
     */
    private String bjDw;
    /**
     * 报价开始时间
     */
    private Date bjStartTime;
    private Date bjStartTimeStart;
    private Date bjStartTimeEnd;
    /**
     * 报价结束时间
     */
    private Date bjEndTime;
    private Date bjEndTimeStart;
    private Date bjEndTimeEnd;
    /**
     * 报价揭示时间
     */
    private Date bjJsTime;
    private Date bjJsTimeStart;
    private Date bjJsTimeEnd;
    /**
     * 预算金额
     */
    private BigDecimal ysje;
    /**
     * 包id
     */
    private Long packId;
    /**
     * 包编码
     */
    private String packCode;
    /**
     * 包名称
     */
    private String packName;
    /**
     * 包编号
     */
    private String packNo;
    /**
     * 采购单位id
     */
    private Long purId;
    /**
     * 采购单位编码
     */
    private String purNo;
    /**
     * 采购单位名称
     */
    private String purName;
    /**
     * 采购单位机构路径
     */
    private String purPath;
    /**
     * 制单单位id
     */
    private Long createOrgId;
    /**
     * 制单单位编码
     */
    private String createOrgNo;
    /**
     * 制单单位名称
     */
    private String createOrgName;
    /**
     * 制单单位机构路径
     */
    private String createOrgPath;
    /**
     * 制单人id
     */
    private Long createUserId;
    /**
     * 制单人编码
     */
    private String createUsername;
    /**
     * 制单人名称
     */
    private String createName;
    /**
     * 授标人id
     */
    private String sbUserId;
    /**
     * 授标人姓名
     */
    private String sbUserName;
    /**
     * 授标人编码
     */
    private String sbUserCode;
    /**
     * 合同类型
     */
    private String contractType;
    /**
     * 成交方式1.总价成交2.单价成交3.费率成交
     */
    private String cjType;
    /**
     * 采购联系人电话
     */
    private String purContactMoblie;
    /**
     * 采购联系人
     */
    private String purContactMan;
    /**
     * 是否抽取专家（1抽，0不抽）
     */
    private Integer isZj;
    /**
     * 询价状态(1正常,2废标)
     */
    private Integer xjStatus;
    /**
     * 授标意见
     */
    private String remark;
    /**
     * 审批key
     */
    private String auditKey;
    /**
     * 创建时间
     */
    private Date createTime;
    private Date createTimeStart;
    private Date createTimeEnd;
    /**
     * 审批时间
     */
    private Date auditTime;
    private Date auditTimeStart;
    private Date auditTimeEnd;
    /**
     * 修改时间
     */
    private Date updateTime;
    private Date updateTimeStart;
    private Date updateTimeEnd;
    /**
     * 废标人id
     */
    private String ext1;
    /**
     * 废标人code
     */
    private String ext2;
    /**
     * 废标人名称
     */
    private String ext3;
    /**
     * 废标时间
     */
    private String ext4;
    /**
     * 审批意见
     */
    private String ext5;
    /**
     * 条款id
     */
    private String ext6;
    /**
     * 询价书uuid
     */
    private String ext7;
    /**
     * 询价书来源(1:采购方案包,2简易采购计划)
     */
    private String ext8;
    /**
     * 排序
     */
    private String orderBy;
    /**
     * 审批提交人id
     */
    private String tjUserCode;
    /**
     * 审批提交人Name
     */
    private String tjUserName;
    /**
     * 审批提交部门id
     */
    private String tjDeptCode;
    /**
     * 审批提交部门
     */
    private String tjDeptName;
    /**
     * 提交时间
     */
    private String tjTime;
    /**
     * 寻源代理机构
     */
    private String agencyName;

    /**
     * 下发状态
     */
    private Integer sendStatus;
    /**
     * 询价ids
     */
    private List<Long> inquiryIds;
    /**
     * 合同起草用户id
     */
    private String htQcUserId;
    /**
     * 合同起草用户code
     */
    private String htQcUserCode;
    /**
     * 合同起草用户
     */
    private String htQcUserName;
    /**
     * 合同起草分配操作用户id集合
     */
    private String operUserId;

    /**
     * 下发时间
     */
    private Date sendTime;
    /**
     * 包id lIST
     */
    private List<Long> packIds;
    /**
     * 排除的进展状态
     */
    private BigDecimal exetProcProgress;
    /**
     * 计划Id
     */
    private Long planId;

    /**
     * 是否允许分项成交
     */
    private Integer isSubItem;
    /**
     * 物资类别
     */
    private Integer itemType;
    private Date xbjgCreateTime;

    /**
     * 报价类型（10- 含税报价，20-不含税报价，30-费率）
     */
    private Integer pQuoteTypes;
    /**
     * 报价书数量
     */
    private Integer bjsCount;
    /**
     * 成交总额
     */
    private BigDecimal cjTotalAmount;
    /**
     * 委托结果id
     */
    private Long resultId;
}
