package com.tydic.dyc.ssc.service.scheme;

import java.util.ArrayList;
import java.util.List;

import com.tydic.dyc.ssc.service.scheme.constant.RspConstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import com.tydic.dyc.ssc.model.common.ISscCommonModel;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.model.common.sub.SscExtInfo;
import com.tydic.dyc.ssc.model.common.sub.SscExtObjInfo;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeDetailReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeDetailRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeAllocationExtReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeAllocationExtRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemePackBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscUpdatePackMainBatchReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscUpdateSchemeMainReqBO;

import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.ohaotian.HTServiceRef;
import lombok.extern.slf4j.Slf4j;

/**
 * 方案相关接口
 * @author lj
 * @Version 1.0.0
 * @date 2023/3/17
 **/
@HTServiceImpl
@Slf4j
public class QrySchemeServiceImpl implements QrySchemeService {
	@Autowired
	private ISscCommonModel iSscCommonModel;
	@HTServiceRef
	private SscUpdatePackMainBatchService sscUpdatePackMainBatchService;
	@HTServiceRef
	private SscUpdateSchemeMainService sscUpdateSchemeMainService;
	@HTServiceRef
	private SscQrySchemeDetailService sscQrySchemeDetailService;

	// 方案分配服务
	/*@Override
	public SscSchemeAllocationExtRspBO updateSchemeExt(SscSchemeAllocationExtReqBO reqBO) {
		SscSchemeAllocationExtRspBO rspBO = new SscSchemeAllocationExtRspBO();
		// 当分交方式为集采实施-自营时，添加方案表和方案包扩展字段
		if ("集采实施-自营".equals(reqBO.getSchemeSubmitType())) {
			SscCommonDo sscCommonDo = new SscCommonDo();
			List<SscExtObjInfo> list = new ArrayList<>();
			for (Long schemeId : reqBO.getSchemeIds()) {
				SscExtObjInfo schemeInfo = new SscExtObjInfo();
				schemeInfo.setOrderId(schemeId);
				schemeInfo.setObjId(schemeId);
				schemeInfo.setObjType("ssc_scheme_ext");
				List<SscExtInfo> listinfos = new ArrayList<>();
				SscExtInfo info1 = new SscExtInfo();
				info1.setFieldCode("purchaseUserId");
				info1.setFieldName("采购员Id");
				info1.setFieldValue(reqBO.getImplId() + "");
				SscExtInfo info2 = new SscExtInfo();
				info2.setFieldCode("purchaseUserCode");
				info2.setFieldName("采购员编码");
				info2.setFieldValue(reqBO.getImplCode());
				SscExtInfo info3 = new SscExtInfo();
				info3.setFieldCode("purchaseUserName");
				info3.setFieldName("采购员名称");
				info3.setFieldValue(reqBO.getImplName());
	
				listinfos.add(info1);
				listinfos.add(info2);
				listinfos.add(info3);
	
				schemeInfo.setExtInfo(listinfos);
				list.add(schemeInfo);
	
				// 修改方案主表
				SscUpdateSchemeMainReqBO sscUpdateSchemeMainReqBO = new SscUpdateSchemeMainReqBO();
				sscUpdateSchemeMainReqBO.setSchemeId(schemeId);
				sscUpdateSchemeMainReqBO.setImplId(reqBO.getImplId());
				sscUpdateSchemeMainReqBO.setImplCode(reqBO.getImplCode());
				sscUpdateSchemeMainReqBO.setImplName(reqBO.getImplName());
				sscUpdateSchemeMainReqBO.setRemark(reqBO.getRemark());
				sscUpdateSchemeMainService.updateSchemeMain(sscUpdateSchemeMainReqBO);
	
				SscQrySchemeDetailReqBO sscQrySchemeDetailReqBO = new SscQrySchemeDetailReqBO();
				sscQrySchemeDetailReqBO.setEnableDraft(false);
				sscQrySchemeDetailReqBO.setSchemeId(schemeId);
				SscQrySchemeDetailRspBO qrySchemeDetail = sscQrySchemeDetailService
						.qrySchemeDetail(sscQrySchemeDetailReqBO);
				List<SscSchemePackBO> PackBOList = null;
				if (qrySchemeDetail != null && qrySchemeDetail.getSscQrySchemeDetailBO() != null
						&& !CollectionUtils.isEmpty(qrySchemeDetail.getSscQrySchemeDetailBO().getSscSchemePack())) {
					List<SscExtInfo> listExtInfos = new ArrayList<>();
					SscExtInfo ExtInfo1 = new SscExtInfo();
					ExtInfo1.setFieldCode("purchaseUserId");
					ExtInfo1.setFieldName("采购员Id");
					ExtInfo1.setFieldValue(reqBO.getImplId() + "");
					SscExtInfo ExtInfo2 = new SscExtInfo();
					ExtInfo2.setFieldCode("purchaseUserCode");
					ExtInfo2.setFieldName("采购员编码");
					ExtInfo2.setFieldValue(reqBO.getImplCode());
					SscExtInfo ExtInfo3 = new SscExtInfo();
					ExtInfo3.setFieldCode("purchaseUserName");
					ExtInfo3.setFieldName("采购员名称");
					ExtInfo3.setFieldValue(reqBO.getImplName());
					listExtInfos.add(ExtInfo1);
					listExtInfos.add(ExtInfo2);
					listExtInfos.add(ExtInfo3);
	
					PackBOList = new ArrayList<>();
					SscSchemePackBO bo = null;
					for (SscSchemePackBO ssc : qrySchemeDetail.getSscQrySchemeDetailBO().getSscSchemePack()) {
						SscExtObjInfo schemeExtInfo = new SscExtObjInfo();
						schemeExtInfo.setObjType("ssc_scheme_pack_ext");
						schemeExtInfo.setOrderId(schemeId);
						schemeExtInfo.setObjId(ssc.getPackId());
						schemeExtInfo.setExtInfo(listExtInfos);
						list.add(schemeExtInfo);
	
						bo = new SscSchemePackBO();
						bo.setPackId(ssc.getPackId());
						bo.setSchemeId(schemeId);
						bo.setImplCode(reqBO.getImplCode());
						bo.setImplId(reqBO.getImplId());
						bo.setImplName(reqBO.getImplName());
						PackBOList.add(bo);
					}
				}
				if (PackBOList != null) {
					SscUpdatePackMainBatchReqBO sscUpdatePackMainBatchReqBO = new SscUpdatePackMainBatchReqBO();
					sscUpdatePackMainBatchReqBO.setSscSchemePack(PackBOList);
					sscUpdatePackMainBatchService.updateSchemeBatchMain(sscUpdatePackMainBatchReqBO);
				}
			}
			sscCommonDo.setExtObjInfos(list);
			iSscCommonModel.addExtInfo(sscCommonDo);
		} else if ("企业自采".equals(reqBO.getSchemeSubmitType())) {
			SscCommonDo sscCommonDo = new SscCommonDo();
			List<SscExtObjInfo> list = new ArrayList<>();
			for (Long schemeId : reqBO.getSchemeIds()) {
				SscExtObjInfo schemeInfo = new SscExtObjInfo();
				schemeInfo.setOrderId(schemeId);
				schemeInfo.setObjId(schemeId);
				List<SscExtInfo> listinfos = new ArrayList<>();
				schemeInfo.setObjType("ssc_scheme_ext");
				SscExtInfo info4 = new SscExtInfo();
				info4.setFieldCode("agencyFlag");
				info4.setFieldName("是否非招代理");
				info4.setFieldValue(reqBO.getAgencyFlag());
				listinfos.add(info4);
				
				schemeInfo.setExtInfo(listinfos);
				list.add(schemeInfo);
			}
			sscCommonDo.setExtObjInfos(list);
			iSscCommonModel.updateExtInfo(sscCommonDo);
		}
		// 修改分配方式状态和
		SscCommonDo sscCommonDo = new SscCommonDo();
		log.info("---------------------方案分配进行分交方式----------------------");
		List<SscExtObjInfo> list = new ArrayList<>();
		for (Long schemeId : reqBO.getSchemeIds()) {
			SscExtObjInfo schemeInfo = new SscExtObjInfo();
			schemeInfo.setOrderId(schemeId);
			schemeInfo.setObjId(schemeId);
			schemeInfo.setObjType("ssc_scheme_ext");
			List<SscExtInfo> listinfos = new ArrayList<>();
			SscExtInfo info1 = new SscExtInfo();
			info1.setFieldCode("schemeSubmitType");
			info1.setFieldName("方案分交方式");
			info1.setFieldValue(reqBO.getSchemeSubmitType());
			SscExtInfo info2 = new SscExtInfo();
			info2.setFieldCode("assignStatus");
			info2.setFieldName("分配状态");
			info2.setFieldValue("已分配");
			listinfos.add(info1);
			listinfos.add(info2);
			schemeInfo.setExtInfo(listinfos);
			list.add(schemeInfo);
			// 修改方案主表
			SscUpdateSchemeMainReqBO sscUpdateSchemeMainReqBO = new SscUpdateSchemeMainReqBO();
			sscUpdateSchemeMainReqBO.setSchemeId(schemeId);
			sscUpdateSchemeMainReqBO.setRemark(reqBO.getRemark());
			sscUpdateSchemeMainService.updateSchemeMain(sscUpdateSchemeMainReqBO);
		}
		sscCommonDo.setExtObjInfos(list);
		iSscCommonModel.updateExtInfo(sscCommonDo);
		log.info("---------------------方案分配完成----------------------");
		return rspBO;
	}*/

	@Override
	public SscSchemeAllocationExtRspBO updateSchemeExt(SscSchemeAllocationExtReqBO reqBO) {
		SscSchemeAllocationExtRspBO rspBO = new SscSchemeAllocationExtRspBO();

		if (reqBO != null && !CollectionUtils.isEmpty(reqBO.getSchemeIds())) {

			SscCommonDo sscCommonDoupdate = new SscCommonDo();
			SscCommonDo sscCommonDoadd = new SscCommonDo();
			List<SscExtObjInfo> listupdate = new ArrayList<>();
			List<SscExtObjInfo> listadd = new ArrayList<>();

			SscExtInfo info1 = new SscExtInfo();
			info1.setFieldCode("schemeSubmitType");
			info1.setFieldName("方案分交方式");
			info1.setFieldValue(reqBO.getSchemeSubmitType());

			SscExtInfo info2 = new SscExtInfo();
			info2.setFieldCode("assignStatus");
			info2.setFieldName("分配状态");
			info2.setFieldValue("已分配");
			List<SscExtInfo> listinfos1 = new ArrayList<>();
			listinfos1.add(info1);
			List<SscExtInfo> listinfos2 = new ArrayList<>();
			listinfos2.add(info2);

			for (Long schemeId : reqBO.getSchemeIds()) {
				SscExtObjInfo schemeInfo1 = new SscExtObjInfo();
				schemeInfo1.setOrderId(schemeId);
				schemeInfo1.setObjId(schemeId);
				schemeInfo1.setObjType("ssc_scheme_ext");
				schemeInfo1.setExtInfo(listinfos1);
				listupdate.add(schemeInfo1);



				// 通过方案id查询方案和方案包信息
				SscQrySchemeDetailReqBO sscQrySchemeDetailReqBO = new SscQrySchemeDetailReqBO();
				sscQrySchemeDetailReqBO.setEnableDraft(false);
				sscQrySchemeDetailReqBO.setSchemeId(schemeId);
				SscQrySchemeDetailRspBO qrySchemeDetail = sscQrySchemeDetailService
						.qrySchemeDetail(sscQrySchemeDetailReqBO);

				//新增之前先删除
				List<SscExtObjInfo> deleteExtObjInfoList = new ArrayList<>();

				List<SscSchemePackBO> PackBOList = null;
				// 判断是否有采购包信息
				if (qrySchemeDetail != null && qrySchemeDetail.getSscQrySchemeDetailBO() != null
						&& !CollectionUtils.isEmpty(qrySchemeDetail.getSscQrySchemeDetailBO().getSscSchemePack())) {
					
					for (SscSchemePackBO ssc : qrySchemeDetail.getSscQrySchemeDetailBO().getSscSchemePack()) {
						SscExtObjInfo schemeInfo2 = new SscExtObjInfo();
						schemeInfo2.setOrderId(schemeId);
						schemeInfo2.setObjId(ssc.getPackId());
						schemeInfo2.setObjType("ssc_scheme_pack_ext");
						schemeInfo2.setExtInfo(listinfos2);
						listadd.add(schemeInfo2);
						SscExtObjInfo deletePackExtInfo = new SscExtObjInfo();
						deletePackExtInfo.setObjType("ssc_scheme_pack_ext");
						deletePackExtInfo.setOrderId(schemeId);
						deletePackExtInfo.setObjId(ssc.getPackId());
						deletePackExtInfo.setExtInfo(listinfos2);
						deleteExtObjInfoList.add(deletePackExtInfo);
					}

					if ("集采实施-自营".equals(reqBO.getSchemeSubmitType())) {
						List<SscExtInfo> listExtInfos = new ArrayList<>();
						SscExtInfo ExtInfo1 = new SscExtInfo();
						ExtInfo1.setFieldCode("purchaseUserId");
						ExtInfo1.setFieldName("采购员Id");
						ExtInfo1.setFieldValue(reqBO.getImplId() + "");
						SscExtInfo ExtInfo2 = new SscExtInfo();
						ExtInfo2.setFieldCode("purchaseUserCode");
						ExtInfo2.setFieldName("采购员编码");
						ExtInfo2.setFieldValue(reqBO.getImplCode());
						SscExtInfo ExtInfo3 = new SscExtInfo();
						ExtInfo3.setFieldCode("purchaseUserName");
						ExtInfo3.setFieldName("采购员名称");
						ExtInfo3.setFieldValue(reqBO.getImplName());
						listExtInfos.add(ExtInfo1);
						listExtInfos.add(ExtInfo2);
						listExtInfos.add(ExtInfo3);

						SscExtObjInfo schemeExtInfo2 = new SscExtObjInfo();
						schemeExtInfo2.setObjType("ssc_scheme_ext");
						schemeExtInfo2.setOrderId(schemeId);
						schemeExtInfo2.setObjId(schemeId);
						schemeExtInfo2.setExtInfo(listExtInfos);
						listadd.add(schemeExtInfo2);

						// 判断是否有采购包信息
						if (qrySchemeDetail != null && qrySchemeDetail.getSscQrySchemeDetailBO() != null
								&& !CollectionUtils
										.isEmpty(qrySchemeDetail.getSscQrySchemeDetailBO().getSscSchemePack())) {
							PackBOList = new ArrayList<>();
							SscSchemePackBO bo = null;
							for (SscSchemePackBO ssc : qrySchemeDetail.getSscQrySchemeDetailBO().getSscSchemePack()) {
								SscExtObjInfo schemeExtInfo = new SscExtObjInfo();
								schemeExtInfo.setObjType("ssc_scheme_pack_ext");
								schemeExtInfo.setOrderId(schemeId);
								schemeExtInfo.setObjId(ssc.getPackId());
								schemeExtInfo.setExtInfo(listExtInfos);
								listadd.add(schemeExtInfo);

								// 存储 修改采购包寻源人
								bo = new SscSchemePackBO();
								bo.setPackId(ssc.getPackId());
								bo.setSchemeId(schemeId);
								bo.setImplCode(reqBO.getImplCode());
								bo.setImplId(reqBO.getImplId());
								bo.setImplName(reqBO.getImplName());
								// 03 是还没有生成方案 04 是已经生成 方案
								bo.setPackStatus("03");
								PackBOList.add(bo);
							}
						}


					} else if ("企业自采".equals(reqBO.getSchemeSubmitType())) {
						SscExtObjInfo schemeInfo = new SscExtObjInfo();
						schemeInfo.setOrderId(schemeId);
						schemeInfo.setObjId(schemeId);
						schemeInfo.setObjType("ssc_scheme_ext");

						List<SscExtInfo> listinfos = new ArrayList<>();
						SscExtInfo info4 = new SscExtInfo();
						info4.setFieldCode("agencyFlag");
						info4.setFieldName("是否非招代理");
						info4.setFieldValue(reqBO.getAgencyFlag());
						listinfos.add(info4);

						schemeInfo.setExtInfo(listinfos);
						listupdate.add(schemeInfo);
					}

				}
				//先删除方案上的采购员信息
				{
					//先删除方案上的采购员信息
					SscCommonDo deleteSscCommonDo = new SscCommonDo();



					SscExtObjInfo deleteSchemeExtInfo = new SscExtObjInfo();
					deleteSchemeExtInfo.setObjType("ssc_scheme_ext");
					deleteSchemeExtInfo.setOrderId(schemeId);
					deleteSchemeExtInfo.setObjId(schemeId);

					SscExtObjInfo deletePackExtInfo2 = new SscExtObjInfo();
					deletePackExtInfo2.setObjType("ssc_scheme_pack_ext");
					deletePackExtInfo2.setOrderId(schemeId);
					deletePackExtInfo2.setObjId(schemeId);

					List<SscExtInfo> deleteSchemeExtInfoList = new ArrayList<>();

					SscExtInfo deleteSchemeExtInfo1 = new SscExtInfo();
					deleteSchemeExtInfo1.setFieldCode("purchaseUserId");
					deleteSchemeExtInfoList.add(deleteSchemeExtInfo1);

					SscExtInfo deleteSchemeExtInfo2 = new SscExtInfo();
					deleteSchemeExtInfo2.setFieldCode("purchaseUserCode");
					deleteSchemeExtInfoList.add(deleteSchemeExtInfo2);

					SscExtInfo deleteSchemeExtInfo3 = new SscExtInfo();
					deleteSchemeExtInfo3.setFieldCode("purchaseUserName");
					deleteSchemeExtInfoList.add(deleteSchemeExtInfo3);

					deleteSchemeExtInfo.setExtInfo(deleteSchemeExtInfoList);

					deletePackExtInfo2.setExtInfo(deleteSchemeExtInfoList);

					deleteExtObjInfoList.add(deleteSchemeExtInfo);
					deleteExtObjInfoList.add(deletePackExtInfo2);

					deleteSscCommonDo.setExtObjInfos(deleteExtObjInfoList);

					iSscCommonModel.deleteExtInfo(deleteSscCommonDo);

				}
				sscCommonDoupdate.setExtObjInfos(listupdate);
				sscCommonDoadd.setExtObjInfos(listadd);
				if (!CollectionUtils.isEmpty(listadd)) {
					iSscCommonModel.addExtInfo(sscCommonDoadd);
				}
				if (!CollectionUtils.isEmpty(listupdate)) {
					iSscCommonModel.updateExtInfo(sscCommonDoupdate);
				}
				if (PackBOList != null) {
					SscUpdatePackMainBatchReqBO sscUpdatePackMainBatchReqBO = new SscUpdatePackMainBatchReqBO();
					sscUpdatePackMainBatchReqBO.setSscSchemePack(PackBOList);
					sscUpdatePackMainBatchService.updateSchemeBatchMain(sscUpdatePackMainBatchReqBO);
				}
				//调换一下位置让包的信息能同步到es中
				// 修改方案主表
				SscUpdateSchemeMainReqBO sscUpdateSchemeMainReqBO = new SscUpdateSchemeMainReqBO();
				sscUpdateSchemeMainReqBO.setSchemeId(schemeId);
				sscUpdateSchemeMainReqBO.setRemark(reqBO.getRemark());
				sscUpdateSchemeMainService.updateSchemeMain(sscUpdateSchemeMainReqBO);
			}
		}
		log.info("---------------------方案分配完成----------------------");
		rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
		rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
		return rspBO;
	}
}
