package com.tydic.dyc.ssc.service.scheme;

import com.tydic.dyc.ssc.model.ISscSchemeExtModel;
import com.tydic.dyc.ssc.model.SscSchemeExtDo;
import com.tydic.dyc.ssc.service.scheme.bo.ExportEsaySchemeAndMatBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeMainInfoExtBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeMainInfoExtReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeMainInfoExtRspBO;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * @Description: SscQrySchemeMainInfoListExtServiceImpl
 * @Author: the_xhl
 * @Date: 2023-03-30
 */
@HTServiceImpl
public class SscQrySchemeMainInfoListExtServiceImpl implements SscQrySchemeMainInfoListExtService {

    @Autowired
    private ISscSchemeExtModel sscSchemeExtModel;

    @Override
    public SscQrySchemeMainInfoExtRspBO qrySchemeMainInfoList(SscQrySchemeMainInfoExtReqBO reqBO) {
        SscQrySchemeMainInfoExtRspBO rspBO = SscRu.success(SscQrySchemeMainInfoExtRspBO.class);
        List<SscSchemeExtDo> mainInfoList = sscSchemeExtModel.qrySchemeMainInfoList(SscRu.js(reqBO, SscSchemeExtDo.class));
        rspBO.setSscQrySchemeMainInfoList(SscRu.jsl(mainInfoList, SscQrySchemeMainInfoExtBO.class));
        return rspBO;
    }

    @Override
    public List<ExportEsaySchemeAndMatBO> selectEsaySchemeAndMat(List<Long> schemeIds) {
        return sscSchemeExtModel.selectEsaySchemeAndMat(schemeIds);
    }
}
