package com.tydic.dyc.ssc.service.scheme;

import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemePackExtReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemePackExtRspBO;
import com.tydic.dyc.ssc.service.scheme.constant.RspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

/**
 * 描述:
 *
 * @author XiaWD
 * @date 2023/4/13 15:46
 * @Copyright: 2022 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于深圳天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目
 */
@HTServiceImpl
public class SscQrySchemePackExtServieImpl implements SscQrySchemePackExtServie {
    @Autowired
    private SscQrySchemePackExtModel sscQrySchemePackExtModel;
    @Override
    public SscQrySchemePackExtRspBO qryPackBySchemeIds(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();

        if (CollectionUtils.isEmpty(reqBO.getSchemeIds())){
            rspBO.setRespCode(RspConstant.RESP_CODE_ERROR);
            rspBO.setRespDesc("入参方案ids 不能为空");
            return rspBO;
        }
        return sscQrySchemePackExtModel.qryPackBySchemeIds(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO qrySchemeExect(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.qrySchemeExect(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO qryPackByPackIds(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.qryPackByPackIds(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO updateSchemePackImplCodeExect(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.updateSchemePackImplCodeExect(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO updatePackPackStatus(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.updatePackPackStatus(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO qrySchemeExist(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.qrySchemeExist(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO syncAddPackByPackIds(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO syncDeletePackByPackIds(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO qrySchemeAuditProclnstld(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.qrySchemeAuditProclnstld(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO qryPackStatusBySchemeIdsOrpackIds(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.qryPackStatusBySchemeIdsOrpackIds(reqBO);
    }


}
