package com.tydic.dyc.ssc.model.scheme.impl;

import com.tydic.dyc.ssc.model.SscSchemeMatListCrcResultExtModel;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscSchemeMatCrcResultListExtReqBO;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscSchemeMatCrcResultListExtRspBO;
import com.tydic.dyc.ssc.repository.SscSchemeMatListCrcResultExtRepository;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 标题：采购方案询源结果列表模型层接口实现类
 * 时间：2023/08/13
 */
@Slf4j
@Service
public class SscSchemeMatListCrcResultExtModelImpl implements SscSchemeMatListCrcResultExtModel {

    /**
     * 采购方案询源结果列表基建层接口
     */
    @Autowired
    SscSchemeMatListCrcResultExtRepository sscSchemeMatListCrcResultExtRepository;

    /**
     * 通过询源结果查询采购方案明细列表
     */
    @Override
    public SscSchemeMatCrcResultListExtRspBO getSchemeMatListByCrcResult(SscSchemeMatCrcResultListExtReqBO reqBO) {
        //调用采购方案询比结果列表基建层接口，通过询比结果查询采购方案明细列表
        return this.sscSchemeMatListCrcResultExtRepository.getSchemeMatListByCrcResult(reqBO);
    }
}
