package com.tydic.dyc.ssc.model.scheme.impl;

import com.tydic.dyc.ssc.model.SscSchemeMatPackExtModel;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscSchemeMatListQueryExtReqBO;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscSchemeMatListQueryExtRspBO;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscSchemeMatQryExtReqBO;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscSchemeMatQryExtRspBO;
import com.tydic.dyc.ssc.repository.SscSchemeMatPackExtRepository;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 标题：采购方案明细模型层实现类
 * 时间：2023/07/24
 */
@Slf4j
@Service
public class SscSchemeMatPackExtModelImpl implements SscSchemeMatPackExtModel {

    /**
     * 采购方案明细基建层
     */
    @Autowired
    SscSchemeMatPackExtRepository sscSchemeMatPackExtRepository;

    /**
     * 采购方案明细分页查询
     */
    @Override
    public SscSchemeMatListQueryExtRspBO querySchemeMatList(SscSchemeMatListQueryExtReqBO reqBO) {
        //调用采购方案明细基建层，采购方案明细分页查询
        return this.sscSchemeMatPackExtRepository.querySchemeMatList(reqBO);
    }

    /**
     * 采购方案明细列表分页查询
     */
    @Override
    public SscSchemeMatQryExtRspBO querySchemeMatListPage(SscSchemeMatQryExtReqBO reqBO) {
        //调用采购方案明细基建层，采购方案明细列表分页查询
        return this.sscSchemeMatPackExtRepository.querySchemeMatListPage(reqBO);
    }
}
