package com.tydic.dyc.ssc.model.scheme.qrybo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题：采购方案明细分页查询 BO
 * 时间：2023/07/25
 */
@Data
public class SscSchemeMatListQueryExtBO implements Serializable {
    private static final long serialVersionUID = 3743513969953729184L;

    /**
     * 方案id
     */
    private Long schemeId;

    /**
     * 方案编码
     */
    private String schemeCode;

    /**
     * 方案名称
     */
    private String schemeName;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 方案类别
     */
    private Integer schemeClass;

    /**
     * 方案类别翻译
     */
    private String schemeClassStr;

    /**
     * 方案类型
     */
    private String schemeType;

    /**
     * 采购方式
     */
    private Integer purchaseType;

    /**
     * 标段ID
     */
    private Long packId;

    /**
     * 执行人编码
     */
    private String implCode;

    /**
     * 执行人名称
     */
    private String implName;

    /**
     * 包编码
     */
    private String packCode;

    /**
     * 包名称
     */
    private String packName;

    /**
     * 方案物料ID
     */
    private Long schemeMatId;

    /**
     * 申报单位编码
     */
    private String declareUnitCode;

    /**
     * 申报单位名称
     */
    private String declareUnitName;

    /**
     * 计划编号
     */
    private String planCode;

    /**
     * 物料编码
     */
    private String matCode;

    /**
     * 物料名称
     */
    private String matName;

    /**
     * 申报单位ID
     */
    private Long declareUnitId;

    /**
     * 计量单位名称
     */
    private String measureUnitName;

    /**
     * 采购数量
     */
    private BigDecimal purchaseNum;

    /**
     * 税率
     */
    private BigDecimal taxRate;

    /**
     * 含税单价
     */
    private BigDecimal taxPrice;

    /**
     * 含税金额
     */
    private BigDecimal totalTaxPrice;

    /**
     * 不含税单价
     */
    private BigDecimal noTaxPrice;

    /**
     * 不含税金额
     */
    private BigDecimal totalNoTaxPrice;

    /**
     * 交货时间
     */
    private Date deliveryDate;

    /**
     * 备注
     */
    private String remark;

    /**
     * 计划ID
     */
    private Long planId;

    /**
     * 审核时间
     */
    private Date auditTime;

    /**
     * 剩余数量
     */
    private BigDecimal remainingNum;

    /**
     * 合同剩余数量
     */
    private BigDecimal contractRemainingNum;

    /**
     * 订单剩余数量
     */
    private BigDecimal orderRemainingNum;

    /**
     * 创建人名称
     */
    private String createName;

    /**
     * 创建人用户名
     */
    private String createUsername;

    /**
     * 采购方案明细扩展 BO
     */
    List<SscSchemeMatExtPackExtBO> schemeMatExtPackExtFields;

    /**
     * 采购方案供应商 BO
     */
    List<SscSchemeInviteSupPackExtBO> schemeInviteSupPackExtBOList;

}
