package com.tydic.dyc.ssc.repository;

import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemePackExtReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemePackExtRspBO;

/**
 * 描述:
 *
 * @author XiaWD
 * @date 2023/4/13 15:51
 * @Copyright: 2022 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于深圳天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目
 */
public interface SscQrySchemePackExtRepository {
    SscQrySchemePackExtRspBO qryPackBySchemeIds(SscQrySchemePackExtReqBO reqBO);
    SscQrySchemePackExtRspBO qrySchemeExect(SscQrySchemePackExtReqBO reqBO);
    /**
     * 根据方案ids 查询包信息
     * @param reqBO
     * @return
     */
    SscQrySchemePackExtRspBO qryPackByPackIds(SscQrySchemePackExtReqBO reqBO);
    /**
     * 根据包Ids 清空 包的 采购员信息
     * @param reqBO
     * @return
     */
    SscQrySchemePackExtRspBO updateSchemePackImplCodeExect(SscQrySchemePackExtReqBO reqBO);
    /**
     * 根据方案ids 修改包的执行状态
     * @param reqBO
     * @return
     */
    SscQrySchemePackExtRspBO updatePackPackStatus(SscQrySchemePackExtReqBO reqBO);
    /**
     * 根据方案id 查询方案是否存在
     * @param reqBO
     * @return
     */
    SscQrySchemePackExtRspBO qrySchemeExist(SscQrySchemePackExtReqBO reqBO);
    /**
     * 根据方案ids 查询最新的实例id
     * @param reqBO
     * @return
     */
    SscQrySchemePackExtRspBO qrySchemeAuditProclnstld(SscQrySchemePackExtReqBO reqBO);
    /**
     * 根据方案ids 或者 方案ids 查询包的执行状态 或者 方案的执行状态
     * @param reqBO
     * @return
     */
    SscQrySchemePackExtRspBO qryPackStatusBySchemeIdsOrpackIds(SscQrySchemePackExtReqBO reqBO);
    /**
     * 采购包管理 给包进行分配
     * @param reqBO
     * @return
     */
    SscQrySchemePackExtRspBO updatePackageAllocation(SscQrySchemePackExtReqBO reqBO);
    /**
     * 根据方案id 清空方案的执行状态
     * @param reqBO
     * @return
     */
    SscQrySchemePackExtRspBO updateClearSchemeSchemeExectStatus(SscQrySchemePackExtReqBO reqBO);
    /**
     * 根据方案ids 查询非招主键ids
     * @param reqBO
     * @return
     */
    SscQrySchemePackExtRspBO qryNonRecruitmentIdBySchemeIds(SscQrySchemePackExtReqBO reqBO);
    /**
     * 根据方案ids  推送非招同步状态
     * @param reqBO
     * @return
     */
    SscQrySchemePackExtRspBO syncPushStatus(SscQrySchemePackExtReqBO reqBO);
    /**
     * 根据方案ids  推送招标同步状态
     * @param reqBO
     * @return
     */
    SscQrySchemePackExtRspBO syncPackPushStatus(SscQrySchemePackExtReqBO reqBO);

    /**
     * 根据方案ids  查询非招同步状态（不同类型的推送最新的一条）
     * @param reqBO
     * @return
     */
    SscQrySchemePackExtRspBO qryPushStatus(SscQrySchemePackExtReqBO reqBO);
    /**
     * 根据方案ids  查询非招同步状态（不同类型的推送最新的一条）
     * @param reqBO
     * @return
     */
    SscQrySchemePackExtRspBO qryPackPushStatus(SscQrySchemePackExtReqBO reqBO);
    /**
     * 根据计划id 修改 通用物料编码
     * @param reqBO
     * @return
     */
    SscQrySchemePackExtRspBO updateCommonItemNo(SscQrySchemePackExtReqBO reqBO);
    /**
     * 增加[采购方案编号]、[集采方案编号] 、[简易采购计划编号] 校验是否重复接口
     * @param reqBO
     * @return
     */
    SscQrySchemePackExtRspBO verifySchemeNo(SscQrySchemePackExtReqBO reqBO);
    /**
     * 增加[采购方案编号]、[集采方案编号] 、[简易采购计划编号] 校验是否重复接口
     * 这里是包的角度去修改
     * @param reqBO
     * @return
     */
    SscQrySchemePackExtRspBO updatePackImplCodeDefault(SscQrySchemePackExtReqBO reqBO);
    /**
     * 根据方案id 查询计划物资明细数据，这个接口为了同步方案量
     * @param reqBO
     * @return
     */
    SscQrySchemePackExtRspBO qryPlanMatBySchemeId(SscQrySchemePackExtReqBO reqBO);
    /**
     * 采购方案和集采方案查询包的预算金额总和
     * @param reqBO
     * @return
     */
    SscQrySchemePackExtRspBO qryTotalExpectMoneySum(SscQrySchemePackExtReqBO reqBO);
    /**
     * 方案明细批量设置服务	(根据税率修改 预算含税单价，预算含税金额，)
     * @param reqBO
     * @return
     */
    SscQrySchemePackExtRspBO updateSchemeMatNullValueBatch(SscQrySchemePackExtReqBO reqBO);
    /**
     * 删除草稿表包的对应所有供应商
     * @param reqBO
     * @return
     */
    SscQrySchemePackExtRspBO deleteAllInviteSupDraft(SscQrySchemePackExtReqBO reqBO);
    /**
     * 根据方案ids 清空 包的 assignStatus 分配状态
     * @param reqBO
     * @return
     */
    SscQrySchemePackExtRspBO updateSchemePackAssignStatusExect(SscQrySchemePackExtReqBO reqBO);
    /**
     * 根据方案ids 查询方案的分交方式和版本号
     * @param reqBO
     * @return
     */
    SscQrySchemePackExtRspBO qrySchemeSubmitType(SscQrySchemePackExtReqBO reqBO);
    /**
     * 新增方案变更记录日志
     * @param reqBO
     * @return
     */
    SscQrySchemePackExtRspBO addChangeDistributionModeLog(SscQrySchemePackExtReqBO reqBO);
    /**
     * 分交方式变更记录查询接口
     * @param reqBO
     * @return
     */
    SscQrySchemePackExtRspBO qryChangeDistributionModeLogList(SscQrySchemePackExtReqBO reqBO);
    /**
     * 采购方案判断分交方式是否有修改记录
     * @param reqBO
     * @return
     */
    SscQrySchemePackExtRspBO qryIsExistChangeDistributionModeLog(SscQrySchemePackExtReqBO reqBO);
    /**
     * 根据包ids 查询方案的创建时间 和 是否委托
     * @param reqBO
     * @return
     */
    SscQrySchemePackExtRspBO qrySchemeOrganizationFormByPackIds(SscQrySchemePackExtReqBO reqBO);
    /**
     * 根据方案id 修改方案说明字段为空
     * @param reqBO
     * @return
     */
    SscQrySchemePackExtRspBO updateSchemeNullField(SscQrySchemePackExtReqBO reqBO);
    /**
     * 新增方案依据附件
     * @param reqBO
     * @return
     */
    SscQrySchemePackExtRspBO addBasisFile(SscQrySchemePackExtReqBO reqBO);
    /**
     * 新增方案依据生成失败记录
     * @param reqBO
     * @return
     */
    SscQrySchemePackExtRspBO addBasisFileBuildFail(SscQrySchemePackExtReqBO reqBO);
    /**
     * 修改方案依据生成失败记录
     * @param reqBO
     * @return
     */
    SscQrySchemePackExtRspBO updateBasisFileBuildFail(SscQrySchemePackExtReqBO reqBO);
    /**
     * 查询方案依据生成失败记录
     * @param reqBO
     * @return
     */
    SscQrySchemePackExtRspBO qryBasisFileBuildFail(SscQrySchemePackExtReqBO reqBO);
    /**
     * 查询方案依据生初始化表
     * @param reqBO
     * @return
     */
    SscQrySchemePackExtRspBO qryBasisFileInit(SscQrySchemePackExtReqBO reqBO);
    /**
     * 修改方案依据生初始化表
     * @param reqBO
     * @return
     */
    SscQrySchemePackExtRspBO updateBasisFileInit(SscQrySchemePackExtReqBO reqBO);
    /**
     * 查询方案依据表
     * @param reqBO
     * @return
     */
    SscQrySchemePackExtRspBO qryBasisFileList(SscQrySchemePackExtReqBO reqBO);
    /**
     * 简易计划根据方案ids 查询寻源人信息
     * @param reqBO
     * @return
     */
    SscQrySchemePackExtRspBO qryImplInfoBySchemeIds(SscQrySchemePackExtReqBO reqBO);
    /**
     * 增加加签记录
     * @param reqBO
     * @return
     */
    SscQrySchemePackExtRspBO addJoinSignLogBOS(SscQrySchemePackExtReqBO reqBO);

    /**
     * 查询加签记录
     * @param reqBO
     * @return
     */
    SscQrySchemePackExtRspBO qryJoinSignLogBOS(SscQrySchemePackExtReqBO reqBO);
}
