package com.tydic.dyc.ssc.service.scheme;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.ssc.repository.QrySchemeServiceRepository;
import com.tydic.dyc.ssc.repository.QrySchememPackServiceRepository;
import com.tydic.dyc.ssc.service.scheme.bo.*;
import com.tydic.dyc.ssc.service.scheme.constant.RspConstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import com.tydic.dyc.ssc.model.common.ISscCommonModel;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.model.common.sub.SscExtInfo;
import com.tydic.dyc.ssc.model.common.sub.SscExtObjInfo;

import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.ohaotian.HTServiceRef;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.StringUtils;

/**
 * 方案相关接口
 * @author lj
 * @Version 1.0.0
 * @date 2023/3/17
 **/
@HTServiceImpl
@Slf4j
public class QrySchemeServiceImpl implements QrySchemeService {
	@Autowired
	private ISscCommonModel iSscCommonModel;
	@HTServiceRef
	private SscUpdatePackMainBatchService sscUpdatePackMainBatchService;
	@HTServiceRef
	private SscUpdateSchemeMainService sscUpdateSchemeMainService;
	@HTServiceRef
	private SscQrySchemeDetailService sscQrySchemeDetailService;
	@Autowired
	private SscQrySchemePackExtModel sscQrySchemePackExtModel;
	@Autowired
	private QrySchemeServiceRepository qrySchemeServiceRepository;
	@Autowired
	private QrySchememPackServiceRepository qrySchememPackServiceRepository;
	@Override
	public SscSchemeAndPacQryListRspBO listSchemeByParam(PurchaseSchemeReqBO reqBO) {
		log.info("QrySchemeService listSchemeByParam param:{}", JSON.toJSONString(reqBO));
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		SscSchemeAndPacQryListRspBO rspBO = new SscSchemeAndPacQryListRspBO();
		rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
		try {
			String errorMsg = checkParam(reqBO).get(Boolean.FALSE);
			if(!StringUtils.isEmpty(errorMsg)){
				rspBO.setRespCode(RspConstant.RESP_CODE_ERROR);
				rspBO.setRespDesc(errorMsg);
				return rspBO;
			}
			//查询采购方案信息
			SscQrySchemeMainInfoExtBO inparam = new SscQrySchemeMainInfoExtBO();
			inparam.setCreateTime(sdf.parse(reqBO.getBeginTime()));
			inparam.setUpdateTime(sdf.parse(reqBO.getEndTime()));
			inparam.setCreateOrgCode(reqBO.getCreateOrgCode());
			inparam.setSchemeAuditStatus(reqBO.getSchemeAuditStatus());
			List<SscQryPlanPackBO> sscQryPlanPackBOS = qrySchemeServiceRepository.listByParam(inparam);
			log.info("PurchaseSchemeController listSchemeByParam sscQryPlanPackBOS:{}",JSON.toJSONString(sscQryPlanPackBOS));
			if(CollectionUtils.isEmpty(sscQryPlanPackBOS)){
				return rspBO;
			}
			List<Long> schemeIds = sscQryPlanPackBOS.stream().map(SscQryPlanPackBO::getSchemeId).collect(Collectors.toList());
			inparam.setSchemeIdList(schemeIds);
			List<SscSchemePackBO> sscSchemePackBOS = qrySchememPackServiceRepository.listByParam(inparam);
			log.info("PurchaseSchemeController listSchemeByParam sscSchemePackBOS:{}",JSON.toJSONString(sscSchemePackBOS));

			rspBO.setSchemeList(BoToVo(sscQryPlanPackBOS,sscSchemePackBOS));
		} catch (Exception e) {
			log.error("PurchaseSchemeController listSchemeByParam exception:{}", e);
			rspBO.setRespCode(RspConstant.RESP_CODE_ERROR);
			rspBO.setRespDesc(RspConstant.RESP_DESC_ERROR);
			return rspBO;
		}
		return rspBO;
	}

	private List<PurchaseSchemeRspBO> BoToVo(List<SscQryPlanPackBO> sscQryPlanPackBOS, List<SscSchemePackBO> sscSchemePackBOS){
		if(CollectionUtils.isEmpty(sscQryPlanPackBOS)){
			return null;
		}
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		Map<Long, List<SscSchemePackBO>> collect = sscSchemePackBOS.stream()
				.collect(Collectors.groupingBy(SscSchemePackBO::getSchemeId));

		List<PurchaseSchemeRspBO> list = new ArrayList<>();
		for (int i = 0; i < sscQryPlanPackBOS.size(); i++) {
			SscQryPlanPackBO sscQryPlanPackBO = sscQryPlanPackBOS.get(i);
			List<SscSchemePackBO> sscSchemePackBOS1 = collect.get(sscQryPlanPackBO.getSchemeId());
			if(CollectionUtils.isEmpty(sscSchemePackBOS1)){
				continue;
			}
			PurchaseSchemeRspBO purchaseSchemeVO = new PurchaseSchemeRspBO();
			//组装头数据
			purchaseSchemeVO.setSchemeCode(sscQryPlanPackBO.getSchemeCode());
			purchaseSchemeVO.setSchemeName(sscQryPlanPackBO.getSchemeName());
			purchaseSchemeVO.setCreateCompanyCode(sscQryPlanPackBO.getCreateCompanCode());
			purchaseSchemeVO.setCreateCompanyName(sscQryPlanPackBO.getCreateCompanyName());
			purchaseSchemeVO.setSchemeClass(translateSchemeClass(sscQryPlanPackBO.getSchemeClass()));
			if(!StringUtils.isEmpty(sscQryPlanPackBO.getImportFlag())){
				purchaseSchemeVO.setImportFlag(sscQryPlanPackBO.getImportFlag().equals("0")?"国产":"进口");
			}
			if(!StringUtils.isEmpty(sscQryPlanPackBO.getEmergencyFlag())){
				purchaseSchemeVO.setEmergencyFlag(sscQryPlanPackBO.getEmergencyFlag().equals("0")?"否":"是");
			}
			purchaseSchemeVO.setSchemeAuditStatus(sscQryPlanPackBO.getSchemeAuditStatus());
			if(Objects.nonNull(sscQryPlanPackBO.getCreateTime())){
				purchaseSchemeVO.setCreateTime(sdf.format(sscQryPlanPackBO.getCreateTime()));
			}
			//purchaseSchemeVO.setFinishTime(sscQryPlanPackBO.get);
			purchaseSchemeVO.setCreateUserCode(sscQryPlanPackBO.getCreateUsername());
			purchaseSchemeVO.setCreateUserName(sscQryPlanPackBO.getCreateName());
			purchaseSchemeVO.setCreateOrgCode(sscQryPlanPackBO.getCreateOrgCode());
			purchaseSchemeVO.setCreateOrgName(sscQryPlanPackBO.getCreateOrgName());

			//组装行数据
			List<PurchaseSchemePackRspBO> purchaseSchemePackVOList = new ArrayList<>();
			for (int j = 0; j < sscSchemePackBOS1.size(); j++) {
				SscSchemePackBO sscSchemePackBO = sscSchemePackBOS1.get(j);
				PurchaseSchemePackRspBO purchaseSchemePackVO = new PurchaseSchemePackRspBO();
				purchaseSchemePackVO.setPackId(sscSchemePackBO.getPackId().toString());
				purchaseSchemePackVO.setPackNo(sscSchemePackBO.getPackNo());
				purchaseSchemePackVO.setPackCode(sscSchemePackBO.getPackCode());
				purchaseSchemePackVO.setEstAmount(sscSchemePackBO.getEstAmount());
				purchaseSchemePackVO.setPackName(sscSchemePackBO.getPackName());
				purchaseSchemePackVOList.add(purchaseSchemePackVO);
			}
			purchaseSchemeVO.setPurchaseSchemePackVOList(purchaseSchemePackVOList);
			list.add(purchaseSchemeVO);
		}
		return list;
	}
	/**
	 * 方案类别 (0:工程 1:货物 2:服务 3:金属 4:非金属 5:设备 6:配件)
	 * @param type
	 * @return
	 */
	private String translateSchemeClass(String type){
		if(StringUtils.isEmpty(type)){
			return null;
		}
		String str = null;
		switch (type){
			case "0":
				str = "工程";
				break;
			case "1":
				str = "货物";
				break;
			case "2":
				str = "服务";
				break;
			case "3":
				str = "金属";
				break;
			case "4":
				str = "非金属";
				break;
			case "5":
				str = "设备";
				break;
			case "6":
				str = "配件";
				break;
		}
		return str;
	}
    private Map<Boolean, String> checkParam(PurchaseSchemeReqBO reqBO) {
        Map<Boolean, String> map = new HashMap<>();
        if (Objects.isNull(reqBO)) {
            map.put(Boolean.FALSE, "参数不能为空");
            return map;
        }
        if (StringUtils.isEmpty(reqBO.getBeginTime()) || StringUtils.isEmpty(reqBO.getEndTime())) {
            map.put(Boolean.FALSE, "起始时间不能为空");
            return map;
        }
        LocalDate begin = LocalDate.parse(reqBO.getBeginTime(), DateTimeFormatter.ISO_DATE);
        LocalDate end = LocalDate.parse(reqBO.getEndTime(), DateTimeFormatter.ISO_DATE);
        long monthsBetween = ChronoUnit.MONTHS.between(begin, end);
        if (monthsBetween > 1) {
            map.put(Boolean.FALSE, "起始时间不能大于一个月");
            return map;
        }
        return map;
    }

	// 方案分配服务
	/*@Override
	public SscSchemeAllocationExtRspBO updateSchemeExt(SscSchemeAllocationExtReqBO reqBO) {
		SscSchemeAllocationExtRspBO rspBO = new SscSchemeAllocationExtRspBO();
		// 当分交方式为集采实施-自营时，添加方案表和方案包扩展字段
		if ("集采实施-自营".equals(reqBO.getSchemeSubmitType())) {
			SscCommonDo sscCommonDo = new SscCommonDo();
			List<SscExtObjInfo> list = new ArrayList<>();
			for (Long schemeId : reqBO.getSchemeIds()) {
				SscExtObjInfo schemeInfo = new SscExtObjInfo();
				schemeInfo.setOrderId(schemeId);
				schemeInfo.setObjId(schemeId);
				schemeInfo.setObjType("ssc_scheme_ext");
				List<SscExtInfo> listinfos = new ArrayList<>();
				SscExtInfo info1 = new SscExtInfo();
				info1.setFieldCode("purchaseUserId");
				info1.setFieldName("采购员Id");
				info1.setFieldValue(reqBO.getImplId() + "");
				SscExtInfo info2 = new SscExtInfo();
				info2.setFieldCode("purchaseUserCode");
				info2.setFieldName("采购员编码");
				info2.setFieldValue(reqBO.getImplCode());
				SscExtInfo info3 = new SscExtInfo();
				info3.setFieldCode("purchaseUserName");
				info3.setFieldName("采购员名称");
				info3.setFieldValue(reqBO.getImplName());
	
				listinfos.add(info1);
				listinfos.add(info2);
				listinfos.add(info3);
	
				schemeInfo.setExtInfo(listinfos);
				list.add(schemeInfo);
	
				// 修改方案主表
				SscUpdateSchemeMainReqBO sscUpdateSchemeMainReqBO = new SscUpdateSchemeMainReqBO();
				sscUpdateSchemeMainReqBO.setSchemeId(schemeId);
				sscUpdateSchemeMainReqBO.setImplId(reqBO.getImplId());
				sscUpdateSchemeMainReqBO.setImplCode(reqBO.getImplCode());
				sscUpdateSchemeMainReqBO.setImplName(reqBO.getImplName());
				sscUpdateSchemeMainReqBO.setRemark(reqBO.getRemark());
				sscUpdateSchemeMainService.updateSchemeMain(sscUpdateSchemeMainReqBO);
	
				SscQrySchemeDetailReqBO sscQrySchemeDetailReqBO = new SscQrySchemeDetailReqBO();
				sscQrySchemeDetailReqBO.setEnableDraft(false);
				sscQrySchemeDetailReqBO.setSchemeId(schemeId);
				SscQrySchemeDetailRspBO qrySchemeDetail = sscQrySchemeDetailService
						.qrySchemeDetail(sscQrySchemeDetailReqBO);
				List<SscSchemePackBO> PackBOList = null;
				if (qrySchemeDetail != null && qrySchemeDetail.getSscQrySchemeDetailBO() != null
						&& !CollectionUtils.isEmpty(qrySchemeDetail.getSscQrySchemeDetailBO().getSscSchemePack())) {
					List<SscExtInfo> listExtInfos = new ArrayList<>();
					SscExtInfo ExtInfo1 = new SscExtInfo();
					ExtInfo1.setFieldCode("purchaseUserId");
					ExtInfo1.setFieldName("采购员Id");
					ExtInfo1.setFieldValue(reqBO.getImplId() + "");
					SscExtInfo ExtInfo2 = new SscExtInfo();
					ExtInfo2.setFieldCode("purchaseUserCode");
					ExtInfo2.setFieldName("采购员编码");
					ExtInfo2.setFieldValue(reqBO.getImplCode());
					SscExtInfo ExtInfo3 = new SscExtInfo();
					ExtInfo3.setFieldCode("purchaseUserName");
					ExtInfo3.setFieldName("采购员名称");
					ExtInfo3.setFieldValue(reqBO.getImplName());
					listExtInfos.add(ExtInfo1);
					listExtInfos.add(ExtInfo2);
					listExtInfos.add(ExtInfo3);
	
					PackBOList = new ArrayList<>();
					SscSchemePackBO bo = null;
					for (SscSchemePackBO ssc : qrySchemeDetail.getSscQrySchemeDetailBO().getSscSchemePack()) {
						SscExtObjInfo schemeExtInfo = new SscExtObjInfo();
						schemeExtInfo.setObjType("ssc_scheme_pack_ext");
						schemeExtInfo.setOrderId(schemeId);
						schemeExtInfo.setObjId(ssc.getPackId());
						schemeExtInfo.setExtInfo(listExtInfos);
						list.add(schemeExtInfo);
	
						bo = new SscSchemePackBO();
						bo.setPackId(ssc.getPackId());
						bo.setSchemeId(schemeId);
						bo.setImplCode(reqBO.getImplCode());
						bo.setImplId(reqBO.getImplId());
						bo.setImplName(reqBO.getImplName());
						PackBOList.add(bo);
					}
				}
				if (PackBOList != null) {
					SscUpdatePackMainBatchReqBO sscUpdatePackMainBatchReqBO = new SscUpdatePackMainBatchReqBO();
					sscUpdatePackMainBatchReqBO.setSscSchemePack(PackBOList);
					sscUpdatePackMainBatchService.updateSchemeBatchMain(sscUpdatePackMainBatchReqBO);
				}
			}
			sscCommonDo.setExtObjInfos(list);
			iSscCommonModel.addExtInfo(sscCommonDo);
		} else if ("企业自采".equals(reqBO.getSchemeSubmitType())) {
			SscCommonDo sscCommonDo = new SscCommonDo();
			List<SscExtObjInfo> list = new ArrayList<>();
			for (Long schemeId : reqBO.getSchemeIds()) {
				SscExtObjInfo schemeInfo = new SscExtObjInfo();
				schemeInfo.setOrderId(schemeId);
				schemeInfo.setObjId(schemeId);
				List<SscExtInfo> listinfos = new ArrayList<>();
				schemeInfo.setObjType("ssc_scheme_ext");
				SscExtInfo info4 = new SscExtInfo();
				info4.setFieldCode("agencyFlag");
				info4.setFieldName("是否非招代理");
				info4.setFieldValue(reqBO.getAgencyFlag());
				listinfos.add(info4);
				
				schemeInfo.setExtInfo(listinfos);
				list.add(schemeInfo);
			}
			sscCommonDo.setExtObjInfos(list);
			iSscCommonModel.updateExtInfo(sscCommonDo);
		}
		// 修改分配方式状态和
		SscCommonDo sscCommonDo = new SscCommonDo();
		log.info("---------------------方案分配进行分交方式----------------------");
		List<SscExtObjInfo> list = new ArrayList<>();
		for (Long schemeId : reqBO.getSchemeIds()) {
			SscExtObjInfo schemeInfo = new SscExtObjInfo();
			schemeInfo.setOrderId(schemeId);
			schemeInfo.setObjId(schemeId);
			schemeInfo.setObjType("ssc_scheme_ext");
			List<SscExtInfo> listinfos = new ArrayList<>();
			SscExtInfo info1 = new SscExtInfo();
			info1.setFieldCode("schemeSubmitType");
			info1.setFieldName("方案分交方式");
			info1.setFieldValue(reqBO.getSchemeSubmitType());
			SscExtInfo info2 = new SscExtInfo();
			info2.setFieldCode("assignStatus");
			info2.setFieldName("分配状态");
			info2.setFieldValue("已分配");
			listinfos.add(info1);
			listinfos.add(info2);
			schemeInfo.setExtInfo(listinfos);
			list.add(schemeInfo);
			// 修改方案主表
			SscUpdateSchemeMainReqBO sscUpdateSchemeMainReqBO = new SscUpdateSchemeMainReqBO();
			sscUpdateSchemeMainReqBO.setSchemeId(schemeId);
			sscUpdateSchemeMainReqBO.setRemark(reqBO.getRemark());
			sscUpdateSchemeMainService.updateSchemeMain(sscUpdateSchemeMainReqBO);
		}
		sscCommonDo.setExtObjInfos(list);
		iSscCommonModel.updateExtInfo(sscCommonDo);
		log.info("---------------------方案分配完成----------------------");
		return rspBO;
	}*/

	@Override
	public SscSchemeAllocationExtRspBO updateSchemeExt(SscSchemeAllocationExtReqBO reqBO) {
		SscSchemeAllocationExtRspBO rspBO = new SscSchemeAllocationExtRspBO();

		//把 寻源人、寻源人编码 置为空 的包ids
		List<Long> clearPackIds = new ArrayList<>();
		if (reqBO != null && !CollectionUtils.isEmpty(reqBO.getSchemeIds())) {


			for (Long schemeId : reqBO.getSchemeIds()) {
				SscCommonDo sscCommonDoupdate = new SscCommonDo();
				SscCommonDo sscCommonDoadd = new SscCommonDo();
				List<SscExtObjInfo> listupdate = new ArrayList<>();
				List<SscExtObjInfo> listadd = new ArrayList<>();

				SscExtInfo info1 = new SscExtInfo();
				info1.setFieldCode("schemeSubmitType");
				info1.setFieldName("方案分交方式");
				info1.setFieldValue(reqBO.getSchemeSubmitType());

				SscExtInfo info2 = new SscExtInfo();
				info2.setFieldCode("assignStatus");
				info2.setFieldName("分配状态");
				info2.setFieldValue("已分配");
				List<SscExtInfo> listinfos1 = new ArrayList<>();
				listinfos1.add(info1);
				List<SscExtInfo> listinfos2 = new ArrayList<>();
				listinfos2.add(info2);
				SscExtObjInfo schemeInfo1 = new SscExtObjInfo();
				schemeInfo1.setOrderId(schemeId);
				schemeInfo1.setObjId(schemeId);
				schemeInfo1.setObjType("ssc_scheme_ext");
				schemeInfo1.setExtInfo(listinfos1);
				listupdate.add(schemeInfo1);



				// 通过方案id查询方案和方案包信息
				SscQrySchemeDetailReqBO sscQrySchemeDetailReqBO = new SscQrySchemeDetailReqBO();
				sscQrySchemeDetailReqBO.setEnableDraft(false);
				sscQrySchemeDetailReqBO.setSchemeId(schemeId);
				SscQrySchemeDetailRspBO qrySchemeDetail = sscQrySchemeDetailService
						.qrySchemeDetail(sscQrySchemeDetailReqBO);

				//新增之前先删除
				List<SscExtObjInfo> deleteExtObjInfoList = new ArrayList<>();

				List<SscSchemePackBO> PackBOList = null;
				// 判断是否有采购包信息
				if (qrySchemeDetail != null && qrySchemeDetail.getSscQrySchemeDetailBO() != null
						&& !CollectionUtils.isEmpty(qrySchemeDetail.getSscQrySchemeDetailBO().getSscSchemePack())) {
					
					for (SscSchemePackBO ssc : qrySchemeDetail.getSscQrySchemeDetailBO().getSscSchemePack()) {
						SscExtObjInfo schemeInfo2 = new SscExtObjInfo();
						schemeInfo2.setOrderId(schemeId);
						schemeInfo2.setObjId(ssc.getPackId());
						schemeInfo2.setObjType("ssc_scheme_pack_ext");
						schemeInfo2.setExtInfo(listinfos2);
						listadd.add(schemeInfo2);
						SscExtObjInfo deletePackExtInfo = new SscExtObjInfo();
						deletePackExtInfo.setObjType("ssc_scheme_pack_ext");
						deletePackExtInfo.setOrderId(schemeId);
						deletePackExtInfo.setObjId(ssc.getPackId());
						deletePackExtInfo.setExtInfo(listinfos2);
						deleteExtObjInfoList.add(deletePackExtInfo);
					}

					if ("集采实施-自营".equals(reqBO.getSchemeSubmitType())) {
						List<SscExtInfo> listExtInfos = new ArrayList<>();
						SscExtInfo ExtInfo1 = new SscExtInfo();
						ExtInfo1.setFieldCode("purchaseUserId");
						ExtInfo1.setFieldName("采购员Id");
						ExtInfo1.setFieldValue(reqBO.getImplId() + "");
						SscExtInfo ExtInfo2 = new SscExtInfo();
						ExtInfo2.setFieldCode("purchaseUserCode");
						ExtInfo2.setFieldName("采购员编码");
						ExtInfo2.setFieldValue(reqBO.getImplCode());
						SscExtInfo ExtInfo3 = new SscExtInfo();
						ExtInfo3.setFieldCode("purchaseUserName");
						ExtInfo3.setFieldName("采购员名称");
						ExtInfo3.setFieldValue(reqBO.getImplName());
						listExtInfos.add(ExtInfo1);
						listExtInfos.add(ExtInfo2);
						listExtInfos.add(ExtInfo3);

						SscExtObjInfo schemeExtInfo2 = new SscExtObjInfo();
						schemeExtInfo2.setObjType("ssc_scheme_ext");
						schemeExtInfo2.setOrderId(schemeId);
						schemeExtInfo2.setObjId(schemeId);
						schemeExtInfo2.setExtInfo(listExtInfos);
						listadd.add(schemeExtInfo2);

						// 判断是否有采购包信息
						if (qrySchemeDetail != null && qrySchemeDetail.getSscQrySchemeDetailBO() != null
								&& !CollectionUtils
										.isEmpty(qrySchemeDetail.getSscQrySchemeDetailBO().getSscSchemePack())) {
							PackBOList = new ArrayList<>();
							SscSchemePackBO bo = null;
							for (SscSchemePackBO ssc : qrySchemeDetail.getSscQrySchemeDetailBO().getSscSchemePack()) {
								SscExtObjInfo schemeExtInfo = new SscExtObjInfo();
								schemeExtInfo.setObjType("ssc_scheme_pack_ext");
								schemeExtInfo.setOrderId(schemeId);
								schemeExtInfo.setObjId(ssc.getPackId());
								schemeExtInfo.setExtInfo(listExtInfos);
								listadd.add(schemeExtInfo);

								// 存储 修改采购包寻源人
								bo = new SscSchemePackBO();
								bo.setPackId(ssc.getPackId());
								bo.setSchemeId(schemeId);
								bo.setImplCode(reqBO.getImplCode());
								bo.setImplId(reqBO.getImplId());
								bo.setImplName(reqBO.getImplName());
								// 03 是还没有生成方案 04 是已经生成 方案
								bo.setPackStatus("03");
								PackBOList.add(bo);
							}
						}


					} else if ("企业自采".equals(reqBO.getSchemeSubmitType())) {
						SscExtObjInfo schemeInfo = new SscExtObjInfo();
						schemeInfo.setOrderId(schemeId);
						schemeInfo.setObjId(schemeId);
						schemeInfo.setObjType("ssc_scheme_ext");

						List<SscExtInfo> listinfos = new ArrayList<>();
						SscExtInfo info4 = new SscExtInfo();
						info4.setFieldCode("agencyFlag");
						info4.setFieldName("是否非招代理");
						info4.setFieldValue(reqBO.getAgencyFlag());
						listinfos.add(info4);

						schemeInfo.setExtInfo(listinfos);
						listupdate.add(schemeInfo);
					}

					//分配窗口内，如修改分交方式为【集采实施代理采购/企业自采】后，采购包不应记录【寻源人、寻源人编码】 这个把 寻源人、寻源人编码 置为空
					if ("集采实施-代理采购".equals(reqBO.getSchemeSubmitType()) || "企业自采".equals(reqBO.getSchemeSubmitType()) ){
						if (StringUtils.isEmpty(reqBO.getImplCode()) && StringUtils.isEmpty(reqBO.getImplName())){
							//记录包ids
							List<Long> collect = qrySchemeDetail.getSscQrySchemeDetailBO().getSscSchemePack().stream().filter(e -> e.getPackId() != null).map(SscSchemePackBO::getPackId).collect(Collectors.toList());
							clearPackIds.addAll(collect);
						}
					}
				}
				//先删除方案上的采购员信息
				{
					//先删除方案上的采购员信息
					SscCommonDo deleteSscCommonDo = new SscCommonDo();



					SscExtObjInfo deleteSchemeExtInfo = new SscExtObjInfo();
					deleteSchemeExtInfo.setObjType("ssc_scheme_ext");
					deleteSchemeExtInfo.setOrderId(schemeId);
					deleteSchemeExtInfo.setObjId(schemeId);


					List<SscExtInfo> deleteSchemeExtInfoList = new ArrayList<>();

					SscExtInfo deleteSchemeExtInfo1 = new SscExtInfo();
					deleteSchemeExtInfo1.setFieldCode("purchaseUserId");
					deleteSchemeExtInfoList.add(deleteSchemeExtInfo1);

					SscExtInfo deleteSchemeExtInfo2 = new SscExtInfo();
					deleteSchemeExtInfo2.setFieldCode("purchaseUserCode");
					deleteSchemeExtInfoList.add(deleteSchemeExtInfo2);

					SscExtInfo deleteSchemeExtInfo3 = new SscExtInfo();
					deleteSchemeExtInfo3.setFieldCode("purchaseUserName");
					deleteSchemeExtInfoList.add(deleteSchemeExtInfo3);

					deleteSchemeExtInfo.setExtInfo(deleteSchemeExtInfoList);


					for (SscSchemePackBO ssc : qrySchemeDetail.getSscQrySchemeDetailBO().getSscSchemePack()) {
						SscExtObjInfo deletePackExtInfo2 = new SscExtObjInfo();
						deletePackExtInfo2.setObjType("ssc_scheme_pack_ext");
						deletePackExtInfo2.setOrderId(schemeId);
						deletePackExtInfo2.setObjId(ssc.getPackId());
						deletePackExtInfo2.setExtInfo(deleteSchemeExtInfoList);
						deleteExtObjInfoList.add(deletePackExtInfo2);
					}


					deleteExtObjInfoList.add(deleteSchemeExtInfo);

					deleteSscCommonDo.setExtObjInfos(deleteExtObjInfoList);

					iSscCommonModel.deleteExtInfo(deleteSscCommonDo);

				}
				//把 寻源人、寻源人编码 置为空 的包ids，分配窗口内，如修改分交方式为【集采实施代理采购/企业自采】后，采购包不应记录【寻源人、寻源人编码】 这个把 寻源人、寻源人编码 置为空
				if (!CollectionUtils.isEmpty(clearPackIds)){
					SscQrySchemePackExtReqBO packExtReqBO = new SscQrySchemePackExtReqBO();
					packExtReqBO.setPackIds(clearPackIds);
					sscQrySchemePackExtModel.updateSchemePackImplCodeExect(packExtReqBO);
				}
				sscCommonDoupdate.setExtObjInfos(listupdate);
				sscCommonDoadd.setExtObjInfos(listadd);
				if (!CollectionUtils.isEmpty(listadd)) {
					iSscCommonModel.addExtInfo(sscCommonDoadd);
				}
				if (!CollectionUtils.isEmpty(listupdate)) {
					iSscCommonModel.updateExtInfo(sscCommonDoupdate);
				}
				if (reqBO.getTableId()!=null && (reqBO.getTableId() ==1 || reqBO.getTableId() ==2)){
					//操作页面，1 是集采计划包分配页面下面进行分配  2 是 系统自动分配
					//此时需要记录 分配的人是谁
					if (!StringUtils.isEmpty(reqBO.getUsername()) && !StringUtils.isEmpty(reqBO.getName())){
						//先删除扩展字段
						SscCommonDo deleteSscCommonDo = new SscCommonDo();

						List<SscExtObjInfo> deleteExtOperObjInfoList = new ArrayList<>();
						SscExtObjInfo deleteSchemeExtInfo = new SscExtObjInfo();
						deleteSchemeExtInfo.setObjType("ssc_scheme_ext");
						deleteSchemeExtInfo.setOrderId(schemeId);
						deleteSchemeExtInfo.setObjId(schemeId);
						List<SscExtInfo> deleteSchemeExtInfoList = new ArrayList<>();

						SscExtInfo deleteSchemeExtInfo1 = new SscExtInfo();
						deleteSchemeExtInfo1.setFieldCode("assignerUserCode");
						deleteSchemeExtInfoList.add(deleteSchemeExtInfo1);

						SscExtInfo deleteSchemeExtInfo2 = new SscExtInfo();
						deleteSchemeExtInfo2.setFieldCode("assignerUserName");
						deleteSchemeExtInfoList.add(deleteSchemeExtInfo2);

						deleteSchemeExtInfo.setExtInfo(deleteSchemeExtInfoList);

						deleteExtOperObjInfoList.add(deleteSchemeExtInfo);
						deleteSscCommonDo.setExtObjInfos(deleteExtOperObjInfoList);
						iSscCommonModel.deleteExtInfo(deleteSscCommonDo);
						//再新增
						SscCommonDo sscCommonOperDoadd = new SscCommonDo();
						List<SscExtObjInfo> listOperAdd = new ArrayList<>();
						List<SscExtInfo> listExtInfos = new ArrayList<>();
						SscExtInfo ExtInfo1 = new SscExtInfo();
						ExtInfo1.setFieldCode("assignerUserCode");
						ExtInfo1.setFieldName("分配人编码");
						ExtInfo1.setFieldValue(reqBO.getUsername() + "");
						SscExtInfo ExtInfo2 = new SscExtInfo();
						ExtInfo2.setFieldCode("assignerUserName");
						ExtInfo2.setFieldName("分配人名称");
						ExtInfo2.setFieldValue(reqBO.getName());

						listExtInfos.add(ExtInfo1);
						listExtInfos.add(ExtInfo2);

						SscExtObjInfo schemeExtInfo2 = new SscExtObjInfo();
						schemeExtInfo2.setObjType("ssc_scheme_ext");
						schemeExtInfo2.setOrderId(schemeId);
						schemeExtInfo2.setObjId(schemeId);
						schemeExtInfo2.setExtInfo(listExtInfos);
						listOperAdd.add(schemeExtInfo2);
						sscCommonOperDoadd.setExtObjInfos(listOperAdd);
						iSscCommonModel.addExtInfo(sscCommonOperDoadd);
					}
				}
				if (PackBOList != null) {
					SscUpdatePackMainBatchReqBO sscUpdatePackMainBatchReqBO = new SscUpdatePackMainBatchReqBO();
					sscUpdatePackMainBatchReqBO.setSscSchemePack(PackBOList);
					sscUpdatePackMainBatchService.updateSchemeBatchMain(sscUpdatePackMainBatchReqBO);
				}
				//调换一下位置让包的信息能同步到es中
				// 修改方案主表
				SscUpdateSchemeMainReqBO sscUpdateSchemeMainReqBO = new SscUpdateSchemeMainReqBO();
				sscUpdateSchemeMainReqBO.setSchemeId(schemeId);
				sscUpdateSchemeMainReqBO.setRemark(reqBO.getRemark());
				if ("企业自采".equals(reqBO.getSchemeSubmitType())) {
					/**
					 * 1、采购方案审批修改企业自采-【是否非招代理】为【是】时，需修改【寻源代理机构】和【委托采购】，【集采计划包分配-分配】同理；
					 * 2、当【是否非招代理】=是，更新【委托采购】=委托、【代理机构】=平台公司；=否，不更新。
					 */
					if ("是".equals(reqBO.getAgencyFlag())){
						sscUpdateSchemeMainReqBO.setAgencyName("平台公司");
						sscUpdateSchemeMainReqBO.setOrganizationForm("1");
					}
				}

				sscUpdateSchemeMainService.updateSchemeMain(sscUpdateSchemeMainReqBO);
			}
		}
		log.info("---------------------方案分配完成----------------------");
		rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
		rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
		return rspBO;
	}

	@Override
	public SscSchemeAllocationExtRspBO synEsSchemeExt(SscSchemeAllocationExtReqBO reqBO) {
		SscSchemeAllocationExtRspBO rspBO = new SscSchemeAllocationExtRspBO();
		rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
		rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
		return rspBO;
	}
}
