package com.tydic.dyc.ssc.service.scheme;

import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemePackExtReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemePackExtRspBO;
import com.tydic.dyc.ssc.service.scheme.constant.RspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

/**
 * 描述:
 *
 * @author XiaWD
 * @date 2023/4/13 15:46
 * @Copyright: 2022 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于深圳天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目
 */
@HTServiceImpl
public class SscQrySchemePackExtServieImpl implements SscQrySchemePackExtServie {
    @Autowired
    private SscQrySchemePackExtModel sscQrySchemePackExtModel;
    @Override
    public SscQrySchemePackExtRspBO qryPackBySchemeIds(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();

        if (CollectionUtils.isEmpty(reqBO.getSchemeIds())){
            rspBO.setRespCode(RspConstant.RESP_CODE_ERROR);
            rspBO.setRespDesc("入参方案ids 不能为空");
            return rspBO;
        }
        return sscQrySchemePackExtModel.qryPackBySchemeIds(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO qrySchemeExect(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.qrySchemeExect(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO qryPackByPackIds(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.qryPackByPackIds(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO updateSchemePackImplCodeExect(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.updateSchemePackImplCodeExect(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO updatePackPackStatus(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.updatePackPackStatus(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO qrySchemeExist(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.qrySchemeExist(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO syncAddPackByPackIds(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO syncDeletePackByPackIds(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO qrySchemeAuditProclnstld(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.qrySchemeAuditProclnstld(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO qryPackStatusBySchemeIdsOrpackIds(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.qryPackStatusBySchemeIdsOrpackIds(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO updatePackageAllocation(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.updatePackageAllocation(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO updateClearSchemeSchemeExectStatus(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.updateClearSchemeSchemeExectStatus(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO qryNonRecruitmentIdBySchemeIds(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.qryNonRecruitmentIdBySchemeIds(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO syncPushStatus(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.syncPushStatus(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO syncPackPushStatus(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.syncPackPushStatus(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO qryPushStatus(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.qryPushStatus(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO qryPackPushStatus(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.qryPackPushStatus(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO updateCommonItemNo(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.updateCommonItemNo(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO syncSchemeES(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_CODE_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO syncPushErpStatus(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_CODE_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO verifySchemeNo(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.verifySchemeNo(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO updatePackImplCodeDefault(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.updatePackImplCodeDefault(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO qryPlanMatBySchemeId(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.qryPlanMatBySchemeId(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO qryTotalExpectMoneySum(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.qryTotalExpectMoneySum(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO updateSchemeMatNullValueBatch(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.updateSchemeMatNullValueBatch(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO syncSchemePackES(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_CODE_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO deleteAllInviteSupDraft(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.deleteAllInviteSupDraft(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO updateSchemePackAssignStatusExect(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.updateSchemePackAssignStatusExect(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO qrySchemeSubmitType(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.qrySchemeSubmitType(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO syncSchemeESBySchemeIds(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_CODE_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO addChangeDistributionModeLog(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.addChangeDistributionModeLog(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO qryChangeDistributionModeLogList(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.qryChangeDistributionModeLogList(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO qryIsExistChangeDistributionModeLog(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.qryIsExistChangeDistributionModeLog(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO qrySchemeOrganizationFormByPackIds(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.qrySchemeOrganizationFormByPackIds(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO updateSchemeNullField(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.updateSchemeNullField(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO addBasisFile(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.addBasisFile(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO addBasisFileBuildFail(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.addBasisFileBuildFail(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO updateBasisFileBuildFail(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.updateBasisFileBuildFail(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO qryBasisFileBuildFail(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.qryBasisFileBuildFail(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO qryBasisFileInit(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.qryBasisFileInit(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO updateBasisFileInit(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.updateBasisFileInit(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO qryBasisFileList(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.qryBasisFileList(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO qryImplInfoBySchemeIds(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.qryImplInfoBySchemeIds(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO syncTaskBySchemeId(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_CODE_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO addJoinSignLogBOS(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.addJoinSignLogBOS(reqBO);
    }

    @Override
    public SscQrySchemePackExtRspBO qryJoinSignLogBOS(SscQrySchemePackExtReqBO reqBO) {
        return sscQrySchemePackExtModel.qryJoinSignLogBOS(reqBO);
    }

}
