package com.tydic.dyc.ssc.model.scheme.impl;

import com.tydic.dyc.ssc.model.SchemeTenderReportListModel;
import com.tydic.dyc.ssc.repository.SchemeTenderReportListRepository;
import com.tydic.dyc.ssc.service.scheme.bo.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 采购方案定标接口
 *
 * @author hcl
 * @since 2023-07-31 15:26:20
 */
@Service
public class SchemeTenderReportListModelImpl implements SchemeTenderReportListModel {
    @Autowired
    private SchemeTenderReportListRepository schemeTenderReportListRepository;


    @Override
    public SchemeTenderReportListRspBO getTenderReportList(SchemeTenderReportReqBO reqBO) {
        return schemeTenderReportListRepository.getTenderReportList(reqBO);
    }

    @Override
    public SscSchemeAmountRspBO updateSchemeAmountDeduction(SscSchemeSchemeAmountDeductionReqBO reqBO) {
        return schemeTenderReportListRepository.updateSchemeAmountDeduction(reqBO);
    }

    @Override
    public SchemePurchaseQuotationRspBO getPurchaseQuotation(SscSchemeSPurchaseQuotationReqBO reqBO) {
        return schemeTenderReportListRepository.getPurchaseQuotation(reqBO);
    }
}


