package com.tydic.dyc.ssc.service.scheme;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.ssc.model.SchemeAmountModel;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeAmountReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeAmountRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeGetCanOrderNumAtomRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscUpdateSchemeAmountReqBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/**
 * 方案物料信息(SscSchemeMat)表数据库访问层
 *
 * @author hcl
 * @since 2023-07-31 15:26:20
 */
@HTServiceImpl
public class SchemeAmountServiceImpl implements SchemeAmountService {
    @Autowired
    private SchemeAmountModel schemeAmountModel;


    @Override
    public SscSchemeAmountRspBO updateSchemeOrderAmount(SscSchemeAmountReqBO reqBO) {
        this.verifyScheme(reqBO);
        return schemeAmountModel.updateSchemeOrderAmount(reqBO);
    }

    @Override
    public SscSchemeGetCanOrderNumAtomRspBO getCanOrderNum(SscSchemeAmountReqBO reqBO) {
        this.verifyQryScheme(reqBO);
        return schemeAmountModel.getCanOrderNum(reqBO);
    }

    @Override
    public SscSchemeAmountRspBO updateDdCount(SscUpdateSchemeAmountReqBO reqBO) {
        return schemeAmountModel.updateDdCount(reqBO);
    }

    /**
     * 入参校验
     *
     * @param reqBO
     */
    private void verifyScheme(SscSchemeAmountReqBO reqBO) {

        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空");
        }
        if (CollectionUtils.isEmpty(reqBO.getOrderItem())) {
            throw new ZTBusinessException("入参不能为空");
        }
        reqBO.getOrderItem().forEach(
                e -> {
                    if (StringUtils.isEmpty(e.getOrderNum())) {
                        throw new ZTBusinessException("订单数量不能为空");
                    }
                    if (StringUtils.isEmpty(e.getGoodTypeId())) {
                        throw new ZTBusinessException("订单行id不能为空");
                    }
                    if (StringUtils.isEmpty(e.getOperateType())) {
                        throw new ZTBusinessException("操作类型不能为空");
                    }
                }
        );
    }

    /**
     * 入参校验
     *
     * @param reqBO
     */
    private void verifyQryScheme(SscSchemeAmountReqBO reqBO) {

        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空");
        }
        if (CollectionUtils.isEmpty(reqBO.getOrderItem())) {
            throw new ZTBusinessException("入参不能为空");
        }
        reqBO.getOrderItem().forEach(
                e -> {
                    if (StringUtils.isEmpty(e.getGoodTypeId())) {
                        throw new ZTBusinessException("订单行id不能为空");
                    }
                }
        );
    }

}
