package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.ssc.model.SscAwardResultPackExtModel;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscQryAwardResultExtBO;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscQryAwardResultExtReqBO;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscQryAwardResultExtRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.*;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 标题：采购方案询比结果列表分页查询
 * 时间：2023/08/07
 */
@HTServiceImpl
public class SscGetAwardResultExtServiceImpl implements SscSchemeMatGetAwardResultExtService {

    /**
     * 采购方案询比结果模型层
     */
    @Autowired
    private SscAwardResultPackExtModel sscAwardResultPackExtModel;

    /**
     * 采购方案询比结果列表分页查询
     */
    @Override
    public SscGetAwardResultExtRspBO getAwardResultList(SscGetAwardResultExtReqBO reqBO) {
        //入参转换
        SscQryAwardResultExtReqBO sscQryAwardResultExtReqBO = JSON.parseObject(JSON.toJSONString(reqBO), SscQryAwardResultExtReqBO.class);

        //调用购方案询比结果模型层，采购方案询比结果列表分页查询
        SscQryAwardResultExtRspBO sscQryAwardResultExtRspBO = this.sscAwardResultPackExtModel.getAwardResultList(sscQryAwardResultExtReqBO);

        //出参转换
        SscGetAwardResultExtRspBO rspBO = JSON.parseObject(JSON.toJSONString(sscQryAwardResultExtRspBO), SscGetAwardResultExtRspBO.class);

        //封装出参数据
        this.packingRspData(sscQryAwardResultExtRspBO, rspBO);

        return rspBO;
    }

    /**
     * 封装出参数据
     */
    private void packingRspData(SscQryAwardResultExtRspBO sscQryAwardResultExtRspBO, SscGetAwardResultExtRspBO rspBO){
        if (!CollectionUtils.isEmpty(sscQryAwardResultExtRspBO.getRows())){
            //出参集合去重
            List<SscGetAwardResultExtBO> sscGetAwardResultExtBOList = rspBO.getRows().stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(bo -> bo.getCompanyCode() + "_" + bo.getAwardId()))), ArrayList::new));
            //设置数据
            rspBO.setRows(sscGetAwardResultExtBOList);

            //获取采购方案询比结果明细Map
            Map<String, List<SscQryAwardResultExtBO>> sscQryAwardResultExtBOMap = sscQryAwardResultExtRspBO.getRows().stream().collect(Collectors.groupingBy(bo -> bo.getCompanyCode() + "_" + bo.getAwardId()));

            for (SscGetAwardResultExtBO bo : rspBO.getRows()) {
                if (!CollectionUtils.isEmpty(sscQryAwardResultExtBOMap.get(bo.getCompanyCode() + "_" + bo.getAwardId()))){

                    //转换采购方案询比结果明细
                    List<SscGetAwardResultItemExtBO> sscGetAwardResultItemExtBOList = JSON.parseArray(JSON.toJSONString(sscQryAwardResultExtBOMap.get(bo.getCompanyCode() + "_" + bo.getAwardId())), SscGetAwardResultItemExtBO.class);

                    //转义结果明细出参数据
                    this.translateRspResultItemData(sscGetAwardResultItemExtBOList);

                    //设置采购方案询比结果明细
                    bo.setItemResultVoList(sscGetAwardResultItemExtBOList);

                }
            }
        }
    }

    /**
     * 转义结果明细出参数据
     */
    private void translateRspResultItemData(List<SscGetAwardResultItemExtBO> sscGetAwardResultItemExtBOList){
        if (!CollectionUtils.isEmpty(sscGetAwardResultItemExtBOList)){
            //遍历
            for (SscGetAwardResultItemExtBO bo : sscGetAwardResultItemExtBOList) {
                //判断采购方式不为空
                if (ObjectUtil.isNotEmpty(bo.getDycBuyType())){
                    switch (bo.getDycBuyType()){
                        case 0:
                            bo.setDycBuyType(1); //公开招标
                            break;
                        case 1:
                            bo.setDycBuyType(2); //邀请招标
                            break;
                        case 7:
                            bo.setDycBuyType(3); //公开询比
                            break;
                        case 8:
                            bo.setDycBuyType(4); //邀请询比
                            break;
                        case 13:
                            bo.setDycBuyType(5); //公开竞价
                            break;
                        case 14:
                            bo.setDycBuyType(6); //邀请竞价
                            break;
                        case 11:
                            bo.setDycBuyType(7); //公开竞谈
                            break;
                        case 12:
                            bo.setDycBuyType(8); //邀请竞谈
                            break;
                        case 6:
                            bo.setDycBuyType(9); //单一来源
                            break;
                        case 9:
                            bo.setDycBuyType(10); //直接采购
                            break;
                        case 10:
                            bo.setDycBuyType(11); //直接采购(执行协议)
                            break;
                    }
                }
                //赋值参数erpDeptCode
                bo.setErpDeptCode(bo.getDecCompanyCode());
            }
        }
    }
}


